/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.AbstractCsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsInPlannedOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsOutPlannedOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsQualityInfoDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutPlannedOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsInventorySupplierDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsQualityInfoDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsInventorySupplierEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutPlannedOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutMatchRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.basics.CsInOutBasicsOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderItemStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseFutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="Csplanned_orderBusinessOrderCallBackService")
public class CsPlannedOrderCallBackServiceImpl
extends AbstractCsBusinessOrderCallBackService
implements ICsBusinessOrderCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(CsPlannedOrderCallBackServiceImpl.class);
    @Autowired
    CsInPlannedOrderMapper csInPlannedOrderMapper;
    @Autowired
    CsOutPlannedOrderMapper csOutPlannedOrderMapper;
    @Autowired
    CsInPlannedOrderDetailMapper csInPlannedOrderDetailMapper;
    @Autowired
    CsOutPlannedOrderDetailMapper csOutPlannedOrderDetailMapper;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    ICsOutPlannedOrderService csOutPlannedOrderService;
    @Resource
    CsOutPlannedOrderDas outPlannedOrderDas;
    @Resource
    CsQualityInfoDetailDas qualityInfoDetailDas;
    @Resource
    CsInventorySupplierDas csInventorySupplierDas;
    @Autowired
    ICsInPlannedOrderService csInPlannedOrderService;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;

    @Override
    public String getStrategy() {
        return this.getPrefix() + "planned_order";
    }

    @Override
    public Boolean deliveryReceiveNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        if (callBackContext.getInFlag().booleanValue()) {
            this.futureIn(callBackContext);
        }
        return true;
    }

    private void futureIn(CsOrderBusinessCallBackContext callBackContext) {
        CsBasicsOrderReqDto csBasicsOrderReqDto = callBackContext.getCsBasicsOrderReqDto();
        FutureInDto futureInParam = new FutureInDto();
        futureInParam.setSourceNo(csBasicsOrderReqDto.getRelevanceNo());
        futureInParam.setSourceType(csBasicsOrderReqDto.getBusinessType());
        futureInParam.setBusinessType(csBasicsOrderReqDto.getBusinessType());
        ArrayList detailParams = Lists.newArrayList();
        for (CsBasicsOrderDetailReqDto detailReqDto : csBasicsOrderReqDto.getOrderBasicsDetailReqDtoList()) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal futureInNum = BigDecimalUtils.abs((BigDecimal)detailReqDto.getQuantity());
            detailParam.setNum(futureInNum);
            detailParam.setSkuCode(detailReqDto.getLongCode());
            String warehouseCode = StringUtils.isNotBlank((CharSequence)csBasicsOrderReqDto.getLogicWarehouseCode()) ? csBasicsOrderReqDto.getLogicWarehouseCode() : csBasicsOrderReqDto.getInLogicWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            detailParam.setExpireDate(detailReqDto.getExpireTime());
            detailParam.setProduceDate(detailReqDto.getProduceTime());
            detailParams.add(detailParam);
            futureInParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
        }
        futureInParam.setDetails((List)detailParams);
        this.calcInventoryService.futureIn(futureInParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean inOutResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return true;
    }

    private void updateInPlanOrderStatus(String orderNo, String status) {
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        csInPlannedOrderEo.setOrderStatus(status);
        csInPlannedOrderEoQueryWrapper.clear();
        csInPlannedOrderEoQueryWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)csInPlannedOrderEoQueryWrapper);
    }

    private void updateOutPlanOrderStatus(String orderNo, String status) {
        QueryWrapper csOutPlannedOrderEoQueryWrapper = new QueryWrapper();
        csOutPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        csOutPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsOutPlannedOrderEo csInPlannedOrderEo = (CsOutPlannedOrderEo)this.csOutPlannedOrderMapper.selectOne((Wrapper)csOutPlannedOrderEoQueryWrapper);
        csInPlannedOrderEo.setOrderStatus(status);
        csOutPlannedOrderEoQueryWrapper.clear();
        csOutPlannedOrderEoQueryWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csOutPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)csOutPlannedOrderEoQueryWrapper);
    }

    @Override
    public Boolean deliveryReceiveResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u8ba1\u5212\u5355\u636e(\u91c7\u8d2d\u3001\u751f\u4ea7\u3001\u59d4\u5916),relieveOverchargeCallBack==>\u76f4\u63a5\u89e3\u6302\u56de\u8c03,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        String status = CsPlannedOrderStatusEnum.COMPLETED.getCode();
        if (callBackContext.getInFlag().booleanValue()) {
            if (callBackContext.getPortionFlag().booleanValue()) {
                status = CsPlannedOrderStatusEnum.PORTION_IN.getCode();
            }
            this.updateInPlanOrderStatus(callBackContext.getRelevanceNo(), status);
        } else {
            if (callBackContext.getPortionFlag().booleanValue()) {
                status = CsPlannedOrderStatusEnum.PORTION_OUT.getCode();
            }
            this.updateOutPlannedOrderDetail(callBackContext.getRelevanceNo());
            this.updateOutPlanOrderStatus(callBackContext.getRelevanceNo(), status);
        }
        return true;
    }

    private void updateOutPlannedOrderDetail(String relevanceNo) {
        List deliveryNoticeOrderDetailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByRelevanceNo(relevanceNo);
        Map<Long, ReceiveDeliveryNoticeOrderDetailEo> deliveryNoticeOrderDetailEoMap = deliveryNoticeOrderDetailEoList.stream().collect(Collectors.toMap(ReceiveDeliveryNoticeOrderDetailEo::getPreOrderItemId, entity -> entity));
        List outPlannedOrderDetailEoList = this.csOutPlannedOrderDetailMapper.queryByRelevanceNo(relevanceNo);
        for (CsOutPlannedOrderDetailEo csOutPlannedOrderDetailEo : outPlannedOrderDetailEoList) {
            ReceiveDeliveryNoticeOrderDetailEo deliveryNoticeOrderDetailEo = deliveryNoticeOrderDetailEoMap.get(csOutPlannedOrderDetailEo.getId());
            if (null == deliveryNoticeOrderDetailEo) continue;
            csOutPlannedOrderDetailEo.setWaitQuantity(deliveryNoticeOrderDetailEo.getWaitQuantity());
            csOutPlannedOrderDetailEo.setDoneQuantity(deliveryNoticeOrderDetailEo.getDoneQuantity());
            this.csOutPlannedOrderDetailMapper.updateById((BaseEo)csOutPlannedOrderDetailEo);
        }
    }

    @Override
    public Boolean relieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u8ba1\u5212\u5355\u636e,relieveOverchargeCallBack==>\u76f4\u63a5\u89e3\u6302\u56de\u8c03,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        return false;
    }

    private Boolean outRelieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u8ba1\u5212\u5355\u636e,outRelieveOverchargeCallBack==>\u8ba1\u5212\u5355\u636e\u51fa\u5e93\u8d85\u53d1\u7684\u89e3\u6302,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        CsInOutResultRespDto csInOutResultRespDto = callBackContext.getCsInOutResultRespDto();
        Boolean relieveFlag = callBackContext.getRelieveFlag();
        List inOutResultDetailRespDtoList = csInOutResultRespDto.getInOutResultDetailRespDtoList();
        if (null != csInOutResultRespDto && CollectionUtils.isNotEmpty((Collection)inOutResultDetailRespDtoList)) {
            InOutResultOrderEo InOutResultOrderEo2 = new InOutResultOrderEo();
            CubeBeanUtils.copyProperties((Object)InOutResultOrderEo2, (Object)csInOutResultRespDto, (String[])new String[0]);
            ArrayList csOutResultOrderDetailEoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)csOutResultOrderDetailEoList, (Collection)inOutResultDetailRespDtoList, InOutResultOrderDetailEo.class);
            this.outInventoryByOverchargeList(InOutResultOrderEo2, csOutResultOrderDetailEoList, relieveFlag);
            this.updateOutPurchaseOrderInfo(InOutResultOrderEo2, csOutResultOrderDetailEoList);
        }
        return true;
    }

    @Override
    public Boolean overchargeAdjustCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u8ba1\u5212\u5355\u636e,overchargeAdjustCallBack==>\u76f4\u63a5\u89e3\u6302\u56de\u8c03,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        Boolean inFlag = callBackContext.getInFlag();
        return false;
    }

    public Boolean wmsInCallBack(CsOrderBusinessCallBackContext callBackContext) {
        this.updatePlannedOrderInfo(callBackContext);
        Boolean overchargeFlag = callBackContext.getOverchargeFlag();
        if (!overchargeFlag.booleanValue()) {
            this.updateInventoryInfo(callBackContext);
        }
        return true;
    }

    private void updateInventoryInfo(CsOrderBusinessCallBackContext callBackContext) {
        String relevanceNo = callBackContext.getRelevanceNo();
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        this.operateInventory(csInPlannedOrderEo, callBackContext.getInResultOrderNo(), callBackContext);
    }

    private void updateOutInventoryInfo(CsOrderBusinessCallBackContext callBackContext) {
        String relevanceNo = callBackContext.getRelevanceNo();
        CsOutPlannedOrderEo csOutPlannedOrderEo = this.getCsOutPlannedOrderEo(relevanceNo);
        this.operateOutInventory(csOutPlannedOrderEo, callBackContext.getInResultOrderNo(), callBackContext.getPortionFlag());
    }

    private CsOutPlannedOrderEo getCsOutPlannedOrderEo(String relevanceNo) {
        QueryWrapper outPlannedOrderEoQueryWrapper = new QueryWrapper();
        outPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        outPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        return (CsOutPlannedOrderEo)this.csOutPlannedOrderMapper.selectOne((Wrapper)outPlannedOrderEoQueryWrapper);
    }

    private CsInPlannedOrderEo getCsInPlannedOrderEo(String relevanceNo) {
        QueryWrapper inPlannedOrderEoQueryWrapper = new QueryWrapper();
        inPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        inPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        return (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)inPlannedOrderEoQueryWrapper);
    }

    private void operateInventory(CsInPlannedOrderEo csInPlannedOrderEo, String inResultOrderNo, CsOrderBusinessCallBackContext callBackContext) {
        this.csInPlannedOrderService.updateInventoryFoyPlannedOrder(csInPlannedOrderEo, inResultOrderNo, callBackContext);
    }

    private void operateOutInventory(CsOutPlannedOrderEo csOutPlannedOrderEo, String outResultOrderNo, Boolean portionFlag) {
        this.csOutPlannedOrderService.updateInventoryFoyOutPlannedOrder(csOutPlannedOrderEo, outResultOrderNo, portionFlag);
    }

    public Boolean wmsOutCallBack(CsOrderBusinessCallBackContext callBackContext) {
        this.updateOutPlannedOrderInfo(callBackContext);
        Boolean overchargeFlag = callBackContext.getOverchargeFlag();
        if (!overchargeFlag.booleanValue()) {
            this.updateOutInventoryInfo(callBackContext);
        }
        return true;
    }

    private void updatePlannedOrderInfo(CsOrderBusinessCallBackContext callBackContext) {
        Boolean overchargeFlag = callBackContext.getOverchargeFlag();
        Boolean portionFlag = callBackContext.getPortionFlag();
        String relevanceNo = callBackContext.getRelevanceNo();
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        QueryWrapper csInPlannedOrderDetailEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderDetailEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        csInPlannedOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csInPlannedOrderDetailEoList = this.csInPlannedOrderDetailMapper.selectList((Wrapper)csInPlannedOrderDetailEoQueryWrapper);
        CsInPlannedOrderDetailEo csInPlannedOrderDetailEo = (CsInPlannedOrderDetailEo)csInPlannedOrderDetailEoList.get(0);
        if (overchargeFlag.booleanValue()) {
            csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.HANG_UP.getCode());
        } else if (!overchargeFlag.booleanValue()) {
            csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.COMPLETED.getCode());
            if (portionFlag.booleanValue()) {
                csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.PORTION_IN.getCode());
            }
        }
        csInPlannedOrderEoQueryWrapper.clear();
        csInPlannedOrderEoQueryWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)csInPlannedOrderEoQueryWrapper);
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)relevanceNo);
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"in");
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        QueryWrapper csInNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        csInNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)InOutNoticeOrderEo2.getDocumentNo());
        csInNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csInNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)csInNoticeOrderDetailEoQueryWrapper);
        ArrayList insertEoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)csInNoticeOrderDetailEoList)) {
            QueryWrapper updateDetailWrapper = new QueryWrapper();
            updateDetailWrapper.eq((Object)"order_no", (Object)relevanceNo);
            this.csInPlannedOrderDetailMapper.delete((Wrapper)updateDetailWrapper);
            for (InOutNoticeOrderDetailEo csInNoticeOrderDetailEo : csInNoticeOrderDetailEoList) {
                CsInPlannedOrderDetailEo insertDetailEo = new CsInPlannedOrderDetailEo();
                insertDetailEo.setPlatformOrderNo(csInPlannedOrderDetailEo.getPlatformOrderNo());
                insertDetailEo.setOrderNo(csInPlannedOrderDetailEo.getOrderNo());
                insertDetailEo.setCargoName(csInNoticeOrderDetailEo.getSkuName());
                insertDetailEo.setLongCode(csInNoticeOrderDetailEo.getSkuCode());
                insertDetailEo.setCargoCode(csInNoticeOrderDetailEo.getSkuCode());
                insertDetailEo.setBatch(csInNoticeOrderDetailEo.getBatch());
                insertDetailEo.setExpireTime(csInPlannedOrderDetailEo.getExpireTime());
                insertDetailEo.setProduceTime(csInPlannedOrderDetailEo.getProduceTime());
                insertDetailEo.setPlanQuantity(csInNoticeOrderDetailEo.getPlanQuantity());
                insertDetailEo.setWaitQuantity(csInNoticeOrderDetailEo.getWaitQuantity());
                insertDetailEo.setDoneQuantity(csInNoticeOrderDetailEo.getDoneQuantity());
                insertDetailEo.setCancelQuantity(csInNoticeOrderDetailEo.getCancelQuantity());
                insertDetailEo.setRemark(csInNoticeOrderDetailEo.getRemark());
                insertDetailEo.setItemStatus(csInNoticeOrderDetailEo.getItemStatus());
                insertDetailEo.setDr(csInNoticeOrderDetailEo.getDr());
                insertDetailEo.setInitFlag(csInNoticeOrderDetailEo.getInitFlag());
                insertDetailEo.setExtension(csInNoticeOrderDetailEo.getExtension());
                insertEoList.add(insertDetailEo);
            }
            this.csInPlannedOrderDetailMapper.insertBatch((List)insertEoList);
        }
        if (CsPlannedOrderStatusEnum.COMPLETED.getCode().equals(csInPlannedOrderEo.getOrderStatus()) && (CsPlannedOrderTypeEnum.OUTSOURCE.getCode().equals(csInPlannedOrderEo.getOrderType()) || CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(csInPlannedOrderEo.getOrderType()))) {
            this.addQualityDetail(csInPlannedOrderEo, CollectionUtils.isNotEmpty((Collection)insertEoList) ? insertEoList : csInPlannedOrderDetailEoList);
        }
    }

    private void updateOutPlannedOrderInfo(CsOrderBusinessCallBackContext callBackContext) {
        Boolean overchargeFlag = callBackContext.getOverchargeFlag();
        Boolean portionFlag = callBackContext.getPortionFlag();
        String relevanceNo = callBackContext.getRelevanceNo();
        CsOutPlannedOrderEo csOutPlannedOrderEo = this.getCsOutPlannedOrderEo(relevanceNo);
        QueryWrapper csOutPlannedOrderDetailEoQueryWrapper = new QueryWrapper();
        csOutPlannedOrderDetailEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        csOutPlannedOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csOutPlannedOrderDetailEoList = this.csOutPlannedOrderDetailMapper.selectList((Wrapper)csOutPlannedOrderDetailEoQueryWrapper);
        CsOutPlannedOrderDetailEo csOutPlannedOrderDetailEo = (CsOutPlannedOrderDetailEo)csOutPlannedOrderDetailEoList.get(0);
        CsOutPlannedOrderEo outPlannedOrderEo = new CsOutPlannedOrderEo();
        if (overchargeFlag.booleanValue()) {
            outPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.HANG_UP.getCode());
        } else {
            outPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.COMPLETED.getCode());
            if (portionFlag.booleanValue()) {
                outPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.PORTION_OUT.getCode());
            }
        }
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)relevanceNo);
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"out");
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        QueryWrapper inOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)InOutNoticeOrderEo2.getDocumentNo());
        inOutNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List InOutNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)inOutNoticeOrderDetailEoQueryWrapper);
        ArrayList insertEoList = Lists.newArrayList();
        BigDecimal doneOutQuantity = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderDetailEoList)) {
            doneOutQuantity = InOutNoticeOrderDetailEoList.stream().map(InOutNoticeOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            QueryWrapper updateDetailWrapper = new QueryWrapper();
            updateDetailWrapper.eq((Object)"order_no", (Object)relevanceNo);
            this.csOutPlannedOrderDetailMapper.delete((Wrapper)updateDetailWrapper);
            for (InOutNoticeOrderDetailEo InOutNoticeOrderDetailEo2 : InOutNoticeOrderDetailEoList) {
                CsOutPlannedOrderDetailEo insertDetailEo = new CsOutPlannedOrderDetailEo();
                insertDetailEo.setPlatformOrderNo(csOutPlannedOrderDetailEo.getPlatformOrderNo());
                insertDetailEo.setOrderNo(csOutPlannedOrderDetailEo.getOrderNo());
                insertDetailEo.setCargoName(InOutNoticeOrderDetailEo2.getSkuName());
                insertDetailEo.setLongCode(InOutNoticeOrderDetailEo2.getSkuCode());
                insertDetailEo.setCargoCode(InOutNoticeOrderDetailEo2.getSkuCode());
                insertDetailEo.setBatch(InOutNoticeOrderDetailEo2.getBatch());
                insertDetailEo.setExpireTime(csOutPlannedOrderDetailEo.getExpireTime());
                insertDetailEo.setProduceTime(csOutPlannedOrderDetailEo.getProduceTime());
                insertDetailEo.setPlanQuantity(InOutNoticeOrderDetailEo2.getPlanQuantity());
                insertDetailEo.setWaitQuantity(InOutNoticeOrderDetailEo2.getWaitQuantity());
                insertDetailEo.setDoneQuantity(InOutNoticeOrderDetailEo2.getDoneQuantity());
                insertDetailEo.setCancelQuantity(InOutNoticeOrderDetailEo2.getCancelQuantity());
                insertDetailEo.setRemark(InOutNoticeOrderDetailEo2.getRemark());
                insertDetailEo.setItemStatus(InOutNoticeOrderDetailEo2.getItemStatus());
                insertDetailEo.setInitFlag(InOutNoticeOrderDetailEo2.getInitFlag());
                insertDetailEo.setDr(InOutNoticeOrderDetailEo2.getDr());
                insertEoList.add(insertDetailEo);
            }
            this.csOutPlannedOrderDetailMapper.insertBatch((List)insertEoList);
        }
        outPlannedOrderEo.setDoneOutQuantity(doneOutQuantity);
        outPlannedOrderEo.setId(csOutPlannedOrderEo.getId());
        this.outPlannedOrderDas.updateSelective((BaseEo)outPlannedOrderEo);
    }

    private void updateInPurchaseOrderInfo(InOutResultOrderEo csInResultOrderEo, List<InOutResultOrderDetailEo> csInResultOrderDetailEoList) {
        Map csInResultOrderDetailEoMap = csInResultOrderDetailEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getBatch(), Function.identity()));
        Map<String, List<InOutResultOrderDetailEo>> outResultEoMap = csInResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
        List longCodeList = csInResultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getSkuCode).distinct().collect(Collectors.toList());
        String relevanceNo = csInResultOrderEo.getRelevanceNo();
        QueryWrapper plannedOrderDetailEoQueryWrapper = new QueryWrapper();
        plannedOrderDetailEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        plannedOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        plannedOrderDetailEoQueryWrapper.in((Object)"long_code", longCodeList);
        List csInPlannedOrderDetailEoList = this.csInPlannedOrderDetailMapper.selectList((Wrapper)plannedOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csInPlannedOrderDetailEoList), "\u8ba1\u5212\u5355\u636e\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        QueryWrapper inPlannedOrderDetailEoQueryWrapper = new QueryWrapper();
        for (CsInPlannedOrderDetailEo csInPlannedOrderDetailEo : csInPlannedOrderDetailEoList) {
            Integer initFlag = csInPlannedOrderDetailEo.getInitFlag();
            String longCode = csInPlannedOrderDetailEo.getLongCode();
            String batch = csInPlannedOrderDetailEo.getBatch();
            if (YesNoEnum.YES.getValue().equals(initFlag)) {
                List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList = outResultEoMap.get(longCode);
                if (CollectionUtils.isEmpty(csOutResultOrderDetailEoList)) continue;
                csInPlannedOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
            } else {
                String key = longCode + "_" + batch;
                InOutResultOrderDetailEo orderDetailEo = (InOutResultOrderDetailEo)csInResultOrderDetailEoMap.get(key);
                if (null == orderDetailEo) continue;
                csInPlannedOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
                csInPlannedOrderDetailEo.setDoneQuantity(orderDetailEo.getDoneQuantity());
            }
            csInPlannedOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.RELIEVE.getCode());
            inPlannedOrderDetailEoQueryWrapper.eq((Object)"id", (Object)csInPlannedOrderDetailEo.getId());
            this.csInPlannedOrderDetailMapper.update((Object)csInPlannedOrderDetailEo, (Wrapper)inPlannedOrderDetailEoQueryWrapper);
            inPlannedOrderDetailEoQueryWrapper.clear();
        }
        QueryWrapper inPlannedOrderQueryWrapper = new QueryWrapper();
        inPlannedOrderQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        inPlannedOrderQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)inPlannedOrderQueryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u8ba1\u5212\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.COMPLETED.getCode());
        inPlannedOrderQueryWrapper.clear();
        inPlannedOrderQueryWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)inPlannedOrderQueryWrapper);
    }

    private void updateOutPurchaseOrderInfo(InOutResultOrderEo InOutResultOrderEo2, List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList) {
        Map csOutResultOrderDetailEoMap = csOutResultOrderDetailEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getBatch(), Function.identity()));
        String relevanceNo = InOutResultOrderEo2.getRelevanceNo();
        QueryWrapper plannedOrderDetailEoQueryWrapper = new QueryWrapper();
        plannedOrderDetailEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        plannedOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csOutPlannedOrderDetailEoList = this.csOutPlannedOrderDetailMapper.selectList((Wrapper)plannedOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csOutPlannedOrderDetailEoList), "\u8ba1\u5212\u5355\u636e\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        QueryWrapper outPlannedOrderDetailEoQueryWrapper = new QueryWrapper();
        for (CsOutPlannedOrderDetailEo csOutPlannedOrderDetailEo : csOutPlannedOrderDetailEoList) {
            String key = csOutPlannedOrderDetailEo.getLongCode() + "_" + csOutPlannedOrderDetailEo.getBatch();
            InOutResultOrderDetailEo csOutResultOrderDetailEo = (InOutResultOrderDetailEo)csOutResultOrderDetailEoMap.get(key);
            if (null == csOutResultOrderDetailEo) continue;
            csOutPlannedOrderDetailEo.setDoneQuantity(csOutResultOrderDetailEo.getDoneQuantity());
            csOutPlannedOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
            csOutPlannedOrderDetailEo.setRemark(CsPlannedOrderItemStatusEnum.RELIEVE.getDesc());
            csOutPlannedOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.RELIEVE.getCode());
            outPlannedOrderDetailEoQueryWrapper.eq((Object)"id", (Object)csOutPlannedOrderDetailEo.getId());
            this.csOutPlannedOrderDetailMapper.update((Object)csOutPlannedOrderDetailEo, (Wrapper)outPlannedOrderDetailEoQueryWrapper);
            outPlannedOrderDetailEoQueryWrapper.clear();
        }
        QueryWrapper outPlannedOrderQueryWrapper = new QueryWrapper();
        outPlannedOrderQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        outPlannedOrderQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)this.csOutPlannedOrderMapper.selectOne((Wrapper)outPlannedOrderQueryWrapper);
        AssertUtil.isTrue(null != csOutPlannedOrderEo, "\u8ba1\u5212\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        csOutPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.COMPLETED.getCode());
        outPlannedOrderQueryWrapper.clear();
        outPlannedOrderQueryWrapper.eq((Object)"id", (Object)csOutPlannedOrderEo.getId());
        this.csOutPlannedOrderMapper.update((Object)csOutPlannedOrderEo, (Wrapper)outPlannedOrderQueryWrapper);
    }

    private void outInventoryByOverchargeList(InOutResultOrderEo InOutResultOrderEo2, List<InOutResultOrderDetailEo> overchargeList, Boolean relieveFlag) {
        logger.info("outInventoryByOverchargeList==>\u5e93\u5b58\u64cd\u4f5c\uff0c\u5c06\u660e\u7ec6\u8868\u91cc\u8bb0\u5f55\u7684\u5df2\u51fa\u5e93\u6570\u91cf\uff0c\u64cd\u4f5c\u8fdb\u884c\u51fa\u5e93,InOutResultOrderEo:{},overchargeList:{},relieveFlag:{}", new Object[]{LogUtils.buildLogContent(InOutResultOrderEo2), LogUtils.buildLogContent(overchargeList), relieveFlag});
        CsOutPlannedOrderEo csOutPlannedOrderEo = this.getCsOutPlannedOrderEo(InOutResultOrderEo2.getRelevanceNo());
        this.operateOutInventory(csOutPlannedOrderEo, InOutResultOrderEo2.getDocumentNo(), false);
    }

    public void addQualityDetail(CsInPlannedOrderEo csInPlannedOrderEo, List<CsInPlannedOrderDetailEo> csInPlannedOrderDetailEoList) {
        ArrayList qualityInfoDetailEoList = new ArrayList();
        csInPlannedOrderDetailEoList.forEach(detail -> {
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy("QualityDetail");
            String orderNo = generateCodeService.getCode();
            CsQualityInfoDetailEo qualityInfoDetailEo = new CsQualityInfoDetailEo();
            qualityInfoDetailEo.setPlatformOrderNo(csInPlannedOrderEo.getPlatformOrderNo());
            qualityInfoDetailEo.setPlannedOrderNo(orderNo);
            qualityInfoDetailEo.setOrderType(csInPlannedOrderEo.getOrderType());
            qualityInfoDetailEo.setBusinessType(csInPlannedOrderEo.getBusinessType());
            qualityInfoDetailEo.setWarehouseId(csInPlannedOrderEo.getReceiveWarehouseId());
            qualityInfoDetailEo.setWarehouseCode(csInPlannedOrderEo.getReceiveWarehouseCode());
            qualityInfoDetailEo.setWarehouseName(csInPlannedOrderEo.getReceiveWarehouseName());
            qualityInfoDetailEo.setCargoId(detail.getCargoId());
            qualityInfoDetailEo.setCargoCode(detail.getCargoCode());
            qualityInfoDetailEo.setCargoName(detail.getCargoName());
            qualityInfoDetailEo.setLongCode(detail.getLongCode());
            qualityInfoDetailEo.setArtNo(detail.getArtNo());
            qualityInfoDetailEo.setBatch(detail.getBatch());
            qualityInfoDetailEo.setExpireTime(detail.getExpireTime());
            qualityInfoDetailEo.setProduceTime(detail.getProduceTime());
            qualityInfoDetailEo.setQuantity(csInPlannedOrderEo.getTotalQuantity());
            qualityInfoDetailEoList.add(qualityInfoDetailEo);
        });
        if (CollectionUtils.isNotEmpty(qualityInfoDetailEoList)) {
            this.qualityInfoDetailDas.insertBatch(qualityInfoDetailEoList);
        }
    }

    @Override
    public Boolean wmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("wmsCancel==>\u8ba1\u5212\u5355\u636e,WMS\u53d1\u8d77\u53d6\u6d88,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        Boolean inFlag = callBackContext.getInFlag();
        if (inFlag.booleanValue()) {
            this.inWmsCancel(callBackContext);
        } else {
            this.outWmsCancel(callBackContext);
        }
        return true;
    }

    private void outWmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        String relevanceNo = callBackContext.getRelevanceNo();
        if (StringUtils.isBlank((CharSequence)relevanceNo)) {
            return;
        }
        QueryWrapper csOutPlannedOrderEoQueryWrapper = new QueryWrapper();
        csOutPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csOutPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)this.csOutPlannedOrderMapper.selectOne((Wrapper)csOutPlannedOrderEoQueryWrapper);
        if (null == csOutPlannedOrderEo) {
            return;
        }
        csOutPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.PORTION_OUT.getCode().equals(csOutPlannedOrderEo.getOrderStatus()) ? CsPlannedOrderStatusEnum.CLOSED.getCode() : CsPlannedOrderStatusEnum.CANCEL.getCode());
        csOutPlannedOrderEoQueryWrapper.clear();
        csOutPlannedOrderEoQueryWrapper.eq((Object)"id", (Object)csOutPlannedOrderEo.getId());
        this.csOutPlannedOrderMapper.update((Object)csOutPlannedOrderEo, (Wrapper)csOutPlannedOrderEoQueryWrapper);
    }

    private void inWmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        String relevanceNo = callBackContext.getRelevanceNo();
        if (StringUtils.isBlank((CharSequence)relevanceNo)) {
            return;
        }
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)relevanceNo);
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        if (null == csInPlannedOrderEo) {
            return;
        }
        csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.PORTION_IN.getCode().equals(csInPlannedOrderEo.getOrderStatus()) ? CsPlannedOrderStatusEnum.CLOSED.getCode() : CsPlannedOrderStatusEnum.CANCEL.getCode());
        csInPlannedOrderEoQueryWrapper.clear();
        csInPlannedOrderEoQueryWrapper.eq((Object)"id", (Object)csInPlannedOrderEo.getId());
        this.csInPlannedOrderMapper.update((Object)csInPlannedOrderEo, (Wrapper)csInPlannedOrderEoQueryWrapper);
    }

    private void releaseFutureIn(CsInPlannedOrderEo csInPlannedOrderEo, List<CsInPlannedOrderDetailEo> orderDetailEoList) {
        ReleaseFutureInDto releaseFutureInParam = new ReleaseFutureInDto();
        releaseFutureInParam.setSourceNo(csInPlannedOrderEo.getOrderNo());
        releaseFutureInParam.setSourceType(csInPlannedOrderEo.getBusinessType());
        releaseFutureInParam.setBusinessType(csInPlannedOrderEo.getBusinessType());
        releaseFutureInParam.setExternalOrderNo(csInPlannedOrderEo.getPlatformOrderNo());
        ArrayList detailParams = Lists.newArrayList();
        for (CsInPlannedOrderDetailEo detailReqDto : orderDetailEoList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal futureInNum = BigDecimalUtils.abs((BigDecimal)detailReqDto.getPlanQuantity());
            detailParam.setNum(futureInNum);
            detailParam.setSkuCode(detailReqDto.getLongCode());
            String warehouseCode = csInPlannedOrderEo.getReceiveWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            detailParams.add(detailParam);
            releaseFutureInParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
        }
        releaseFutureInParam.setDetails((List)detailParams);
        this.calcInventoryService.releaseFutureIn(releaseFutureInParam);
    }

    @Override
    public void getContactsInfo(WmsStockOutOrderReqDto dto) {
        CsOutPlannedOrderEo csOutPlannedOrderEo = this.getCsOutPlannedOrderEo(dto.getRelevanceNo());
        if (null == csOutPlannedOrderEo.getSupplierId()) {
            logger.info("\u62fc\u63a5\u6536\u8d27\u4eba\u4fe1\u606f\uff0c\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5355\u53f7\uff1a{}", (Object)dto.getRelevanceNo());
            return;
        }
        CsInventorySupplierEo csInventorySupplierEo = (CsInventorySupplierEo)this.csInventorySupplierDas.selectByPrimaryKey(csOutPlannedOrderEo.getSupplierId());
        WmsStockOutOrderReqDto.ReceiverInfo receiverInfo = new WmsStockOutOrderReqDto.ReceiverInfo();
        CubeBeanUtils.copyProperties((Object)receiverInfo, (Object)csInventorySupplierEo, (String[])new String[0]);
        receiverInfo.setPhone(csInventorySupplierEo.getPhoneNum());
        receiverInfo.setCustomerCode(csInventorySupplierEo.getSupplierCode());
        receiverInfo.setDetailAddress(csInventorySupplierEo.getAddress());
        receiverInfo.setContacts(csInventorySupplierEo.getLinkman());
        dto.setReceiverInfo(receiverInfo);
    }

    @Override
    public void getContactsInfo(WmsStockEntryOrderReqDto dto) {
        CsInPlannedOrderEo csInPlannedOrderEo = this.getCsInPlannedOrderEo(dto.getRelevanceNo());
        if (null == csInPlannedOrderEo.getSupplierId()) {
            logger.info("\u62fc\u63a5\u53d1\u8d27\u4eba\u4fe1\u606f\uff0c\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5355\u53f7\uff1a{}", (Object)dto.getRelevanceNo());
            return;
        }
        dto.setCustomerCode(csInPlannedOrderEo.getSupplierCode());
    }

    @Override
    public void inInventoryDeal(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2, boolean inFlag) {
        if (inFlag) {
            this.balanceIn(csInOutMatchRespDto, InOutNoticeOrderEo2);
        }
    }

    private void balanceIn(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2) {
        FormInDto param = new FormInDto();
        param.setSourceNo(InOutNoticeOrderEo2.getRelevanceNo());
        param.setSourceType(InOutNoticeOrderEo2.getBusinessType());
        param.setBusinessType(InOutNoticeOrderEo2.getBusinessType());
        param.setExternalOrderNo(InOutNoticeOrderEo2.getExternalOrderNo());
        ArrayList detailParams = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)csInOutMatchRespDto.getBatchInventoryList())) {
            for (CsInOutBasicsOrderDetailRespDto detailReqDto : csInOutMatchRespDto.getBatchInventoryList()) {
                CalcDetailDto detailParam = new CalcDetailDto();
                BigDecimal balance = BigDecimalUtils.abs((BigDecimal)detailReqDto.getBalance());
                if (BigDecimalUtils.eqZero((BigDecimal)balance).booleanValue()) continue;
                detailParam.setNum(balance);
                detailParam.setSkuCode(detailReqDto.getLongCode());
                String warehouseCode = StringUtils.isNotBlank((CharSequence)InOutNoticeOrderEo2.getInLogicWarehouseCode()) ? InOutNoticeOrderEo2.getInLogicWarehouseCode() : InOutNoticeOrderEo2.getOutLogicWarehouseCode();
                detailParam.setLogicWarehouseCode(warehouseCode);
                detailParam.setBatch(detailReqDto.getBatch());
                detailParam.setExpireDate(detailReqDto.getExpireTime());
                detailParam.setProduceDate(detailReqDto.getProduceTime());
                detailParams.add(detailParam);
            }
        }
        param.setDetails((List)detailParams);
        if (CollectionUtils.isNotEmpty((Collection)detailParams)) {
            this.calcInventoryService.formIn(param);
        }
    }

    private void releaseFutureIn(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2) {
        String warehouseCode;
        BigDecimal futureInNum;
        CalcDetailDto detailParam;
        ReleaseFutureInDto param = new ReleaseFutureInDto();
        param.setSourceNo(InOutNoticeOrderEo2.getRelevanceNo());
        param.setSourceType(InOutNoticeOrderEo2.getBusinessType());
        param.setBusinessType(InOutNoticeOrderEo2.getBusinessType());
        param.setExternalOrderNo(InOutNoticeOrderEo2.getExternalOrderNo());
        ArrayList detailParams = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)csInOutMatchRespDto.getTotalInventoryList())) {
            param.setNoneBatch(Boolean.valueOf(true));
            for (CsInOutBasicsOrderDetailRespDto detailReqDto : csInOutMatchRespDto.getTotalInventoryList()) {
                detailParam = new CalcDetailDto();
                if (null == detailReqDto.getInNum()) continue;
                futureInNum = BigDecimalUtils.abs((BigDecimal)detailReqDto.getInNum());
                detailParam.setNum(futureInNum);
                if (BigDecimalUtils.eqZero((BigDecimal)futureInNum).booleanValue()) continue;
                detailParam.setSkuCode(detailReqDto.getLongCode());
                warehouseCode = StringUtils.isNotBlank((CharSequence)InOutNoticeOrderEo2.getInLogicWarehouseCode()) ? InOutNoticeOrderEo2.getInLogicWarehouseCode() : InOutNoticeOrderEo2.getOutLogicWarehouseCode();
                detailParam.setLogicWarehouseCode(warehouseCode);
                detailParam.setBatch(detailReqDto.getBatch());
                detailParam.setExpireDate(detailReqDto.getExpireTime());
                detailParam.setProduceDate(detailReqDto.getProduceTime());
                detailParams.add(detailParam);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)csInOutMatchRespDto.getBatchInventoryList())) {
            for (CsInOutBasicsOrderDetailRespDto detailReqDto : csInOutMatchRespDto.getBatchInventoryList()) {
                detailParam = new CalcDetailDto();
                if (null == detailReqDto.getInNum() || BigDecimalUtils.eqZero((BigDecimal)(futureInNum = BigDecimalUtils.abs((BigDecimal)detailReqDto.getInNum()))).booleanValue()) continue;
                detailParam.setNum(futureInNum);
                detailParam.setSkuCode(detailReqDto.getLongCode());
                warehouseCode = StringUtils.isNotBlank((CharSequence)InOutNoticeOrderEo2.getInLogicWarehouseCode()) ? InOutNoticeOrderEo2.getInLogicWarehouseCode() : InOutNoticeOrderEo2.getOutLogicWarehouseCode();
                detailParam.setLogicWarehouseCode(warehouseCode);
                detailParam.setBatch(detailReqDto.getBatch());
                detailParam.setExpireDate(detailReqDto.getExpireTime());
                detailParam.setProduceDate(detailReqDto.getProduceTime());
                detailParams.add(detailParam);
            }
        }
        param.setDetails((List)detailParams);
        if (CollectionUtils.isNotEmpty((Collection)detailParams)) {
            this.calcInventoryService.releaseFutureIn(param);
        }
    }

    @Override
    public void updateMainOrderStatus(String relevanceNo, boolean inFlag) {
        String status = CsPlannedOrderStatusEnum.HANG_UP.getCode();
        if (inFlag) {
            this.updateInPlanOrderStatus(relevanceNo, status);
        } else {
            this.updateOutPlanOrderStatus(relevanceNo, status);
        }
    }

    @Override
    public void closeOrderStatus(String relevanceNo) {
        this.updateOutPlanOrderStatus(relevanceNo, CsPlannedOrderStatusEnum.CLOSED.getCode());
    }
}

