/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseTaskService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INSPECTION_RELEASE_BUSINESS_TOPIC", tag="DO_INSPECTION_RELEASE_TASK")
public class InspectionReleaseDoTaskProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(InspectionReleaseDoTaskProcess.class);
    @Autowired
    ILockService lockService;
    @Autowired
    IInspectionReleaseTaskService inspectionReleaseTaskService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(MessageVo message) {
        log.info("CreateInspectionReleaseDoTaskProcess\uff1a{}", (Object)LogUtils.buildLogContent(message));
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        Mutex lock = null;
        try {
            String taskNo = String.valueOf(message.getData());
            lock = this.lockService.lock("mq_do_inspection_release_task", taskNo, 20, 25, TimeUnit.SECONDS);
            this.inspectionReleaseTaskService.doTask(taskNo);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                log.info("\u6267\u884c\u653e\u884c\u4efb\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                this.lockService.unlock(lock);
                throw throwable;
            }
            this.lockService.unlock(lock);
        }
        this.lockService.unlock(lock);
        return MessageResponse.SUCCESS;
    }
}

