/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutResultOrderRepairDataDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderStringValidReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutResultSolutionToHangReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutResultSolutionToHangRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseAddReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class CsOutResultOrderApiImpl
implements ICsOutResultOrderApi {
    private static final Logger log = LoggerFactory.getLogger(CsOutResultOrderApiImpl.class);
    @Resource
    protected ICsOutResultOrderService csOutResultOrderService;
    @Autowired
    protected IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    ILockService lockService;

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public RestResponse<String> sendBack(TcbjResGenReqDto reqDto) {
        return new RestResponse(null);
    }

    public RestResponse<Void> updateStringValidResult(List<CsOutResultOrderStringValidReqDto> stringValidReqDtoList) {
        RestResponse restResponse = new RestResponse();
        if (CollectionUtils.isEmpty(stringValidReqDtoList)) {
            return restResponse;
        }
        this.csOutResultOrderService.updateStringValidResult(stringValidReqDtoList);
        return restResponse;
    }

    public RestResponse<Void> repairData(String documentNo, List<CsOutResultOrderRepairDataDto> repairDataDtos) {
        this.csOutResultOrderService.repairData(documentNo, repairDataDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Long> updateOutResultOrder(CsOutResultOrderAddReqDto updateReqDto) {
        return new RestResponse((Object)this.csOutResultOrderService.updateOutResultOrder(updateReqDto));
    }

    public RestResponse<Void> unhook(String documentNo, String remark) {
        this.csOutResultOrderService.unhook(documentNo, remark);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateSapNoById(Long id, String sapNo) {
        log.info("updateSapNoById\u6839\u636eid\u4fee\u6539\u7ed3\u679c\u5355sapNo,id:{},sapNo:{}", (Object)id, (Object)sapNo);
        this.csOutResultOrderService.updateSapNoById(id, sapNo);
        return RestResponse.VOID;
    }

    public RestResponse<CsOutResultSolutionToHangRespDto> solutionToHang(CsOutResultSolutionToHangReqDto csOutResultSolutionToHangReqDto) {
        return new RestResponse((Object)this.csOutResultOrderService.solutionToHang(csOutResultSolutionToHangReqDto));
    }

    public RestResponse<Void> outInResultOrderCallBackNoticeOrderSend(List<String> documentNos) {
        return null;
    }

    private CsOutResultOrderAddReqDto changeParam(TcbjResGenReqDto reqDto) {
        CsOutResultOrderAddReqDto addReqDto = new CsOutResultOrderAddReqDto();
        CubeBeanUtils.copyProperties((Object)addReqDto, (Object)reqDto, (String[])new String[0]);
        addReqDto.setRelevanceNo(reqDto.getNotiNo());
        addReqDto.setPreOrderNo(reqDto.getPreNo());
        addReqDto.setBusinessType(reqDto.getType() + "");
        addReqDto.setExternalOrderNo(reqDto.getNotiNo());
        ContactDto contactDto = new ContactDto();
        CubeBeanUtils.copyProperties((Object)contactDto, (Object)reqDto, (String[])new String[0]);
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.valueOf(0L);
        for (TcbjResGenItemReqDto resGenItemReqDto : reqDto.getResGenItemReqDtos()) {
            CsOutResultOrderDetailAddReqDto detailAddReqDto = new CsOutResultOrderDetailAddReqDto();
            detailAddReqDto.setCargoCode(resGenItemReqDto.getCargoCode());
            detailAddReqDto.setQuantity(BigDecimal.valueOf(resGenItemReqDto.getNum().intValue()));
            detailAddReqDto.setBatch(resGenItemReqDto.getBatch());
            totalQuantity = totalQuantity.add(detailAddReqDto.getQuantity());
            if (StringUtils.isNotBlank((CharSequence)resGenItemReqDto.getOtherField1())) {
                try {
                    JSONObject json = JSON.parseObject((String)resGenItemReqDto.getOtherField1());
                    Long tradeOrderItemId = (Long)json.getObject("tradeOrderItemId", Long.class);
                    detailAddReqDto.setTradeOrderItemId(tradeOrderItemId);
                }
                catch (Exception ex) {
                    log.info("\u53c2\u6570\u8f6c\u6362\u9519\u8bef\uff0c\u4e0d\u5904\u7406:{}", (Object)JSON.toJSONString((Object)ex));
                }
            }
            detailAddReqDtoList.add(detailAddReqDto);
        }
        addReqDto.setTotalQuantity(totalQuantity);
        addReqDto.setContactDto(contactDto);
        addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        return addReqDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Void> createConsignmentByOutResultOrderNo(String documentNo) {
        Mutex mutex = this.lockService.lock("createConsignmentByOutResultOrderNo", documentNo, 20, 25, TimeUnit.SECONDS);
        try {
            List inOutResultOrderEos = this.inOutResultOrderDomain.queryByDocumentNo(documentNo);
            AssertUtils.notEmpty((Collection)inOutResultOrderEos, (String)"\u7ed3\u679c\u5355\u5355\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728");
            this.csOutResultOrderService.createConsignmentByOutResultOrderNo((InOutResultOrderEo)inOutResultOrderEos.get(0));
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Void> refreshPlanTime(String documentNo, CsShipmenetEnterpriseAddReqDto reqDto) {
        Mutex mutex = this.lockService.lock("refreshPlanTime", documentNo, 20, 25, TimeUnit.SECONDS);
        try {
            List inOutResultOrderEos = this.inOutResultOrderDomain.queryByDocumentNo(documentNo);
            AssertUtils.notEmpty((Collection)inOutResultOrderEos, (String)"\u7ed3\u679c\u5355\u5355\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728");
            this.csOutResultOrderService.refreshPlanTime((InOutResultOrderEo)inOutResultOrderEos.get(0), reqDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.VOID;
    }
}

