/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsInventorySupplierService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsInventorySupplierDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsInventorySupplierEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsInventorySupplierMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventorySupplierReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsInventorySupplierRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsInventorySupplierServiceImpl
implements ICsInventorySupplierService {
    @Resource
    private CsInventorySupplierDas csInventorySupplierDas;
    @Autowired
    private CsInventorySupplierMapper csInventorySupplierMapper;

    @Override
    public Long addCsInventorySupplier(CsInventorySupplierReqDto addReqDto) {
        this.verificationParam(addReqDto);
        CsInventorySupplierEo csInventorySupplierEo = new CsInventorySupplierEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csInventorySupplierEo);
        if (addReqDto.getId() != null && addReqDto.getId() > 0L) {
            CsInventorySupplierEo customerEo = (CsInventorySupplierEo)this.csInventorySupplierDas.selectByPrimaryKey(addReqDto.getId());
            if (customerEo == null) {
                throw new BizException("\u7f16\u8f91\u6240\u4f20\u5ba2\u6237id\u4e0d\u6b63\u786e");
            }
            this.csInventorySupplierDas.updateSelective((BaseEo)csInventorySupplierEo);
        } else {
            Integer count = ((ExtQueryChainWrapper)this.csInventorySupplierDas.filter().eq((Object)"supplier_code", (Object)addReqDto.getSupplierCode())).count();
            if (count != null && count >= 1) {
                throw new BizException("\u4f9b\u5e94\u5546\u7f16\u7801\u91cd\u590d");
            }
            this.csInventorySupplierDas.insert((BaseEo)csInventorySupplierEo);
            addReqDto.setId(csInventorySupplierEo.getId());
        }
        return csInventorySupplierEo.getId();
    }

    private void verificationParam(CsInventorySupplierReqDto addReqDto) {
        if (StringUtils.isBlank((CharSequence)addReqDto.getSupplierCode())) {
            throw new BizException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addReqDto.getSupplierCode().length() > 50) {
            throw new BizException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc750\u5b57\u7b26");
        }
        if (StringUtils.isBlank((CharSequence)addReqDto.getSupplierName())) {
            throw new BizException("\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addReqDto.getSupplierName().length() > 50) {
            throw new BizException("\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc750\u5b57\u7b26");
        }
        if (Objects.isNull(addReqDto.getStatus())) {
            throw new BizException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyCsInventorySupplier(CsInventorySupplierReqDto modifyReqDto) {
        CsInventorySupplierEo csInventorySupplierEo = new CsInventorySupplierEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csInventorySupplierEo);
        this.csInventorySupplierDas.updateSelective((BaseEo)csInventorySupplierEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsInventorySupplier(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csInventorySupplierDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsInventorySupplierRespDto queryById(Long id) {
        CsInventorySupplierEo csInventorySupplierEo = (CsInventorySupplierEo)this.csInventorySupplierDas.selectByPrimaryKey(id);
        CsInventorySupplierRespDto csInventorySupplierRespDto = new CsInventorySupplierRespDto();
        DtoHelper.eo2Dto((BaseEo)csInventorySupplierEo, (BaseVo)csInventorySupplierRespDto);
        return csInventorySupplierRespDto;
    }

    @Override
    public PageInfo<CsInventorySupplierRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CsInventorySupplierReqDto csInventorySupplierReqDto = (CsInventorySupplierReqDto)JSON.parseObject((String)filter, CsInventorySupplierReqDto.class);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)csInventorySupplierReqDto.getSupplierCode())) {
            wrapper.like(CsInventorySupplierEo::getSupplierCode, (Object)("%" + csInventorySupplierReqDto.getSupplierCode() + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)csInventorySupplierReqDto.getSupplierName())) {
            wrapper.like(CsInventorySupplierEo::getSupplierName, (Object)("%" + csInventorySupplierReqDto.getSupplierName() + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)csInventorySupplierReqDto.getSupplierUnit())) {
            wrapper.like(CsInventorySupplierEo::getSupplierUnit, (Object)("%" + csInventorySupplierReqDto.getSupplierUnit() + "%"));
        }
        if (csInventorySupplierReqDto.getStatus() != null) {
            wrapper.eq(CsInventorySupplierEo::getStatus, (Object)csInventorySupplierReqDto.getStatus());
        }
        wrapper.eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue());
        IPage page = this.csInventorySupplierDas.getMapper().selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), (Wrapper)wrapper);
        PageInfo eoPageInfo = new PageInfo(page.getRecords());
        eoPageInfo.setPageNum(pageNum.intValue());
        eoPageInfo.setPageSize(pageSize.intValue());
        eoPageInfo.setPages((int)page.getPages());
        eoPageInfo.setTotal(page.getTotal());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsInventorySupplierRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CsInventorySupplierRespDto> queryParam(CsInventorySupplierReqDto csInventorySupplierReqDto) {
        List csInventorySupplierEoList;
        String supplierName;
        AssertUtil.isTrue(null != csInventorySupplierReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csInventorySupplierEoQueryWrapper = new QueryWrapper();
        String supplierCode = csInventorySupplierReqDto.getSupplierCode();
        if (StringUtils.isNotBlank((CharSequence)supplierCode)) {
            csInventorySupplierEoQueryWrapper.eq((Object)"supplier_code", (Object)supplierCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(supplierName = csInventorySupplierReqDto.getSupplierName()))) {
            csInventorySupplierEoQueryWrapper.like((Object)"supplier_name", (Object)supplierName);
        }
        if (CollectionUtils.isNotEmpty((Collection)csInventorySupplierReqDto.getSupplierCodeList())) {
            csInventorySupplierEoQueryWrapper.in((Object)"supplier_code", (Collection)csInventorySupplierReqDto.getSupplierCodeList());
        }
        if (CollectionUtils.isEmpty((Collection)(csInventorySupplierEoList = this.csInventorySupplierMapper.selectList((Wrapper)csInventorySupplierEoQueryWrapper)))) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)csInventorySupplierEoList, CsInventorySupplierRespDto.class);
        return resultList;
    }
}

