/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.bd;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.bd.IStorageOrderExtApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl.ThirdOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsShipmenetEnterpriseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.SapStorageOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.StorageOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.StorageOrderCaiNiaoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.StorageOrderExtDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.StorageOrderExtReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.listener.CsSapChangeInventoryTransactionalReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.bd.CallbackRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.SapCenterTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdTypeOfDocumentEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemListInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.SapChangeInventoryEvent;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageOrderExtApiImpl
implements IStorageOrderExtApi {
    private static final Logger log = LoggerFactory.getLogger(StorageOrderExtApiImpl.class);
    private Logger logger = LoggerFactory.getLogger(StorageOrderExtApiImpl.class);
    @Autowired
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    private IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IRelWarehouseDomain relWarehouseDomain;
    @Resource
    private ThirdOrderService thirdOrderService;
    @Autowired
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    private CsShipmenetEnterpriseMapper shipmenetEnterpriseMapper;
    @Autowired
    private ICommonsMqService mqService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private IItemExtQueryApi itemExtQueryApi;
    @Autowired
    protected BaseOrderFacade baseOrderFacade;

    public RestResponse<Long> addStorageOrderExt(StorageOrderAddReqDto addReqDto) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return new RestResponse();
    }

    public RestResponse<Long> addStorageOrderSyncExt(StorageOrderAddReqDto addReqDto) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return new RestResponse();
    }

    public RestResponse<Void> addStorageOrderSyncList(List<StorageOrderAddReqDto> addReqDto) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return RestResponse.VOID;
    }

    public RestResponse<Long> addPackingStorageOrder(StorageOrderAddReqDto addReqDto) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return new RestResponse();
    }

    public RestResponse<Void> modifyStorageOrderExt(StorageOrderExtReqDto modifyReqDto) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeStorageOrderExt(String ids, Long instanceId) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return RestResponse.VOID;
    }

    public RestResponse<Void> returnLogisticsInfo(StorageOrderExtReqDto storageOrderExtReqDto) {
        this.logger.info("returnLogisticsInfo==>\u7269\u6d41\u4fe1\u606f\u56de\u4f20,storageOrderExtReqDto:{}", (Object)LogUtils.buildLogContent(storageOrderExtReqDto));
        String orderSrcNo = storageOrderExtReqDto.getOrderSrcNo();
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)orderSrcNo);
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        String shippingJsonStr = this.getShippingJsonStr(InOutNoticeOrderEo2, storageOrderExtReqDto);
        if (shippingJsonStr.equals(InOutNoticeOrderEo2.getShippingJson())) {
            this.logger.info("\u7269\u6d41\u4fe1\u606f\u56de\u4f20\u7684\u7269\u6d41\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u4e0d\u505a\u66f4\u65b0\u7269\u6d41\u4fe1\u606f\u64cd\u4f5c\uff0c\u76f4\u63a5\u8fd4\u56de");
            return RestResponse.VOID;
        }
        InOutNoticeOrderEo2.setShippingCode(storageOrderExtReqDto.getShippingNo());
        InOutNoticeOrderEo2.setShippingCompany(storageOrderExtReqDto.getShippingCompany());
        InOutNoticeOrderEo2.setShippingCompanyName(this.getShipmentName(storageOrderExtReqDto.getShippingCompany()));
        InOutNoticeOrderEo2.setShippingJson(shippingJsonStr);
        InOutNoticeOrderEoQueryWrapper.clear();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)InOutNoticeOrderEo2.getId());
        this.logger.info("returnLogisticsInfo==>\u7269\u6d41\u4fe1\u606f\u56de\u4f20,InOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEo2));
        this.inOutNoticeOrderDomain.getMapper().update((Object)InOutNoticeOrderEo2, (Wrapper)InOutNoticeOrderEoQueryWrapper);
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)InOutNoticeOrderEo2.getPreOrderNo());
        List ReceiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)ReceiveDeliveryNoticeOrderEoList)) {
            return RestResponse.VOID;
        }
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)ReceiveDeliveryNoticeOrderEoList.get(0);
        ReceiveDeliveryNoticeOrderEo2.setShippingCode(storageOrderExtReqDto.getShippingNo());
        ReceiveDeliveryNoticeOrderEo2.setShippingCompany(storageOrderExtReqDto.getShippingCompany());
        ReceiveDeliveryNoticeOrderEo2.setShippingCompanyName(this.getShipmentName(storageOrderExtReqDto.getShippingCompany()));
        ReceiveDeliveryNoticeOrderEo2.setShippingJson(shippingJsonStr);
        ReceiveDeliveryNoticeOrderEoQueryWrapper.clear();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)ReceiveDeliveryNoticeOrderEo2.getId());
        this.logger.info("returnLogisticsInfo==>\u7269\u6d41\u4fe1\u606f\u56de\u4f20,ReceiveDeliveryNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(ReceiveDeliveryNoticeOrderEo2));
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)ReceiveDeliveryNoticeOrderEo2, (Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        this.updateOutResultInfo(InOutNoticeOrderEo2, storageOrderExtReqDto, shippingJsonStr);
        this.sendShipmentInfo(InOutNoticeOrderEo2, storageOrderExtReqDto);
        return RestResponse.VOID;
    }

    private void sendShipmentInfo(InOutNoticeOrderEo InOutNoticeOrderEo2, StorageOrderExtReqDto storageOrderExtReqDto) {
        CsOutDeliveryMessageDto csOutDeliveryMessageDto = new CsOutDeliveryMessageDto();
        csOutDeliveryMessageDto.setOrderNo(InOutNoticeOrderEo2.getRelevanceNo());
        csOutDeliveryMessageDto.setShippingNo(storageOrderExtReqDto.getShippingNo());
        csOutDeliveryMessageDto.setShipmentEnterpriseCode(storageOrderExtReqDto.getShippingCompany());
        csOutDeliveryMessageDto.setShipmentEnterpriseName(this.getShipmentName(storageOrderExtReqDto.getShippingCompany()));
        csOutDeliveryMessageDto.setDeliveryTime(new Date());
        String shippingJson = InOutNoticeOrderEo2.getShippingJson();
        this.logger.info("sendShipmentInfo==>\u7269\u6d41\u8865\u4f20\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,shippingJson:{}", (Object)LogUtils.buildLogContent(shippingJson));
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                if (CollectionUtils.isNotEmpty((Collection)csWmsShippingInfoReqDtoList)) {
                    csWmsShippingInfoReqDtoList.stream().filter(e -> Objects.isNull(e.getDeliveryTime())).forEach(e -> e.setDeliveryTime(csOutDeliveryMessageDto.getDeliveryTime()));
                }
                this.logger.info("sendShipmentInfo==>\u7269\u6d41\u8865\u4f20\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,csWmsShippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                csOutDeliveryMessageDto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        csOutDeliveryMessageDto.setCommonBack(Boolean.FALSE);
        csOutDeliveryMessageDto.setDeliveryNoticeOrderNo(InOutNoticeOrderEo2.getPreOrderNo());
        csOutDeliveryMessageDto.setOutNoticeOrderNo(InOutNoticeOrderEo2.getDocumentNo());
        csOutDeliveryMessageDto.setAdvanceReturnShippingInfo(Boolean.valueOf(true));
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)csOutDeliveryMessageDto);
        this.logger.info("sendShipmentInfo==>WMS\u8865\u53d1\u7269\u6d41\u4fe1\u606f,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
        this.mqService.sendSingleMessage("ORDER_SALE_WMS_SEND_BACK_TAG", (Object)messageVo);
    }

    private void updateOutResultInfo(InOutNoticeOrderEo InOutNoticeOrderEo2, StorageOrderExtReqDto storageOrderExtReqDto, String shippingJsonStr) {
        this.logger.info("updateOutResultInfo==>\u66f4\u65b0\u51fa\u5e93\u7ed3\u679c\u5355\u4e0a\u7684\u7269\u6d41\u56de\u4f20\u4fe1\u606f,InOutNoticeOrderEo:{},storageOrderExtReqDto:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEo2), (Object)LogUtils.buildLogContent(storageOrderExtReqDto));
        String documentNo = InOutNoticeOrderEo2.getDocumentNo();
        QueryWrapper inOutResultOrderEoQueryWrapper = new QueryWrapper();
        inOutResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutResultOrderEoQueryWrapper.eq((Object)"pre_order_no", (Object)documentNo);
        List InOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)inOutResultOrderEoQueryWrapper);
        this.logger.info("updateOutResultInfo==>\u66f4\u65b0\u51fa\u5e93\u7ed3\u679c\u5355\u4e0a\u7684\u7269\u6d41\u56de\u4f20\u4fe1\u606f,InOutResultOrderEoList:{}", (Object)LogUtils.buildLogContent(InOutResultOrderEoList));
        if (CollectionUtils.isEmpty((Collection)InOutResultOrderEoList)) {
            return;
        }
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)InOutResultOrderEoList.get(0);
        inOutResultOrderEo.setShippingJson(shippingJsonStr);
        inOutResultOrderEoQueryWrapper.clear();
        inOutResultOrderEoQueryWrapper.eq((Object)"id", (Object)inOutResultOrderEo.getId());
        this.inOutResultOrderDomain.getMapper().update((Object)inOutResultOrderEo, (Wrapper)inOutResultOrderEoQueryWrapper);
    }

    private String getShippingJsonStr(InOutNoticeOrderEo InOutNoticeOrderEo2, StorageOrderExtReqDto storageOrderExtReqDto) {
        this.logger.info("getShippingJsonStr==>\u7269\u6d41\u56de\u4f20\u4fe1\u606f\u8f6c\u6362JSON\u6570\u636e,InOutNoticeOrderEo:{},storageOrderExtReqDto:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEo2), (Object)LogUtils.buildLogContent(storageOrderExtReqDto));
        List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList = Lists.newArrayList();
        String outNoticeOrderShippingJson = InOutNoticeOrderEo2.getShippingJson();
        if (StringUtils.isNotBlank((CharSequence)outNoticeOrderShippingJson)) {
            try {
                shippingInfoReqDtoList = JSON.parseArray((String)outNoticeOrderShippingJson, CsWmsShippingInfoReqDto.class);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.logger.error("getShippingJsonStr==>\u83b7\u53d6\u51fa\u5e93\u901a\u5355\u4e0a\u539f\u6765\u7684\u53d1\u8d27\u4fe1\u606f\u5f02\u5e38");
            }
        }
        this.logger.error("getShippingJsonStr==>\u6b63\u5e38\u83b7\u53d6\u51fa\u5e93\u901a\u5355\u4e0a\u539f\u6765\u7684\u53d1\u8d27\u4fe1\u606f,shippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(shippingInfoReqDtoList));
        String[] shippingNos = storageOrderExtReqDto.getShippingNo().split(",");
        HashSet shippingInfo = new HashSet();
        shippingInfoReqDtoList.stream().filter(e -> Objects.nonNull(e) && StringUtils.isNotBlank((CharSequence)e.getShippingNo())).forEach(e -> shippingInfo.add(e.getShippingCompanyCode() + " " + e.getShippingNo()));
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
        csWmsShippingInfoReqDto.setShippingCompanyCode(storageOrderExtReqDto.getShippingCompany());
        csWmsShippingInfoReqDto.setShippingCompanyName(this.getShipmentName(storageOrderExtReqDto.getShippingCompany()));
        csWmsShippingInfoReqDto.setOutNoticeOrderNo(InOutNoticeOrderEo2.getDocumentNo());
        csWmsShippingInfoReqDto.setPlatformOrderNo(InOutNoticeOrderEo2.getExternalOrderNo());
        csWmsShippingInfoReqDto.setDeliveryTime(new Date());
        for (String shippingNo : shippingNos) {
            String wmsShippingInfoKey = storageOrderExtReqDto.getShippingCompany() + " " + shippingNo;
            if (shippingInfo.contains(wmsShippingInfoKey)) {
                this.logger.info("\u7269\u6d41\u56de\u4f20\u7684\u5feb\u9012\u4fe1\u606f\uff1a{}\u5df2\u5b58\u5728\uff0c\u4e0d\u4fdd\u5b58", (Object)wmsShippingInfoKey);
                continue;
            }
            CsWmsShippingInfoReqDto shippingInfoReqDto = new CsWmsShippingInfoReqDto();
            CubeBeanUtils.copyProperties((Object)shippingInfoReqDto, (Object)csWmsShippingInfoReqDto, (String[])new String[0]);
            shippingInfoReqDto.setShippingNo(shippingNo);
            shippingInfoReqDtoList.add(shippingInfoReqDto);
        }
        String shippingJsonStr = null;
        try {
            shippingJsonStr = JSON.toJSONString(shippingInfoReqDtoList);
            this.logger.info("getShippingJsonStr==>\u83b7\u53d6\u7269\u6d41\u56de\u4f20JSON\u6570\u636e,shippingJsonStr:{}", (Object)LogUtils.buildLogContent(shippingInfoReqDtoList));
        }
        catch (Exception e3) {
            this.logger.error("\u83b7\u53d6\u7269\u6d41\u56de\u4f20JSON\u6570\u636e,\u8f6c\u6362JSON\u51fa\u9519,e:{}", (Throwable)e3);
        }
        this.logger.info("getShippingJsonStr==>\u7269\u6d41\u4fe1\u606fJSON\u6570\u636e,shippingJsonStr:{}", (Object)LogUtils.buildLogContent(shippingJsonStr));
        return shippingJsonStr;
    }

    private String getShipmentName(String shippingCompanyCode) {
        QueryWrapper csShipmenetEnterpriseEoQueryWrapper = new QueryWrapper();
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_code", (Object)shippingCompanyCode);
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_status", (Object)YesNoEnum.YES.getValue());
        List csShipmenetEnterpriseEoList = this.shipmenetEnterpriseMapper.selectList((Wrapper)csShipmenetEnterpriseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csShipmenetEnterpriseEoList)) {
            return null;
        }
        return ((CsShipmenetEnterpriseEo)csShipmenetEnterpriseEoList.get(0)).getShipmentEnterpriseName();
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> sapAddStorageOrder(List<SapStorageOrderAddReqDto> sapStorageOrderAddReqDtoList) {
        log.info("sap\u6279\u91cf\u521b\u5efa\u5355\u636e:{}", JSON.toJSON(sapStorageOrderAddReqDtoList));
        if (CollectionUtil.isNotEmpty(sapStorageOrderAddReqDtoList)) {
            ArrayList resultNoList = new ArrayList();
            ArrayList deliveryNoList = new ArrayList();
            ArrayList outList = new ArrayList(sapStorageOrderAddReqDtoList.size());
            ArrayList outDetailList = new ArrayList();
            ArrayList deliveryList = new ArrayList(sapStorageOrderAddReqDtoList.size());
            ArrayList deliveryDetailList = new ArrayList();
            sapStorageOrderAddReqDtoList.forEach(sap -> {
                String orderSrcNo = sap.getOrderSrcNo();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"external_order_no", (Object)orderSrcNo);
                queryWrapper.eq((Object)"dr", (Object)0);
                List eoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
                this.logger.info("\u6839\u636esap\u6765\u6e90\u5355\u53f7\u67e5\u8be2\u5230\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)eoList));
                Set<Object> orderTypes = new HashSet();
                if (CollectionUtils.isNotEmpty((Collection)eoList)) {
                    orderTypes = eoList.stream().map(InOutResultOrderEo::getOrderType).collect(Collectors.toSet());
                }
                GenerateCodeUtil generateCodeUtil = InventoryConfig.getGenerateCodeUtil();
                if (CollectionUtils.isEmpty((Collection)eoList) || !orderTypes.contains(sap.getCategory())) {
                    RelWarehouseEo relInLogicWarehouseEo;
                    RelWarehouseEo relOutLogicWarehouseEo;
                    SapCenterTypeEnum typeEnum;
                    String deliveryType;
                    String deliveryDocumentNo;
                    String resultDocumentNo;
                    if ("out".equals(sap.getCategory())) {
                        resultDocumentNo = generateCodeUtil.generateCode(CodeGenEnum.OUT_RESULT_ORDER);
                        deliveryDocumentNo = generateCodeUtil.generateCode(CodeGenEnum.DELIVERY_RESULT_ORDER);
                        deliveryType = "delivery";
                    } else {
                        resultDocumentNo = generateCodeUtil.generateCode(CodeGenEnum.IN_RESULT_ORDER);
                        deliveryDocumentNo = generateCodeUtil.generateCode(CodeGenEnum.RECEIVE_RESULT_ORDER);
                        deliveryType = "receive";
                    }
                    String businessType = sap.getDisplayBusinessType();
                    String desc = sap.getDisplayBusinessName();
                    String jumpDocumentType = sap.getJumpDocumentType();
                    String jumpDocumentName = sap.getJumpDocumentName();
                    if (StringUtils.isNotBlank((CharSequence)sap.getSapType()) && Objects.nonNull(typeEnum = SapCenterTypeEnum.getBySapType((String)sap.getSapType()))) {
                        businessType = typeEnum.getCenterType();
                        desc = typeEnum.getDesc();
                        jumpDocumentType = typeEnum.getJumpDocumentType();
                        jumpDocumentName = typeEnum.getJumpDocumentName();
                    }
                    ArrayList logicWarehouseCodes = Lists.newArrayList((Object[])new String[]{sap.getOutWarehouseCode(), sap.getInWarehouseCode()});
                    QueryWrapper logicWarehouseEoQueryWrapper = new QueryWrapper();
                    logicWarehouseEoQueryWrapper.in((Object)"warehouse_code", (Collection)logicWarehouseCodes);
                    logicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)0);
                    List logicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)logicWarehouseEoQueryWrapper);
                    this.logger.info("logicWarehouseEos:{}", (Object)JSON.toJSONString((Object)logicWarehouseEos));
                    Map<Object, Object> logicWarehouseEoMap = new HashMap(logicWarehouseCodes.size());
                    if (CollectionUtils.isNotEmpty((Collection)logicWarehouseEos)) {
                        logicWarehouseEoMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
                    }
                    QueryWrapper relWarehouseEoQueryWrapper = new QueryWrapper();
                    relWarehouseEoQueryWrapper.in((Object)"warehouse_code", (Collection)logicWarehouseCodes);
                    relWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
                    relWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
                    relWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
                    relWarehouseEoQueryWrapper.eq((Object)"dr", (Object)0);
                    List relWarehouseEos = this.relWarehouseDomain.getMapper().selectList((Wrapper)relWarehouseEoQueryWrapper);
                    this.logger.info("relWarehouseEos:{}", (Object)JSON.toJSONString((Object)relWarehouseEos));
                    Map<Object, Object> relWarehouseEoMap = new HashMap(logicWarehouseCodes.size());
                    if (CollectionUtils.isNotEmpty((Collection)relWarehouseEos)) {
                        relWarehouseEoMap = relWarehouseEos.stream().collect(Collectors.toMap(RelWarehouseEo::getWarehouseCode, Function.identity()));
                    }
                    InOutResultOrderEo inOutResultOrderEo = new InOutResultOrderEo();
                    inOutResultOrderEo.setBusinessType(jumpDocumentType);
                    inOutResultOrderEo.setSapNo(sap.getSapOrderNo());
                    inOutResultOrderEo.setExternalOrderNo(sap.getOrderSrcNo());
                    inOutResultOrderEo.setRelevanceNo(sap.getRelevanceNo());
                    inOutResultOrderEo.setOutLogicWarehouseCode(sap.getOutWarehouseCode());
                    LogicWarehouseEo outLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(sap.getOutWarehouseCode());
                    if (Objects.nonNull(outLogicWarehouseEo)) {
                        inOutResultOrderEo.setOutLogicWarehouseName(outLogicWarehouseEo.getWarehouseName());
                    }
                    if (Objects.nonNull(relOutLogicWarehouseEo = (RelWarehouseEo)relWarehouseEoMap.get(sap.getOutWarehouseCode()))) {
                        inOutResultOrderEo.setOutPhysicsWarehouseCode(relOutLogicWarehouseEo.getRefWarehouseCode());
                        inOutResultOrderEo.setOutPhysicsWarehouseName(relOutLogicWarehouseEo.getRefWarehouseName());
                    }
                    inOutResultOrderEo.setInLogicWarehouseCode(sap.getInWarehouseCode());
                    LogicWarehouseEo inLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(sap.getInWarehouseCode());
                    if (Objects.nonNull(inLogicWarehouseEo)) {
                        inOutResultOrderEo.setInLogicWarehouseName(inLogicWarehouseEo.getWarehouseName());
                    }
                    if (Objects.nonNull(relInLogicWarehouseEo = (RelWarehouseEo)relWarehouseEoMap.get(sap.getInWarehouseCode()))) {
                        inOutResultOrderEo.setInPhysicsWarehouseCode(relInLogicWarehouseEo.getRefWarehouseCode());
                        inOutResultOrderEo.setInPhysicsWarehouseName(relInLogicWarehouseEo.getRefWarehouseName());
                    }
                    inOutResultOrderEo.setOrderType(sap.getCategory());
                    inOutResultOrderEo.setOrderStatus("out".equals(sap.getCategory()) ? BaseOrderStatusEnum.ORO_HANG_UP.getCode() : BaseOrderStatusEnum.IRO_HANG_UP.getCode());
                    inOutResultOrderEo.setShippingCompany(sap.getShippingCompany());
                    inOutResultOrderEo.setInOutTime(sap.getTallyTime());
                    inOutResultOrderEo.setShippingCode(sap.getShippingNo());
                    inOutResultOrderEo.setWmsOrderNo(sap.getWmsOrderNo());
                    inOutResultOrderEo.setWmsNo(sap.getWmsOrderNo());
                    inOutResultOrderEo.setRelevanceTableName(BdTypeOfDocumentEnum.TRANSFER_ORDER.getCode().equals(jumpDocumentType) ? CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode() : CsRelevanceTableNameEnum.DEFAULT_ORDER.getCode());
                    inOutResultOrderEo.setDisplayBusinessType(businessType);
                    inOutResultOrderEo.setDisplayBusinessName(desc);
                    inOutResultOrderEo.setJumpDocumentType(jumpDocumentType);
                    inOutResultOrderEo.setJumpDocumentName(jumpDocumentName);
                    inOutResultOrderEo.setRemark(sap.getRemark());
                    inOutResultOrderEo.setShopCode(sap.getShopCode());
                    inOutResultOrderEo.setShopName(sap.getShopName());
                    ReceiveDeliveryResultOrderEo delivery = new ReceiveDeliveryResultOrderEo();
                    delivery.setExternalOrderNo(sap.getOrderSrcNo());
                    delivery.setBusinessType(jumpDocumentType);
                    delivery.setPreOrderNo(resultDocumentNo);
                    delivery.setOrderStatus("out".equals(sap.getCategory()) ? BaseOrderStatusEnum.DRO_HANG_UP.getCode() : BaseOrderStatusEnum.RRO_HANG_UP.getCode());
                    delivery.setOrderType(deliveryType);
                    delivery.setRelevanceNo(sap.getRelevanceNo());
                    delivery.setDeliveryLogicWarehouseCode(sap.getOutWarehouseCode());
                    if (Objects.nonNull(outLogicWarehouseEo)) {
                        delivery.setDeliveryLogicWarehouseName(outLogicWarehouseEo.getWarehouseName());
                    }
                    if (Objects.nonNull(relOutLogicWarehouseEo)) {
                        delivery.setDeliveryPhysicsWarehouseCode(relOutLogicWarehouseEo.getRefWarehouseCode());
                        delivery.setDeliveryPhysicsWarehouseName(relOutLogicWarehouseEo.getRefWarehouseName());
                    }
                    delivery.setReceiveLogicWarehouseCode(sap.getInWarehouseCode());
                    if (Objects.nonNull(inLogicWarehouseEo)) {
                        delivery.setReceiveLogicWarehouseName(inLogicWarehouseEo.getWarehouseName());
                    }
                    if (Objects.nonNull(relInLogicWarehouseEo)) {
                        delivery.setReceivePhysicsWarehouseCode(relInLogicWarehouseEo.getRefWarehouseCode());
                        delivery.setReceivePhysicsWarehouseName(relInLogicWarehouseEo.getRefWarehouseName());
                    }
                    delivery.setRemark(sap.getRemark());
                    delivery.setShippingCompany(sap.getShippingCompany());
                    delivery.setWmsOrderNo(sap.getWmsOrderNo());
                    delivery.setWmsNo(sap.getWmsOrderNo());
                    delivery.setRelevanceTableName(BdTypeOfDocumentEnum.TRANSFER_ORDER.getCode().equals(jumpDocumentType) ? CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode() : CsRelevanceTableNameEnum.DEFAULT_ORDER.getCode());
                    delivery.setDisplayBusinessType(businessType);
                    delivery.setDisplayBusinessName(desc);
                    delivery.setJumpDocumentType(jumpDocumentType);
                    delivery.setJumpDocumentName(jumpDocumentName);
                    delivery.setRemark(sap.getRemark());
                    resultNoList.add(resultDocumentNo);
                    deliveryNoList.add(deliveryDocumentNo);
                    inOutResultOrderEo.setDocumentNo(resultDocumentNo);
                    delivery.setDocumentNo(deliveryDocumentNo);
                    outList.add(inOutResultOrderEo);
                    deliveryList.add(delivery);
                    List detailList = sap.getDetailList();
                    List cargoCodeList = detailList.stream().map(StorageOrderExtDetailReqDto::getCargoCode).collect(Collectors.toList());
                    RestResponse itemResponse = this.itemExtQueryApi.getItemListSimpleByItemCode(cargoCodeList);
                    List itemList = (List)RestResponseHelper.extractData((RestResponse)itemResponse);
                    Map<Object, Object> itemEoMap = new HashMap(cargoCodeList.size());
                    if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                        itemEoMap = itemList.stream().collect(Collectors.toMap(ItemListInfoRespDto::getItemCode, Function.identity()));
                    }
                    BigDecimal totalQuantity = BigDecimal.ZERO;
                    for (StorageOrderExtDetailReqDto d : detailList) {
                        String cargoCode = d.getCargoCode();
                        ItemListInfoRespDto itemListInfoRespDto = (ItemListInfoRespDto)itemEoMap.get(cargoCode);
                        BigDecimal quantity = new BigDecimal(d.getNum());
                        InOutResultOrderDetailEo cs = new InOutResultOrderDetailEo();
                        cs.setExternalOrderNo(sap.getSapOrderNo());
                        cs.setSkuCode(d.getCargoCode());
                        cs.setQuantity(quantity);
                        cs.setDoneQuantity(quantity);
                        cs.setCancelQuantity(BigDecimal.ZERO);
                        cs.setWaitQuantity(BigDecimal.ZERO);
                        cs.setPlanQuantity(quantity);
                        cs.setWaitQuantity(BigDecimal.ZERO);
                        cs.setDocumentNo(resultDocumentNo);
                        cs.setRelevanceNo(sap.getRelevanceNo());
                        if (null != itemListInfoRespDto) {
                            cs.setSkuName(itemListInfoRespDto.getItemName());
                        }
                        if (Objects.nonNull(d.getPreOrderItemId())) {
                            cs.setPreOrderItemId(d.getPreOrderItemId());
                        }
                        outDetailList.add(cs);
                        ReceiveDeliveryResultOrderDetailEo deliveryDetail = new ReceiveDeliveryResultOrderDetailEo();
                        deliveryDetail.setExternalOrderNo(sap.getSapOrderNo());
                        deliveryDetail.setDocumentNo(deliveryDocumentNo);
                        deliveryDetail.setSkuCode(d.getCargoCode());
                        deliveryDetail.setSkuName(d.getCargoName());
                        deliveryDetail.setQuantity(quantity);
                        deliveryDetail.setDoneQuantity(quantity);
                        deliveryDetail.setPlanQuantity(quantity);
                        deliveryDetail.setCancelQuantity(BigDecimal.ZERO);
                        deliveryDetail.setWaitQuantity(BigDecimal.ZERO);
                        deliveryDetail.setRelevanceNo(sap.getRelevanceNo());
                        if (null != itemListInfoRespDto) {
                            deliveryDetail.setSkuName(itemListInfoRespDto.getItemName());
                        }
                        if (Objects.nonNull(d.getPreOrderItemId())) {
                            deliveryDetail.setPreOrderItemId(d.getPreOrderItemId());
                        }
                        deliveryDetailList.add(deliveryDetail);
                        totalQuantity = totalQuantity.add(quantity);
                    }
                    inOutResultOrderEo.setTotalQuantity(totalQuantity);
                    delivery.setTotalQuantity(totalQuantity);
                } else {
                    log.info("\u5355\u636e\u5df2\u5b58\u5728,\u65e0\u9700\u91cd\u590d\u63d2\u5165,\u5916\u90e8\u5355\u53f7\uff1a" + orderSrcNo);
                }
            });
            this.logger.info("resultNoList:{}", (Object)JSON.toJSONString(resultNoList));
            this.logger.info("deliveryNoList:{}", (Object)JSON.toJSONString(deliveryNoList));
            if (CollectionUtil.isNotEmpty(outList)) {
                int outResultOrderNum = this.inOutResultOrderDomain.insertBatch(outList);
                int outResultOrderDetailNum = this.inOutResultOrderDetailDomain.insertBatch(outDetailList);
                int deliveryResultOrderNum = this.receiveDeliveryResultOrderDomain.insertBatch(deliveryList);
                int deliveryResultOrderDetailNum = this.receiveDeliveryResultOrderDetailDomain.insertBatch(deliveryDetailList);
                this.logger.info("outResultOrderNum:\u3010{}\u3011\uff0coutResultOrderDetailNum:\u3010{}\u3011\uff0cdeliveryResultOrderNum:\u3010{}\u3011\uff0cdeliveryResultOrderDetailNum:\u3010{}\u3011", new Object[]{JSON.toJSONString((Object)outResultOrderNum), JSON.toJSONString((Object)outResultOrderDetailNum), JSON.toJSONString((Object)deliveryResultOrderNum), JSON.toJSONString((Object)deliveryResultOrderDetailNum)});
                CsSapChangeInventoryTransactionalReqDto reqDto = new CsSapChangeInventoryTransactionalReqDto();
                reqDto.setResultNoList(resultNoList);
                reqDto.setDeliveryNoList(deliveryNoList);
                SapChangeInventoryEvent sapChangeInventoryEvent = new SapChangeInventoryEvent((Object)reqDto);
                this.logger.info("createOutNoticeOrder=>\u751f\u6210\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5b8c\u6210,\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u53ca\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u72b6\u6001,sapChangeInventoryEvent:{}", (Object)LogUtils.buildLogContent(sapChangeInventoryEvent));
                this.applicationEventPublisher.publishEvent((ApplicationEvent)sapChangeInventoryEvent);
            }
        }
        return RestResponse.VOID;
    }

    public void asyncChangeInventory(List<String> resultNoList, List<String> deliveryNoList) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.info(e.getMessage());
        }
        String reqId = MDC.get((String)"yes.req.requestId");
        ExecutorUtils.execute(() -> {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            this.changeOutInventory(resultNoList);
            this.changeDeliveryInventory(deliveryNoList);
        });
    }

    public void changeDeliveryInventory(List<String> deliveryNoList) {
        deliveryNoList.forEach(documentNo -> {
            this.logger.info("changeDeliveryInventory-\u6839\u636e\u5355\u53f7\uff1a{}\u67e5\u8be2\u53d1\u6536\u8d27\u901a\u77e5\u5355\u4fe1\u606f", documentNo);
            ReceiveDeliveryResultOrderEo delivery = (ReceiveDeliveryResultOrderEo)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"document_no", documentNo)).one();
            this.logger.info("changeDeliveryInventory-\u6839\u636e\u5355\u53f7\uff1a{},\u67e5\u8be2\u53d1\u6536\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", documentNo, (Object)JSON.toJSONString((Object)delivery));
            List detailList = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"document_no", documentNo)).list();
            if (delivery != null && CollectionUtil.isNotEmpty((Collection)detailList)) {
                try {
                    this.thirdOrderService.updateDeliveryResultOrderAndDetail(delivery, detailList);
                }
                catch (Exception e) {
                    log.info("\u66f4\u65b0\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u636e\u548c\u660e\u7ec6\u5931\u8d25,documentNo:{},message:{}", (Object)delivery.getDocumentNo(), (Object)e.getMessage());
                    ReceiveDeliveryResultOrderEo update = new ReceiveDeliveryResultOrderEo();
                    update.setId(delivery.getId());
                    update.setRemark(e.getMessage());
                    this.receiveDeliveryResultOrderDomain.updateSelective((BaseEo)update);
                }
            }
        });
    }

    public void changeOutInventory(List<String> resultNoList) {
        resultNoList.forEach(documentNo -> {
            this.logger.info("changeOutInventory-\u6839\u636e\u5355\u53f7\uff1a{}\u67e5\u8be2\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f", documentNo);
            InOutResultOrderEo outResultOrderEo = (InOutResultOrderEo)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"document_no", documentNo)).one();
            this.logger.info("changeOutInventory-\u6839\u636e\u5355\u53f7\uff1a{}\u67e5\u8be2\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", documentNo, (Object)JSON.toJSONString((Object)outResultOrderEo));
            List detailList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", documentNo)).list();
            if (outResultOrderEo != null && CollectionUtil.isNotEmpty((Collection)detailList)) {
                try {
                    this.thirdOrderService.updateOutResultOrderAndDetail(outResultOrderEo, detailList);
                }
                catch (Exception e) {
                    log.info("\u66f4\u65b0\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u636e\u548c\u660e\u7ec6\u5931\u8d25,documentNo:{},message:{}", (Object)outResultOrderEo.getDocumentNo(), (Object)e.getMessage());
                    InOutResultOrderEo updateEo = new InOutResultOrderEo();
                    updateEo.setId(outResultOrderEo.getId());
                    updateEo.setRemark(e.getMessage());
                    this.inOutResultOrderDomain.updateSelective((BaseEo)updateEo);
                }
            }
        });
    }

    public RestResponse<Long> addDifferenceInStorageOrder(StorageOrderAddReqDto addReqDto) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return new RestResponse();
    }

    public RestResponse<Void> adjustStorageOrderDifference(StorageOrderAddReqDto addReqDto) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return RestResponse.VOID;
    }

    public RestResponse<CallbackRespDto> callback(StorageOrderCaiNiaoReqDto addReqDto) {
        log.info("\u56e0\u4e3a\u6d89\u53ca\u8868\u4e0d\u4e00\u6837\uff0c\u6240\u4ee5\u6ca1\u6709\u8fc1\u79fb\u5b9e\u73b0\u4ee3\u7801");
        return new RestResponse();
    }
}

