/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.AbstractCsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsOtherStorageOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsOtherStorageOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsOtherStorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderStatusEnum;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="Csother_in_outBusinessOrderCallBackService")
public class CsOtherStorageOrderCallBackServiceImpl
extends AbstractCsBusinessOrderCallBackService
implements ICsBusinessOrderCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(CsOtherStorageOrderCallBackServiceImpl.class);
    @Resource
    CsOtherStorageOrderDas otherStorageOrderDas;
    @Resource
    ICsOtherStorageOrderService csOtherStorageOrderService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getStrategy() {
        return this.getPrefix() + "other_in_out";
    }

    private void updateOtherOrderStatus(String relevanceNo, String status) {
        CsOtherStorageOrderEo otherStorageOrderEo = (CsOtherStorageOrderEo)((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().eq((Object)"storage_order_no", (Object)relevanceNo)).one();
        AssertUtil.isTrue(Objects.nonNull(otherStorageOrderEo), "\u627e\u4e0d\u5230\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e,\u5355\u636e\u53f7:" + relevanceNo);
        CsOtherStorageOrderEo updateEo = new CsOtherStorageOrderEo();
        updateEo.setId(otherStorageOrderEo.getId());
        updateEo.setOrderStatus(status);
        this.otherStorageOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public Boolean deliveryReceiveNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u5176\u4ed6\u51fa\u5165\u5e93\u56de\u8c03deliveryReceiveNoticeOrderCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        String status = callBackContext.getInFlag() != false ? CsOtherStorageOrderStatusEnum.IN.WAIT_IN.getCode() : CsOtherStorageOrderStatusEnum.OUT.WAIT_OUT.getCode();
        this.updateOtherOrderStatus(callBackContext.getRelevanceNo(), status);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean inOutResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u5176\u4ed6\u51fa\u5165\u5e93\u56de\u8c03inOutResultOrderCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        String status = callBackContext.getInFlag().booleanValue() ? (callBackContext.getOverchargeFlag().booleanValue() ? CsOtherStorageOrderStatusEnum.IN.HANG_UP.getCode() : (callBackContext.getPortionFlag().booleanValue() ? CsOtherStorageOrderStatusEnum.IN.PORTION_IN.getCode() : CsOtherStorageOrderStatusEnum.IN.FINISH.getCode())) : (callBackContext.getOverchargeFlag() != false ? CsOtherStorageOrderStatusEnum.OUT.HANG_UP.getCode() : (callBackContext.getPortionFlag() != false ? CsOtherStorageOrderStatusEnum.OUT.PORTION_OUT.getCode() : CsOtherStorageOrderStatusEnum.OUT.FINISH.getCode()));
        this.updateOtherOrderStatus(callBackContext.getRelevanceNo(), status);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deliveryReceiveResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u5176\u4ed6\u51fa\u5165\u5e93\u56de\u8c03deliveryReceiveResultOrderCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean relieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u5176\u4ed6\u51fa\u5165\u5e93\u56de\u8c03relieveOverchargeCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        String status = callBackContext.getInFlag() != false ? CsOtherStorageOrderStatusEnum.IN.FINISH.getCode() : CsOtherStorageOrderStatusEnum.OUT.FINISH.getCode();
        this.updateOtherOrderStatus(callBackContext.getRelevanceNo(), status);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean overchargeAdjustCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u5176\u4ed6\u51fa\u5165\u5e93\u56de\u8c03overchargeAdjustCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        String status = callBackContext.getInFlag() != false ? CsOtherStorageOrderStatusEnum.IN.FINISH.getCode() : CsOtherStorageOrderStatusEnum.OUT.FINISH.getCode();
        this.updateOtherOrderStatus(callBackContext.getRelevanceNo(), status);
        return true;
    }

    @Override
    public Boolean wmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        CsOtherStorageOrderEo otherStorageOrderEo = (CsOtherStorageOrderEo)((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().eq((Object)"storage_order_no", (Object)callBackContext.getRelevanceNo())).one();
        String status = CsOtherStorageOrderStatusEnum.OUT.CANCEL.getCode();
        status = CsOtherStorageOrderStatusEnum.OUT.PORTION_OUT.getCode().equals(otherStorageOrderEo.getOrderStatus()) ? CsOtherStorageOrderStatusEnum.OUT.CLOSED.getCode() : (CsOtherStorageOrderStatusEnum.IN.PORTION_IN.getCode().equals(otherStorageOrderEo.getOrderStatus()) ? CsOtherStorageOrderStatusEnum.OUT.CLOSED.getCode() : status);
        this.csOtherStorageOrderService.updateOtherStorageStatus(otherStorageOrderEo.getId(), status);
        return true;
    }

    @Override
    public void getContactsInfo(WmsStockOutOrderReqDto dto) {
        CsOtherStorageOrderEo otherStorageOrderEo = (CsOtherStorageOrderEo)((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().eq((Object)"storage_order_no", (Object)dto.getRelevanceNo())).one();
        WmsStockOutOrderReqDto.ReceiverInfo receiverInfo = new WmsStockOutOrderReqDto.ReceiverInfo();
        CubeBeanUtils.copyProperties((Object)receiverInfo, (Object)otherStorageOrderEo, (String[])new String[0]);
        receiverInfo.setContacts(otherStorageOrderEo.getConsignee());
        receiverInfo.setDetailAddress(otherStorageOrderEo.getAddress());
        dto.setReceiverInfo(receiverInfo);
    }

    @Override
    public void getContactsInfo(WmsStockEntryOrderReqDto dto) {
    }

    @Override
    public void updateMainOrderStatus(String relevanceNo, boolean inFlag) {
        String status = inFlag ? CsOtherStorageOrderStatusEnum.IN.HANG_UP.getCode() : CsOtherStorageOrderStatusEnum.OUT.HANG_UP.getCode();
        this.updateOtherOrderStatus(relevanceNo, status);
    }

    @Override
    public void closeOrderStatus(String relevanceNo) {
        this.updateOtherOrderStatus(relevanceNo, CsOtherStorageOrderStatusEnum.OUT.CLOSED.getCode());
    }
}

