/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.cs;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsQualityInfoDetailService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsQualityInfoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsQualityInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.LimsQualityInfoRespDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="QUALITY_INSPECTION_DATA_SYNC", topic="${OP_EXTERNAL_TOPIC:OP_EXTERNAL_TOPIC}")
public class QualityInspectionDataSyncProcess
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(QualityInspectionDataSyncProcess.class);
    @Resource
    private CsQualityInfoDas qualityInfoDas;
    @Resource
    private ICsQualityInfoDetailService qualityInfoDetailService;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(String message) {
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684LIMS\u8d28\u68c0\u4fe1\u606f\uff0cmessage\uff1a{}", (Object)LogUtils.buildLogContent(message));
        Mutex mutex = null;
        try {
            List qualityInfoRespDtoList = JSON.parseArray((String)message, LimsQualityInfoRespDto.class);
            mutex = this.lockService.lock("QUALITY_INFO_SYNC", ((LimsQualityInfoRespDto)qualityInfoRespDtoList.get(0)).getExternalNo());
            if (null == mutex) {
                throw new BizException("\u8ba2\u5355\u540c\u6b65\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            List<CsQualityInfoEo> qualityInfoEoList = this.qualityInfoSync(qualityInfoRespDtoList);
            if (CollectionUtils.isNotEmpty(qualityInfoEoList)) {
                this.qualityInfoDetailService.qualityInfoAdd(qualityInfoEoList);
            }
            this.lockService.unlock(mutex);
        }
        catch (Exception e) {
            log.error("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684LIMS\u8d28\u68c0\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
            MessageResponse messageResponse = MessageResponse.ERROR;
            return messageResponse;
        }
        finally {
            this.lockService.unlock(mutex);
        }
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684LIMS\u8d28\u68c0\u4fe1\u606f\u5b8c\u6bd5");
        return MessageResponse.SUCCESS;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<CsQualityInfoEo> qualityInfoSync(List<LimsQualityInfoRespDto> qualityInfoRespDtoList) {
        ArrayList<CsQualityInfoEo> qualityInfoEoList = new ArrayList<CsQualityInfoEo>();
        qualityInfoRespDtoList.forEach(info -> {
            CsQualityInfoEo qualityInfoEo = new CsQualityInfoEo();
            CubeBeanUtils.copyProperties((Object)qualityInfoEo, (Object)info, (String[])new String[0]);
            if (StringUtils.isNotBlank((CharSequence)info.getQualifiedNum())) {
                qualityInfoEo.setQualifiedNum(new BigDecimal(info.getQualifiedNum()));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getUnqualifiedNum())) {
                qualityInfoEo.setUnqualifiedNum(new BigDecimal(info.getUnqualifiedNum()));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getReleaseNum())) {
                qualityInfoEo.setReleaseNum(new BigDecimal(info.getReleaseNum()));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getReportTime())) {
                qualityInfoEo.setReportTime(DateUtil.parseDate((String)info.getReportTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            qualityInfoEoList.add(qualityInfoEo);
        });
        if (CollectionUtils.isNotEmpty(qualityInfoEoList)) {
            this.qualityInfoDas.insertBatch(qualityInfoEoList);
        }
        return qualityInfoEoList;
    }
}

