/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.cs;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IInternalTradeService;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.InternalTradeReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="TRANSFER_COMPLETE_CREATE_NEXT")
public class CreateNextTransferOrderProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(CreateNextTransferOrderProcess.class);
    @Resource
    private IInternalTradeService internalTradeService;

    public MessageResponse process(MessageVo messageVo) {
        logger.info("CreateNextTransferOrderProcess\uff1amessageVo{}", (Object)messageVo);
        try {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            String preOrderNo = (String)JSON.parseObject((String)messageVo.getData().toString(), String.class);
            InternalTradeReqDto reqDto = new InternalTradeReqDto();
            reqDto.setNo(preOrderNo);
            this.internalTradeService.nextInternalTrade(reqDto);
            logger.info("CreateNextTransferOrderProcess,end");
        }
        catch (Exception e) {
            logger.info("\u6d88\u606f\u961f\u5217\u521b\u5efa\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u5931\u8d25,\u4fe1\u606f\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }
}

