/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICsLogisticsInfoApi;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.CsBasicsOrderStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.ICsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.vo.ModifySaleOrderDeliveryVo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.transaction.annotation.Transactional;

public abstract class CsOutNoticeOrderApiImpl
implements ICsOutNoticeOrderApi {
    private static final Logger log = LoggerFactory.getLogger(CsOutNoticeOrderApiImpl.class);
    @Autowired
    protected ICsOutNoticeOrderService csOutNoticeOrderService;
    @Autowired
    protected IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    protected IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    protected CsTransferOrderMapper csTransferOrderMapper;
    @Autowired
    protected ICsTransferOrderService csTransferOrderService;
    @Autowired
    protected IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    protected ICalcInventoryService calcInventoryService;
    @Autowired
    protected ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    protected IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    protected ICommonsMqService commonsMqService;
    @Autowired
    protected TransactionCallBackService transactionCallBackService;
    @Autowired
    protected IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    protected IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    protected IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    protected IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Resource
    private ICsLogisticsInfoApi csLogisticsInfoApi;

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> sendWms(String documentNo) {
        ICsBasicsOrderOperateService basicsOrderOperateService = CsBasicsOrderStrategyUtils.getBasicsOrderOperateService("inOutNoticeOrder");
        basicsOrderOperateService.sendWms(documentNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delivery(CsTransferOrderReqDto dto) {
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)dto.getTransferOrderNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notNull((Object)csTransferOrderEo, (String)"\u8c03\u62e8\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        InOutResultOrderEo preOutResultOrderEo = null;
        if (StringUtils.isNotBlank((CharSequence)csTransferOrderEo.getPreOrderNo())) {
            CsTransferOrderEo preTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)csTransferOrderEo.getSecondTransferOrderNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notNull((Object)preTransferOrderEo, (String)"\u524d\u7f6e\u8c03\u62e8\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
            List preOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getRelevanceNo, (Object)preTransferOrderEo.getTransferOrderNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)preOutResultOrderEos, (String)"\u524d\u7f6e\u8c03\u62e8\u5355\u51fa\u5e93\u7ed3\u679c\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
            preOutResultOrderEo = (InOutResultOrderEo)preOutResultOrderEos.get(0);
        }
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        csBasicsReceiveReqDto.setEnableAdjustInTransit(Boolean.valueOf(true));
        csBasicsReceiveReqDto.setAdjustInTransitAutoAudit(Boolean.valueOf(true));
        InOutNoticeOrderEo noticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"relevance_no", (Object)dto.getTransferOrderNo())).eq((Object)"order_type", (Object)"out")).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(noticeOrderEo, "\u901a\u77e5\u5355\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        if (!BaseOrderStatusEnum.ONO_WAIT_OUT.getCode().equals(noticeOrderEo.getOrderStatus())) {
            throw new CsInventoryException("\u51fa\u5e93\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u5904\u4e8e\u5f85\u51fa\u5e93\u72b6\u6001\uff0c\u51fa\u5e93\u5931\u8d25", new Object[0]);
        }
        List noticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_no", (Object)noticeOrderEo.getDocumentNo())).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(noticeOrderDetailEos, "\u901a\u77e5\u5355\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(noticeOrderEo.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        csBasicsReceiveReqDto.setShippingCompanyCode(dto.getShippingCompanyCode());
        csBasicsReceiveReqDto.setShippingCompany(dto.getShippingCompany());
        csBasicsReceiveReqDto.setOcsConsignmentNo(dto.getOcsConsignmentNo());
        if (null != preOutResultOrderEo) {
            csBasicsReceiveReqDto.setShippingInfoReqDtoList(JSONArray.parseArray((String)preOutResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class));
            csBasicsReceiveReqDto.setShippingCompanyCode(preOutResultOrderEo.getShippingCompanyCode());
            csBasicsReceiveReqDto.setShippingCompany(preOutResultOrderEo.getShippingCompany());
        }
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo detailEo : noticeOrderDetailEos) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailEo.getBatch());
            inSendBackDetailReqDto.setQuantity(detailEo.getPlanQuantity());
            inSendBackDetailReqDto.setSkuCode(detailEo.getSkuCode());
            inSendBackDetailReqDto.setExpireTime(detailEo.getExpireTime());
            inSendBackDetailReqDto.setProduceTime(detailEo.getProduceTime());
            inSendBackDetailReqDto.setTradeOrderItemId(detailEo.getPreOrderItemId());
            inSendBackDetailReqDto.setWarehouseCode(noticeOrderEo.getOutPhysicsWarehouseCode());
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        wmsExternalService.receiveOut(csBasicsReceiveReqDto);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> receive(String transferNo) {
        log.info("ICsOutNoticeOrderApi.receive-->{}", (Object)transferNo);
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        csBasicsReceiveReqDto.setEnableAdjustInTransit(Boolean.valueOf(true));
        csBasicsReceiveReqDto.setAdjustInTransitAutoAudit(Boolean.valueOf(true));
        InOutNoticeOrderEo noticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"relevance_no", (Object)transferNo)).eq((Object)"order_type", (Object)"in")).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(noticeOrderEo, "\u901a\u77e5\u5355\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        if (!BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(noticeOrderEo.getOrderStatus())) {
            this.doNextSaleTransferOrder(transferNo);
            return RestResponse.VOID;
        }
        List noticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_no", (Object)noticeOrderEo.getDocumentNo())).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(noticeOrderDetailEos, "\u901a\u77e5\u5355\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(noticeOrderEo.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo detailEo : noticeOrderDetailEos) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailEo.getBatch());
            inSendBackDetailReqDto.setQuantity(detailEo.getPlanQuantity());
            inSendBackDetailReqDto.setSkuCode(detailEo.getSkuCode());
            inSendBackDetailReqDto.setExpireTime(detailEo.getExpireTime());
            inSendBackDetailReqDto.setProduceTime(detailEo.getProduceTime());
            inSendBackDetailReqDto.setTradeOrderItemId(detailEo.getPreOrderItemId());
            inSendBackDetailReqDto.setWarehouseCode(noticeOrderEo.getInPhysicsWarehouseCode());
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        wmsExternalService.receiveIn(csBasicsReceiveReqDto);
        this.doNextSaleTransferOrder(transferNo);
        CsTransferOrderRespDto csTransferOrderRespDto = this.csTransferOrderService.queryByTransferOrderNo(transferNo);
        this.syncLogistics(transferNo, csTransferOrderRespDto.getExpressNo(), noticeOrderEo.getInLogicWarehouseName() + "\u5df2\u6536\u8d27");
        return RestResponse.VOID;
    }

    private void syncLogistics(String transferNo, String s, String warehouseName) {
        try {
            CsLogisticsInfoReqDto dataInfo = new CsLogisticsInfoReqDto();
            dataInfo.setType(Integer.valueOf(1));
            dataInfo.setCspNo(transferNo);
            dataInfo.setStatus("5");
            dataInfo.setConsignmentNo(s);
            dataInfo.setShipTime(new Date());
            dataInfo.setDeliveStartTime(new Date());
            dataInfo.setRemark(warehouseName);
            this.csLogisticsInfoApi.addCsLogisticsInfo(dataInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> doNextSaleTransferOrder(String transferNo) {
        log.info("doNextSaleTransferOrder==>{}", (Object)transferNo);
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"transfer_order_no", (Object)transferNo)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (null == csTransferOrderEo) {
            log.info("\u67e5\u8be2\u8c03\u62e8\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return RestResponse.VOID;
        }
        if (StringUtils.isBlank((CharSequence)csTransferOrderEo.getNextLogicWarehouseCode())) {
            log.info("\u67e5\u8be2\u8c03\u62e8\u5355\u4e0b\u4e00\u6b65\u903b\u8f91\u4ed3\u4fe1\u606f\u4e3a\u7a7a");
            return RestResponse.VOID;
        }
        if (StringUtils.isBlank((CharSequence)csTransferOrderEo.getNextPhysicsWarehouseCode())) {
            log.info("\u67e5\u8be2\u8c03\u62e8\u5355\u4e0b\u4e00\u6b65\u7269\u7406\u4ed3\u4fe1\u606f\u4e3a\u7a7a");
            return RestResponse.VOID;
        }
        LogicWarehouseEo nextLogicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)csTransferOrderEo.getNextLogicWarehouseCode())).eq((Object)"warehouse_status", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(nextLogicWarehouseEo, "\u76ee\u7684\u5730\u903b\u8f91\u4ed3\u7f16\u7801\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        PhysicsWarehouseEo nextPhysicsWarehouseEo = (PhysicsWarehouseEo)this.physicsWarehouseDomain.getMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)csTransferOrderEo.getNextPhysicsWarehouseCode())).eq((Object)"warehouse_status", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(nextPhysicsWarehouseEo, "\u76ee\u7684\u5730\u7269\u7406\u4ed3\u7f16\u7801\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        CsTransferOrderComboReqDto csTransferOrderComboReqDto = new CsTransferOrderComboReqDto();
        CsTransferOrderReqDto csTransferOrderReqDto = new CsTransferOrderReqDto();
        BeanUtils.copyProperties((Object)csTransferOrderEo, (Object)csTransferOrderReqDto);
        csTransferOrderReqDto.setId(null);
        csTransferOrderReqDto.setTransferOrderNo(null);
        csTransferOrderReqDto.setOrderStatus(null);
        csTransferOrderReqDto.setPreOrderNo(null);
        if (StringUtils.isNotEmpty((CharSequence)csTransferOrderEo.getNextType())) {
            csTransferOrderReqDto.setType(csTransferOrderEo.getNextType());
        }
        csTransferOrderReqDto.setSecondTransferOrderNo(transferNo);
        csTransferOrderReqDto.setOutLogicWarehouseCode(csTransferOrderEo.getInLogicWarehouseCode());
        csTransferOrderReqDto.setOutLogicWarehouseName(csTransferOrderEo.getInLogicWarehouseName());
        csTransferOrderReqDto.setOutPhysicsWarehouseCode(csTransferOrderEo.getInPhysicsWarehouseCode());
        csTransferOrderReqDto.setOutPhysicsWarehouseName(csTransferOrderEo.getInPhysicsWarehouseName());
        csTransferOrderReqDto.setInLogicWarehouseCode(nextLogicWarehouseEo.getWarehouseCode());
        csTransferOrderReqDto.setInLogicWarehouseName(nextLogicWarehouseEo.getWarehouseName());
        csTransferOrderReqDto.setInPhysicsWarehouseCode(nextPhysicsWarehouseEo.getWarehouseCode());
        csTransferOrderReqDto.setInPhysicsWarehouseName(nextPhysicsWarehouseEo.getWarehouseName());
        csTransferOrderReqDto.setNextLogicWarehouseCode(null);
        csTransferOrderReqDto.setNextPhysicsWarehouseCode(null);
        csTransferOrderReqDto.setValidNegative(Boolean.valueOf(false));
        csTransferOrderComboReqDto.setCsOtherStorageOrderReqDto(csTransferOrderReqDto);
        List InOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getRelevanceNo, (Object)csTransferOrderEo.getTransferOrderNo())).eq(InOutResultOrderEo::getOrderType, (Object)"out")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(InOutResultOrderEos, "\u8c03\u62e8\u5355\u5173\u8054\u51fa\u5e93\u7ed3\u679c\u5355\u4e0d\u5b58\u5728", new Object[0]);
        if (InOutResultOrderEos.size() > 1) {
            throw new CsInventoryException("\u8c03\u62e8\u5355\u5173\u8054\u51fa\u5e93\u7ed3\u679c\u5355\u4e0d\u552f\u4e00", new Object[0]);
        }
        InOutResultOrderEo InOutResultOrderEo2 = (InOutResultOrderEo)InOutResultOrderEos.get(0);
        List outResultOrderDetailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderDetailEo.class).eq(InOutResultOrderDetailEo::getDocumentNo, (Object)InOutResultOrderEo2.getDocumentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(outResultOrderDetailEos, "\u8c03\u62e8\u5355\u51fa\u5e93\u7ed3\u679c\u660e\u7ec6\u4e0d\u5b58\u5728", new Object[0]);
        ArrayList csTransferOrderDetailReqDtos = Lists.newArrayList();
        for (InOutResultOrderDetailEo outResultOrderDetailEo : outResultOrderDetailEos) {
            CsTransferOrderDetailReqDto detailReqDto = new CsTransferOrderDetailReqDto();
            detailReqDto.setQuantity(outResultOrderDetailEo.getQuantity());
            detailReqDto.setBatch(outResultOrderDetailEo.getBatch());
            detailReqDto.setCargoCode(outResultOrderDetailEo.getSkuCode());
            detailReqDto.setLongCode(outResultOrderDetailEo.getSkuCode());
            detailReqDto.setArtNo(outResultOrderDetailEo.getSkuCode());
            detailReqDto.setCargoName(outResultOrderDetailEo.getSkuName());
            detailReqDto.setDueDate(DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)outResultOrderDetailEo.getExpireTime()));
            detailReqDto.setProductDate(DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)outResultOrderDetailEo.getProduceTime()));
            detailReqDto.setVolume(outResultOrderDetailEo.getVolume());
            csTransferOrderDetailReqDtos.add(detailReqDto);
        }
        csTransferOrderComboReqDto.setDetailList((List)csTransferOrderDetailReqDtos);
        this.csTransferOrderService.addTransferOrder(csTransferOrderComboReqDto);
        List receiveDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ReceiveDeliveryNoticeOrderEo.class).eq(ReceiveDeliveryNoticeOrderEo::getRelevanceNo, (Object)csTransferOrderEo.getSaleOrderNo())).eq(ReceiveDeliveryNoticeOrderEo::getOrderType, (Object)"delivery")).eq(ReceiveDeliveryNoticeOrderEo::getOrderStatus, (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEos)) {
            ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEos.get(0);
            this.baseOrderFacade.deliveryNoticeOrderCancel(BaseOrderCommonCancelBo.builder().documentNo(receiveDeliveryNoticeOrderEo.getDocumentNo()).businessType(receiveDeliveryNoticeOrderEo.getBusinessType()).sourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode()).isSaleOrder(Boolean.TRUE).onlyDelivery(Boolean.TRUE).build());
        }
        this.transactionCallBackService.execute(() -> {
            ModifySaleOrderDeliveryVo modifySaleOrderDeliveryVo = new ModifySaleOrderDeliveryVo();
            modifySaleOrderDeliveryVo.setSaleOrderNo(csTransferOrderEo.getSaleOrderNo());
            modifySaleOrderDeliveryVo.setLogicWarehouseId(nextLogicWarehouseEo.getId());
            modifySaleOrderDeliveryVo.setLogicWarehouseCode(nextLogicWarehouseEo.getWarehouseCode());
            modifySaleOrderDeliveryVo.setLogicWarehouseName(nextLogicWarehouseEo.getWarehouseName());
            modifySaleOrderDeliveryVo.setPhysicsWarehouseId(nextPhysicsWarehouseEo.getId());
            modifySaleOrderDeliveryVo.setPhysicsWarehouseCode(nextPhysicsWarehouseEo.getWarehouseCode());
            modifySaleOrderDeliveryVo.setPhysicsWarehouseName(nextPhysicsWarehouseEo.getWarehouseName());
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSON.toJSONString((Object)modifySaleOrderDeliveryVo));
            this.commonsMqService.publishMessage("INVENTORY_MODIFY_SALE_ORDER_DELIVERY", (Object)messageVo);
        });
        return RestResponse.VOID;
    }

    public RestResponse<String> getConsignmentNo(String transferNo) {
        return new RestResponse((Object)this.csOutNoticeOrderService.getConsignmentNo(transferNo));
    }
}

