/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsOtherStorageOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsOtherStorageOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsOtherStorageOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsOtherStorageOrderDetailServiceImpl
implements ICsOtherStorageOrderDetailService {
    @Resource
    private CsOtherStorageOrderDetailDas csOtherStorageOrderDetailDas;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;

    @Override
    public Long addCsOtherStorageOrderDetail(CsOtherStorageOrderDetailReqDto addReqDto) {
        CsOtherStorageOrderDetailEo csOtherStorageOrderDetailEo = new CsOtherStorageOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csOtherStorageOrderDetailEo);
        this.csOtherStorageOrderDetailDas.insert((BaseEo)csOtherStorageOrderDetailEo);
        return csOtherStorageOrderDetailEo.getId();
    }

    @Override
    public void modifyCsOtherStorageOrderDetail(CsOtherStorageOrderDetailReqDto modifyReqDto) {
        CsOtherStorageOrderDetailEo csOtherStorageOrderDetailEo = new CsOtherStorageOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csOtherStorageOrderDetailEo);
        this.csOtherStorageOrderDetailDas.updateSelective((BaseEo)csOtherStorageOrderDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsOtherStorageOrderDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csOtherStorageOrderDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsOtherStorageOrderDetailRespDto queryById(Long id) {
        CsOtherStorageOrderDetailEo csOtherStorageOrderDetailEo = (CsOtherStorageOrderDetailEo)this.csOtherStorageOrderDetailDas.selectByPrimaryKey(id);
        CsOtherStorageOrderDetailRespDto csOtherStorageOrderDetailRespDto = new CsOtherStorageOrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)csOtherStorageOrderDetailEo, (BaseVo)csOtherStorageOrderDetailRespDto);
        return csOtherStorageOrderDetailRespDto;
    }

    @Override
    public PageInfo<CsOtherStorageOrderDetailRespDto> queryByPage(String otherOrderNo, String type, Integer pageNum, Integer pageSize) {
        CsOtherStorageOrderDetailEo csOtherStorageOrderDetailEo = new CsOtherStorageOrderDetailEo();
        csOtherStorageOrderDetailEo.setOtherOrderNo(otherOrderNo);
        PageInfo eoPageInfo = this.csOtherStorageOrderDetailDas.selectPage((BaseEo)csOtherStorageOrderDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsOtherStorageOrderDetailRespDto.class);
        if (CollectionUtil.isNotEmpty(dtoList)) {
            // empty if block
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CsOtherStorageOrderDetailRespDto> queryListByOtherOrderNo(String otherOrderNo, String type) {
        return this.queryListByOtherOrderNo(Lists.newArrayList((Object[])new String[]{otherOrderNo}));
    }

    @Override
    public List<CsOtherStorageOrderDetailRespDto> queryListByOtherOrderNo(List<String> otherOrderNos) {
        ArrayList<CsOtherStorageOrderDetailRespDto> dtoList = new ArrayList<CsOtherStorageOrderDetailRespDto>();
        List detailEos = ((ExtQueryChainWrapper)this.csOtherStorageOrderDetailDas.filter().in((Object)"other_order_no", otherOrderNos)).list();
        if (CollectionUtil.isNotEmpty((Collection)detailEos)) {
            DtoHelper.eoList2DtoList((Collection)detailEos, dtoList, CsOtherStorageOrderDetailRespDto.class);
        }
        return dtoList;
    }

    private void totalFinishQuantity(String otherOrderNo, List<CsOtherStorageOrderDetailRespDto> dtoList, String type) {
        Map<Object, Object> finishMap = new HashMap();
        if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(type)) {
            List outResultOrderDetailList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)otherOrderNo)).list();
            if (CollectionUtil.isNotEmpty((Collection)outResultOrderDetailList)) {
                finishMap = outResultOrderDetailList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
            }
        } else {
            List csInResultOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)otherOrderNo)).list();
            if (CollectionUtil.isNotEmpty((Collection)csInResultOrderDetailEoList)) {
                finishMap = csInResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
            }
        }
        if (CollectionUtil.isNotEmpty(finishMap)) {
            for (CsOtherStorageOrderDetailRespDto d : dtoList) {
                d.setFinishQuantity(finishMap.get(d.getLongCode()) == null ? BigDecimal.ZERO : BigDecimal.valueOf((Double)finishMap.get(d.getLongCode())));
            }
        }
    }
}

