/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter.bd;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.LogicWarehouseExposedApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bd_LogicWarehouseExposedApi")
public class BdLogicWarehouseExposedApiImpl
extends LogicWarehouseExposedApiImpl {
    private static final Logger log = LoggerFactory.getLogger(BdLogicWarehouseExposedApiImpl.class);
    @Autowired
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    private IRelWarehouseDomain relWarehouseDomain;

    @Override
    public RestResponse<CsLogicWarehouseDetailRespDto> queryDetailById(Long id) {
        log.info("queryDetailById==>\u6839\u636e\u4ed3\u5e93\u4fe1\u606f\u67e5\u8be2\u4ed3\u5e93\u8be6\u60c5\u4fe1\u606f,id:{}", (Object)id);
        AssertUtil.isTrue(null != id, "\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo LogicWarehouseEo2 = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectById((Serializable)id);
        AssertUtil.isTrue(null != LogicWarehouseEo2, "\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f");
        CsLogicWarehouseDetailRespDto respDto = new CsLogicWarehouseDetailRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)LogicWarehouseEo2, (String[])new String[0]);
        respDto.setContact(LogicWarehouseEo2.getContact());
        respDto.setPhone(LogicWarehouseEo2.getPhone());
        respDto.setThirdCode(LogicWarehouseEo2.getThirdCode());
        respDto.setWarehouseCorrespondingSystem(LogicWarehouseEo2.getWarehouseCorrespondingSystem());
        respDto.setWarehouseType(LogicWarehouseEo2.getWarehouseType());
        respDto.setDeliveryReturnWarehouseName(LogicWarehouseEo2.getDeliveryReturnWarehouseName());
        respDto.setDeliveryReturnWarehouseCode(LogicWarehouseEo2.getDeliveryReturnWarehouseCode());
        if (StrUtil.isNotBlank((CharSequence)LogicWarehouseEo2.getDeliveryReturnWarehouseCode())) {
            List LogicWarehouseEos = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{LogicWarehouseEo2.getDeliveryReturnWarehouseCode()}));
            respDto.setDeliveryReturnWarehouseId(CollUtil.isNotEmpty((Collection)LogicWarehouseEos) && ObjectUtil.isNotNull(LogicWarehouseEos.get(0)) ? ((LogicWarehouseEo)LogicWarehouseEos.get(0)).getId() : null);
        }
        respDto.setInterconnectionFlag(LogicWarehouseEo2.getInterconnectionFlag());
        if (null != LogicWarehouseEo2 || null != LogicWarehouseEo2.getId()) {
            WarehouseAddressEo WarehouseAddressEo2 = new WarehouseAddressEo();
            WarehouseAddressEo2.setWarehouseId(id);
            WarehouseAddressEo2.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            List warehouseAddressEos = this.warehouseAddressDomain.selectList((BaseEo)WarehouseAddressEo2);
            if (CollectionUtils.isNotEmpty((Collection)warehouseAddressEos)) {
                CsWarehouseAddressRespDto warehouseAddressRespDto = new CsWarehouseAddressRespDto();
                CubeBeanUtils.copyProperties((Object)warehouseAddressRespDto, warehouseAddressEos.get(0), (String[])new String[0]);
                respDto.setWarehouseAddress(warehouseAddressRespDto);
            }
        }
        QueryWrapper relWarehouseEoQueryWrapper = new QueryWrapper();
        relWarehouseEoQueryWrapper.eq((Object)"warehouse_id", (Object)id);
        relWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        relWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        relWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        RelWarehouseEo RelWarehouseEo2 = (RelWarehouseEo)this.relWarehouseDomain.getMapper().selectOne((Wrapper)relWarehouseEoQueryWrapper);
        if (null != RelWarehouseEo2) {
            respDto.setSubordinatePhysicsWarehouseId(RelWarehouseEo2.getRefWarehouseId());
            respDto.setSubordinatePhysicsWarehouseName(RelWarehouseEo2.getRefWarehouseName());
        }
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<PageInfo<CsLogicWarehousePageRespDto>> queryPageInfo(CsLogicWarehousePageQueryDto csLogicWarehousePageQueryDto) {
        log.info("queryPageInfo==>\u903b\u8f91\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,csLogicWarehousePageQueryDto:{}", (Object)LogUtils.buildLogContent(csLogicWarehousePageQueryDto));
        AssertUtil.isTrue(null != csLogicWarehousePageQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csLogicWarehousePageQueryDto.getPageNum() && csLogicWarehousePageQueryDto.getPageNum() > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csLogicWarehousePageQueryDto.getPageSize() && csLogicWarehousePageQueryDto.getPageSize() > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        QueryWrapper<LogicWarehouseEo> logicWrapper = this.buildQueryWrapper(csLogicWarehousePageQueryDto);
        if (Objects.isNull(logicWrapper)) {
            return new RestResponse((Object)new PageInfo());
        }
        Long subordinatePhysicsWarehouseId = csLogicWarehousePageQueryDto.getSubordinatePhysicsWarehouseId();
        if (null != subordinatePhysicsWarehouseId) {
            List<RelWarehouseEo> relWarehouseEoList = this.queryRelLogicWarehouseInfo(subordinatePhysicsWarehouseId);
            if (CollectionUtils.isEmpty(relWarehouseEoList)) {
                log.info("\u9009\u62e9\u7684\u7269\u7406\u4ed3\u67e5\u8be2\u4e0d\u5230\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f");
                return new RestResponse((Object)new PageInfo());
            }
            List logicWarehouseIdList = relWarehouseEoList.stream().map(RelWarehouseEo::getRefWarehouseId).distinct().collect(Collectors.toList());
            logicWrapper.in((Object)"id", logicWarehouseIdList);
        }
        logicWrapper.orderByDesc((Object)"id");
        if (StringUtils.isNotBlank((CharSequence)csLogicWarehousePageQueryDto.getVirtualMatterFlag())) {
            logicWrapper.eq((Object)"virtual_matter_flag", (Object)csLogicWarehousePageQueryDto.getVirtualMatterFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)csLogicWarehousePageQueryDto.getThirdCode())) {
            logicWrapper.like((Object)"third_code", (Object)csLogicWarehousePageQueryDto.getThirdCode());
        }
        if (StringUtils.isNotBlank((CharSequence)csLogicWarehousePageQueryDto.getWarehouseCorrespondingSystem())) {
            logicWrapper.like((Object)"warehouse_corresponding_system", (Object)csLogicWarehousePageQueryDto.getWarehouseCorrespondingSystem());
        }
        PageHelper.startPage((int)csLogicWarehousePageQueryDto.getPageNum(), (int)csLogicWarehousePageQueryDto.getPageSize());
        log.info("queryPageInfo===>\u903b\u8f91\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,logicWrapper:{}", (Object)LogUtils.buildLogContent(logicWrapper));
        List LogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList(logicWrapper);
        log.info("queryPageInfo===>\u903b\u8f91\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,LogicWarehouseEoList:{}", (Object)LogUtils.buildLogContent(LogicWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)LogicWarehouseEoList)) {
            return new RestResponse((Object)new PageInfo());
        }
        List queryLogicIdList = LogicWarehouseEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        QueryWrapper logicQueryWrapper = new QueryWrapper();
        logicQueryWrapper.in((Object)"warehouse_id", queryLogicIdList);
        logicQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        logicQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        logicQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List relWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)logicQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)relWarehouseEoList)) {
            return new RestResponse((Object)new PageInfo());
        }
        Map relWarehouseEoMap = relWarehouseEoList.stream().collect(Collectors.toMap(eo -> eo.getWarehouseCode(), Function.identity()));
        ArrayList resList = Lists.newArrayList();
        for (LogicWarehouseEo LogicWarehouseEo2 : LogicWarehouseEoList) {
            CsLogicWarehousePageRespDto csLogicWarehousePageRespDto = new CsLogicWarehousePageRespDto();
            CubeBeanUtils.copyProperties((Object)csLogicWarehousePageRespDto, (Object)LogicWarehouseEo2, (String[])new String[0]);
            String warehouseCode = LogicWarehouseEo2.getWarehouseCode();
            RelWarehouseEo relWarehouseEo = (RelWarehouseEo)relWarehouseEoMap.get(warehouseCode);
            if (null != relWarehouseEo) {
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseId(relWarehouseEo.getRefWarehouseId());
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseName(relWarehouseEo.getRefWarehouseName());
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseCode(relWarehouseEo.getRefWarehouseCode());
            }
            resList.add(csLogicWarehousePageRespDto);
        }
        PageInfo info = new PageInfo(LogicWarehouseEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList((List)resList);
        this.buildWarehouseAddressInfo(resList);
        return new RestResponse((Object)result);
    }

    @Override
    public RestResponse<CsLogicWarehouseDetailRespDto> queryDetailByCode(String code) {
        List eoList = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)code)).list();
        log.info("\u6839\u636e\u4ed3\u5e93\u7f16\u7801\uff1a{}\u67e5\u8be2\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)code, (Object)JSON.toJSONString((Object)eoList));
        if (CollUtil.isEmpty((Collection)eoList)) {
            return new RestResponse((Object)new CsLogicWarehouseDetailRespDto());
        }
        Long id = ((LogicWarehouseEo)eoList.get(0)).getId();
        return this.queryDetailById(id);
    }

    private QueryWrapper<LogicWarehouseEo> buildQueryWrapper(CsLogicWarehousePageQueryDto csLogicWarehousePageQueryDto) {
        QueryWrapper relWarehouseQueryWrapper;
        String cargoEscheatageId;
        String warehouseProperty;
        String warehouseQuality;
        String easWarehouseCode;
        String warehouseStatus;
        String warehouseName;
        QueryWrapper logicWrapper = new QueryWrapper();
        logicWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        String warehouseCode = csLogicWarehousePageQueryDto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            logicWrapper.like((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = csLogicWarehousePageQueryDto.getWarehouseName()))) {
            logicWrapper.like((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseStatus = csLogicWarehousePageQueryDto.getWarehouseStatus()))) {
            logicWrapper.eq((Object)"warehouse_status", (Object)warehouseStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(easWarehouseCode = csLogicWarehousePageQueryDto.getEasWarehouseCode()))) {
            logicWrapper.like((Object)"eas_warehouse_code", (Object)easWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseQuality = csLogicWarehousePageQueryDto.getWarehouseQuality()))) {
            logicWrapper.eq((Object)"warehouse_quality", (Object)warehouseQuality);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseProperty = csLogicWarehousePageQueryDto.getWarehouseProperty()))) {
            logicWrapper.eq((Object)"warehouse_property", (Object)warehouseProperty);
        }
        if (StringUtils.isNotBlank((CharSequence)(cargoEscheatageId = csLogicWarehousePageQueryDto.getCargoEscheatageId()))) {
            logicWrapper.eq((Object)"cargo_escheatage_id", (Object)cargoEscheatageId);
        }
        if (CollectionUtils.isNotEmpty((Collection)csLogicWarehousePageQueryDto.getWarehouseCodes())) {
            logicWrapper.in((Object)"warehouse_code", (Collection)csLogicWarehousePageQueryDto.getWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)csLogicWarehousePageQueryDto.getWarehousePropertyList())) {
            logicWrapper.in((Object)"warehouse_property", (Collection)csLogicWarehousePageQueryDto.getWarehousePropertyList());
        }
        if (StringUtils.isNotBlank((CharSequence)csLogicWarehousePageQueryDto.getPosWarehouseCode())) {
            logicWrapper.eq((Object)"pos_warehouse_code", (Object)csLogicWarehousePageQueryDto.getPosWarehouseCode());
        }
        List respDtoList = new ArrayList();
        if (Objects.nonNull(csLogicWarehousePageQueryDto.getShopChannelId())) {
            relWarehouseQueryWrapper = new QueryWrapper();
            relWarehouseQueryWrapper.eq((Object)"shop_channel_id", (Object)csLogicWarehousePageQueryDto.getShopChannelId());
            relWarehouseQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.CHANNEL.getCode());
            relWarehouseQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
            relWarehouseQueryWrapper.eq((Object)"dr", (Object)0);
            respDtoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)relWarehouseQueryWrapper);
            if (CollectionUtils.isEmpty(respDtoList)) {
                return null;
            }
        }
        if (CollectionUtils.isNotEmpty(respDtoList) || StringUtils.isNotBlank((CharSequence)csLogicWarehousePageQueryDto.getChannelWarehouseCode())) {
            relWarehouseQueryWrapper = new QueryWrapper();
            if (CollectionUtils.isNotEmpty(respDtoList)) {
                Set channelWarehouseIds = respDtoList.stream().map(e -> e.getWarehouseId()).collect(Collectors.toSet());
                relWarehouseQueryWrapper.in((Object)"warehouse_id", channelWarehouseIds);
            }
            if (StringUtils.isNotBlank((CharSequence)csLogicWarehousePageQueryDto.getChannelWarehouseCode())) {
                relWarehouseQueryWrapper.eq((Object)"warehouse_code", (Object)csLogicWarehousePageQueryDto.getChannelWarehouseCode());
            }
            relWarehouseQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.CHANNEL.getCode());
            relWarehouseQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
            relWarehouseQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
            relWarehouseQueryWrapper.eq((Object)"dr", (Object)0);
            List relWarehouseEos = this.relWarehouseDomain.getMapper().selectList((Wrapper)relWarehouseQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)relWarehouseEos)) {
                return null;
            }
            Set ids = relWarehouseEos.stream().map(e -> e.getRefWarehouseId()).collect(Collectors.toSet());
            logicWrapper.in((Object)"id", ids);
        }
        return logicWrapper;
    }

    @Override
    public RestResponse<List<CsLogicWarehousePageRespDto>> queryParam(CsLogicWarehouseParamQueryDto csLogicWarehouseParamQueryDto) {
        List thirdCodeList;
        Long subordinatePhysicsWarehouseId;
        String cargoEscheatageId;
        String easWarehouseCode;
        String warehouseStatus;
        String warehouseName;
        List warehouseCodeList;
        AssertUtil.isTrue(null != csLogicWarehouseParamQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Integer queryRelPhysicsWarehouse = null == csLogicWarehouseParamQueryDto.getQueryRelPhysicsWarehouse() ? YesNoEnum.NO.getValue() : csLogicWarehouseParamQueryDto.getQueryRelPhysicsWarehouse();
        csLogicWarehouseParamQueryDto.setQueryRelPhysicsWarehouse(queryRelPhysicsWarehouse);
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List warehouseIdList = csLogicWarehouseParamQueryDto.getWarehouseIdList();
        if (StringUtil.isNotBlank((String)csLogicWarehouseParamQueryDto.getCode())) {
            csLogicWarehouseEoQueryWrapper.like((Object)"warehouse_code", (Object)csLogicWarehouseParamQueryDto.getCode());
        }
        if (StringUtil.isNotBlank((String)csLogicWarehouseParamQueryDto.getName())) {
            csLogicWarehouseEoQueryWrapper.like((Object)"warehouse_name", (Object)csLogicWarehouseParamQueryDto.getName());
        }
        if (CollectionUtils.isNotEmpty((Collection)warehouseIdList)) {
            csLogicWarehouseEoQueryWrapper.in((Object)"id", (Collection)warehouseIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(warehouseCodeList = csLogicWarehouseParamQueryDto.getWarehouseCodeList()))) {
            csLogicWarehouseEoQueryWrapper.in((Object)"warehouse_code", (Collection)warehouseCodeList);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = csLogicWarehouseParamQueryDto.getWarehouseName()))) {
            csLogicWarehouseEoQueryWrapper.likeRight((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)csLogicWarehouseParamQueryDto.getWarehouseNameAccurate())) {
            csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_name", (Object)csLogicWarehouseParamQueryDto.getWarehouseNameAccurate());
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseStatus = csLogicWarehouseParamQueryDto.getWarehouseStatus()))) {
            csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)warehouseStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(easWarehouseCode = csLogicWarehouseParamQueryDto.getEasWarehouseCode()))) {
            csLogicWarehouseEoQueryWrapper.eq((Object)"eas_warehouse_code", (Object)easWarehouseCode);
        }
        if (null != (cargoEscheatageId = csLogicWarehouseParamQueryDto.getCargoEscheatageId())) {
            csLogicWarehouseEoQueryWrapper.eq((Object)"cargo_escheatage_id", (Object)cargoEscheatageId);
        }
        if (StringUtils.isNotBlank((CharSequence)csLogicWarehouseParamQueryDto.getPosWarehouseCode())) {
            csLogicWarehouseEoQueryWrapper.eq((Object)"pos_warehouse_code", (Object)csLogicWarehouseParamQueryDto.getPosWarehouseCode());
        }
        if (null != (subordinatePhysicsWarehouseId = csLogicWarehouseParamQueryDto.getSubordinatePhysicsWarehouseId())) {
            List<RelWarehouseEo> csRelWarehouseEoList = this.queryRelLogicWarehouseInfo(subordinatePhysicsWarehouseId);
            if (CollectionUtils.isEmpty(csRelWarehouseEoList)) {
                log.info("\u9009\u62e9\u7684\u7269\u7406\u4ed3\u67e5\u8be2\u4e0d\u5230\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f");
                return new RestResponse((Object)Lists.newArrayList());
            }
            List logicWarehouseIdList = csRelWarehouseEoList.stream().map(RelWarehouseEo::getRefWarehouseId).distinct().collect(Collectors.toList());
            csLogicWarehouseEoQueryWrapper.in((Object)"id", logicWarehouseIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(thirdCodeList = csLogicWarehouseParamQueryDto.getThirdCodeList()))) {
            StringBuilder sql = new StringBuilder();
            sql.append(" ( ");
            for (int i = 0; i < thirdCodeList.size(); ++i) {
                String thirdCode = (String)thirdCodeList.get(i);
                sql.append("third_code like '%" + thirdCode + "%'");
                if (i >= thirdCodeList.size() - 1) continue;
                sql.append(" or ");
            }
            sql.append(")");
            csLogicWarehouseEoQueryWrapper.apply(sql.toString(), new Object[0]);
        }
        log.info("queryParam===>\u903b\u8f91\u4ed3\u6839\u636e\u53c2\u6570\u8fdb\u884c\u5217\u8868\u67e5\u8be2,csLogicWarehouseEoQueryWrapper:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseEoQueryWrapper));
        List<LogicWarehouseEo> csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)csLogicWarehouseEoQueryWrapper);
        log.info("queryParam===>\u903b\u8f91\u4ed3\u6839\u636e\u53c2\u6570\u8fdb\u884c\u5217\u8868\u67e5\u8be2,csLogicWarehouseEoQueryWrapper:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csLogicWarehouseEoList)) {
            return new RestResponse((Object)Lists.newArrayList());
        }
        csLogicWarehouseEoList = this.likeFilterWarehouseEoList(thirdCodeList, csLogicWarehouseEoList);
        Map<Long, RelWarehouseEo> csRelWarehouseEoMap = this.queryRelPhysicsWarehouseInfo(csLogicWarehouseParamQueryDto, csLogicWarehouseEoList);
        ArrayList resultList = Lists.newArrayList();
        for (LogicWarehouseEo csLogicWarehouseEo : csLogicWarehouseEoList) {
            CsLogicWarehousePageRespDto csLogicWarehousePageRespDto = new CsLogicWarehousePageRespDto();
            CubeBeanUtils.copyProperties((Object)csLogicWarehousePageRespDto, (Object)csLogicWarehouseEo, (String[])new String[0]);
            Long logicWarehouseEoId = csLogicWarehouseEo.getId();
            RelWarehouseEo csRelWarehouseEo = csRelWarehouseEoMap.get(logicWarehouseEoId);
            if (null != csRelWarehouseEo) {
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseId(csRelWarehouseEo.getRefWarehouseId());
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
            }
            resultList.add(csLogicWarehousePageRespDto);
        }
        return new RestResponse((Object)resultList);
    }

    public RestResponse<List<String>> modifyPhysicalWarehouseStatus(List<String> ids, String status) {
        return new RestResponse(this.csLogicWarehouseExposedService.modifyPhysicalWarehouseStatus(ids, status));
    }

    private Map<Long, RelWarehouseEo> queryRelPhysicsWarehouseInfo(CsLogicWarehouseParamQueryDto csLogicWarehouseParamQueryDto, List<LogicWarehouseEo> csLogicWarehouseEoList) {
        Integer queryRelPhysicsWarehouse = csLogicWarehouseParamQueryDto.getQueryRelPhysicsWarehouse();
        Map<Object, Object> csRelWarehouseEoMap = Maps.newHashMap();
        if (YesNoEnum.NO.getValue().equals(queryRelPhysicsWarehouse)) {
            return csRelWarehouseEoMap;
        }
        List queryLogicIdList = csLogicWarehouseEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        QueryWrapper logicQueryWrapper = new QueryWrapper();
        logicQueryWrapper.in((Object)"warehouse_id", queryLogicIdList);
        logicQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        logicQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        logicQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)logicQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList)) {
            csRelWarehouseEoMap = csRelWarehouseEoList.stream().collect(Collectors.toMap(eo -> eo.getWarehouseId(), Function.identity()));
        }
        return csRelWarehouseEoMap;
    }

    private List<LogicWarehouseEo> likeFilterWarehouseEoList(List<String> thirdCodeList, List<LogicWarehouseEo> csLogicWarehouseEoList) {
        if (CollectionUtils.isNotEmpty(thirdCodeList)) {
            ArrayList filterEoList = Lists.newArrayList();
            Map<String, LogicWarehouseEo> warehouseEoMap = this.getWarehouseEoMap(csLogicWarehouseEoList);
            for (String thirdCode : thirdCodeList) {
                if (warehouseEoMap.get(thirdCode) == null) continue;
                filterEoList.add(warehouseEoMap.get(thirdCode));
            }
            return filterEoList;
        }
        return csLogicWarehouseEoList;
    }

    private Map<String, LogicWarehouseEo> getWarehouseEoMap(List<LogicWarehouseEo> csLogicWarehouseEoList) {
        HashMap warehouseEoMap = Maps.newHashMap();
        for (LogicWarehouseEo logicWarehouseEo : csLogicWarehouseEoList) {
            if (!StringUtils.isNotEmpty((CharSequence)logicWarehouseEo.getThirdCode())) continue;
            for (String thirdCode : logicWarehouseEo.getThirdCode().split(",")) {
                LogicWarehouseEo eo = new LogicWarehouseEo();
                CubeBeanUtils.copyProperties((Object)eo, (Object)logicWarehouseEo, (String[])new String[0]);
                eo.setThirdCode(thirdCode);
                warehouseEoMap.put(thirdCode, eo);
            }
        }
        return warehouseEoMap;
    }

    private List<RelWarehouseEo> queryRelLogicWarehouseInfo(Long subordinatePhysicsWarehouseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_id", (Object)subordinatePhysicsWarehouseId);
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List relWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
        return relWarehouseEoList;
    }

    private void buildWarehouseAddressInfo(List<CsLogicWarehousePageRespDto> resList) {
        if (CollectionUtils.isEmpty(resList)) {
            return;
        }
        List warehouseCodeList = resList.stream().map(CsLogicWarehousePageRespDto::getWarehouseCode).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List WarehouseAddressEoList = this.warehouseAddressDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)WarehouseAddressEoList)) {
            return;
        }
        Map<String, List<WarehouseAddressEo>> warehouseAddressMap = WarehouseAddressEoList.stream().collect(Collectors.groupingBy(WarehouseAddressEo::getWarehouseCode));
        for (CsLogicWarehousePageRespDto csLogicWarehousePageRespDto : resList) {
            String warehouseCode = csLogicWarehousePageRespDto.getWarehouseCode();
            List<WarehouseAddressEo> warehouseAddressEoList = warehouseAddressMap.get(warehouseCode);
            if (CollectionUtils.isEmpty(warehouseAddressEoList)) continue;
            WarehouseAddressEo WarehouseAddressEo2 = warehouseAddressEoList.get(0);
            CsWarehouseAddressRespDto warehouseAddress = new CsWarehouseAddressRespDto();
            CubeBeanUtils.copyProperties((Object)warehouseAddress, (Object)WarehouseAddressEo2, (String[])new String[0]);
            csLogicWarehousePageRespDto.setWarehouseAddress(warehouseAddress);
        }
    }
}

