/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsActivityInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsActivityInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsActivityInventoryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsActivityInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsActivityInventoryAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsActivityInventoryUpdateReqDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csActivityInventoryService")
public class CsActivityInventoryServiceImpl
implements ICsActivityInventoryService {
    private static Logger logger = LoggerFactory.getLogger(CsActivityInventoryServiceImpl.class);
    @Autowired
    private CsActivityInventoryDas csActivityInventoryDas;
    @Autowired
    private ICsActivityInventoryQueryService csActivityInventoryQueryService;

    @Override
    public Long add(CsActivityInventoryAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsActivityInventoryEo insertEo = CsActivityInventoryEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csActivityInventoryDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsActivityInventoryUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsActivityInventoryEo updateEo = CsActivityInventoryEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csActivityInventoryDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsActivityInventoryEo eo = this.csActivityInventoryQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csActivityInventoryDas.logicDeleteById(id);
    }
}

