/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IOaApplyFormService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OaApplyFormDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OaApplyFormEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.oa.req.OaApplyFormQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.oa.req.OaApplyFormSaveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.oa.resp.OaApplyFormRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OaApplyFormServiceImpl
implements IOaApplyFormService {
    private static final Logger logger = LoggerFactory.getLogger(OaApplyFormServiceImpl.class);
    @Resource
    private OaApplyFormDas oaApplyFormDas;

    @Override
    @Transactional
    public Long saveOaApplyForm(OaApplyFormSaveReqDto reqDto) {
        OaApplyFormEo eo = this.convertToEntity(reqDto);
        if (eo.getId() == null) {
            this.oaApplyFormDas.insert((BaseEo)eo);
        } else {
            this.oaApplyFormDas.updateSelective((BaseEo)eo);
        }
        return eo.getId();
    }

    @Override
    @Transactional
    public void updateStatus(Long id, String status) {
        OaApplyFormEo eo = new OaApplyFormEo();
        eo.setId(id);
        eo.setStatus(status);
        this.oaApplyFormDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional
    public void batchUpdateStatus(List<Long> ids, String status) {
        for (Long id : ids) {
            this.updateStatus(id, status);
        }
    }

    @Override
    @Transactional
    public void deleteById(Long id) {
        this.oaApplyFormDas.deleteByLogicKey((Object)id);
    }

    @Override
    public OaApplyFormRespDto queryById(Long id) {
        OaApplyFormEo eo = (OaApplyFormEo)this.oaApplyFormDas.selectByPrimaryKey(id);
        return this.convertToResponse(eo);
    }

    @Override
    public OaApplyFormRespDto queryByFormNo(String formNo) {
        OaApplyFormEo eo = (OaApplyFormEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.oaApplyFormDas.filter().eq((Object)"form_no", (Object)formNo)).eq((Object)"dr", (Object)0)).one();
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)eo), "OA\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        return this.convertToResponse(eo);
    }

    @Override
    public PageInfo<OaApplyFormRespDto> queryByPage(OaApplyFormQueryReqDto queryDto, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageInfo();
    }

    @Override
    public List<OaApplyFormRespDto> queryByParams(OaApplyFormQueryReqDto reqDto) {
        return new ArrayList<OaApplyFormRespDto>();
    }

    private OaApplyFormEo convertToEntity(OaApplyFormSaveReqDto reqDto) {
        OaApplyFormEo eo = new OaApplyFormEo();
        eo.setId(reqDto.getId());
        eo.setFormNo(reqDto.getFormNo());
        eo.setFormType(reqDto.getFormType());
        eo.setApplyUser(reqDto.getApplyUser());
        eo.setApplyDept(reqDto.getApplyDept());
        eo.setApplyDate(reqDto.getApplyDate());
        eo.setTitle(reqDto.getTitle());
        eo.setStatus(reqDto.getStatus());
        eo.setFormData(reqDto.getFormData());
        return eo;
    }

    private OaApplyFormRespDto convertToResponse(OaApplyFormEo eo) {
        if (eo == null) {
            return null;
        }
        OaApplyFormRespDto respDto = new OaApplyFormRespDto();
        respDto.setId(eo.getId());
        respDto.setFormNo(eo.getFormNo());
        respDto.setFormType(eo.getFormType());
        respDto.setApplyUser(eo.getApplyUser());
        respDto.setApplyDept(eo.getApplyDept());
        respDto.setApplyDate(eo.getApplyDate());
        respDto.setTitle(eo.getTitle());
        respDto.setStatus(eo.getStatus());
        respDto.setFormData(eo.getFormData());
        return respDto;
    }
}

