/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferDispatcherStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdTypeOfDocumentEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailResponseDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderBatchDetailRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsTransferOrderDetailServiceImpl
implements ICsTransferOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(CsTransferOrderDetailServiceImpl.class);
    @Resource
    CsTransferOrderDetailDas csTransferOrderDetailDas;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;

    @Override
    public Long addCsTransferOrderDetail(CsTransferOrderDetailReqDto addReqDto) {
        CsTransferOrderDetailEo csTransferOrderDetailEo = new CsTransferOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csTransferOrderDetailEo);
        this.csTransferOrderDetailDas.insert((BaseEo)csTransferOrderDetailEo);
        return csTransferOrderDetailEo.getId();
    }

    @Override
    public void modifyCsTransferOrderDetail(CsTransferOrderDetailReqDto modifyReqDto) {
        CsTransferOrderDetailEo csTransferOrderDetailEo = new CsTransferOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csTransferOrderDetailEo);
        this.csTransferOrderDetailDas.updateSelective((BaseEo)csTransferOrderDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsTransferOrderDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csTransferOrderDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsTransferOrderDetailRespDto queryById(Long id) {
        CsTransferOrderDetailEo csTransferOrderDetailEo = (CsTransferOrderDetailEo)this.csTransferOrderDetailDas.selectByPrimaryKey(id);
        CsTransferOrderDetailRespDto csTransferOrderDetailRespDto = new CsTransferOrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)csTransferOrderDetailEo, (BaseVo)csTransferOrderDetailRespDto);
        return csTransferOrderDetailRespDto;
    }

    @Override
    public PageInfo<CsTransferOrderDetailRespDto> queryByPage(String transferOrderNo, Integer pageNum, Integer pageSize) {
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)this.csTransferOrderDetailDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).select(new String[0]).page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsTransferOrderDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CsTransferOrderDetailRespDto> queryListByTransferOrderNo(String transferOrderNo) {
        ArrayList<CsTransferOrderDetailRespDto> dtoList = new ArrayList<CsTransferOrderDetailRespDto>();
        List list = ((ExtQueryChainWrapper)this.csTransferOrderDetailDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            DtoHelper.eoList2DtoList((Collection)list, dtoList, CsTransferOrderDetailRespDto.class);
        }
        return dtoList;
    }

    @Override
    public PageInfo<CsTransferOrderDetailResponseDto> queryDetailListByTransferOrderNo(String transferOrderNo, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List transferOrderDetailEoList = this.csTransferOrderDetailDas.queryGroupByTransferOrderNo(transferOrderNo);
        PageInfo dtoPageInfo = new PageInfo();
        Map<Object, Object> dtoMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)transferOrderDetailEoList)) {
            dtoMap = transferOrderDetailEoList.stream().collect(Collectors.toMap(o -> o.getLongCode() + "_" + o.getBatch(), Function.identity(), (o, o1) -> o));
            Map<String, List<InOutResultOrderDetailEo>> map = this.queryInOutResult(transferOrderNo);
            if (CollectionUtil.isNotEmpty(map)) {
                List<InOutResultOrderDetailEo> in;
                List<InOutResultOrderDetailEo> out = map.get("out");
                if (CollectionUtil.isNotEmpty(out)) {
                    Map<String, Double> outFinishMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                    Map<Object, Object> outFinishPreOrderItemIdMap = new HashMap();
                    if (null != out.get(0).getPreOrderItemId()) {
                        outFinishPreOrderItemIdMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                    }
                    Map<String, List<InOutResultOrderDetailEo>> batchMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
                    Map<Object, Object> batchPreOrderItemIdMap = new HashMap();
                    if (null != out.get(0).getPreOrderItemId()) {
                        batchPreOrderItemIdMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
                    }
                    for (CsTransferOrderDetailResponseDto transfer : transferOrderDetailEoList) {
                        Double outTotal = Objects.nonNull(outFinishPreOrderItemIdMap.get(transfer.getId())) ? (Double)outFinishPreOrderItemIdMap.get(transfer.getId()) : outFinishMap.get(transfer.getLongCode());
                        transfer.setDoneDeliveryQuantity(outTotal == null ? BigDecimal.ZERO : new BigDecimal(outTotal));
                        List<InOutResultOrderDetailEo> outBatch = Objects.nonNull(batchPreOrderItemIdMap.get(transfer.getId())) ? (List<InOutResultOrderDetailEo>)batchPreOrderItemIdMap.get(transfer.getId()) : batchMap.get(transfer.getLongCode());
                        if (!CollectionUtil.isNotEmpty(outBatch)) continue;
                        ArrayList<TransferOrderBatchDetailRespDto> batchList = new ArrayList<TransferOrderBatchDetailRespDto>();
                        for (InOutResultOrderDetailEo batch : outBatch) {
                            TransferOrderBatchDetailRespDto t = new TransferOrderBatchDetailRespDto();
                            String key = String.format("%s_%s", batch.getSkuCode(), batch.getBatch());
                            t.setBatch(batch.getBatch());
                            t.setDoneDeliveryQuantity(batch.getQuantity() == null ? BigDecimal.ZERO : batch.getQuantity());
                            t.setDoneReceiveQuantity(BigDecimal.ZERO);
                            t.setOutResultNo(batch.getDocumentNo());
                            t.setInResultNo("-");
                            t.setJumpDocumentName("\u53d1\u8d27\u7ed3\u679c\u5355");
                            if (dtoMap.containsKey(key)) {
                                CsTransferOrderDetailResponseDto dto = (CsTransferOrderDetailResponseDto)dtoMap.get(key);
                                t.setExpireTime(dto.getExpireTime());
                                t.setProduceTime(dto.getProduceTime());
                            }
                            batchList.add(t);
                        }
                        transfer.setBatchList(batchList);
                    }
                }
                if (CollectionUtil.isNotEmpty(in = map.get("in"))) {
                    Map<String, Double> inFinishMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode, Collectors.summingDouble(c -> CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(c.getDispatcherStatus()) ? c.getQuantity().add(Optional.ofNullable(c.getDispatcherQuantity()).orElse(BigDecimal.ZERO)).doubleValue() : c.getQuantity().doubleValue())));
                    Map<Object, Object> inFinishPreOrderItemIdMap = new HashMap();
                    if (null != in.get(0).getPreOrderItemId()) {
                        inFinishPreOrderItemIdMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                    }
                    Map<String, List<InOutResultOrderDetailEo>> batchMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
                    Map<Object, Object> batchPreOrderItemIdMap = new HashMap();
                    if (null != in.get(0).getPreOrderItemId()) {
                        batchPreOrderItemIdMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
                    }
                    Iterator iterator = transferOrderDetailEoList.iterator();
                    while (iterator.hasNext()) {
                        CsTransferOrderDetailResponseDto transfer;
                        Double inTotal = (Double)DataExtractUtils.ifNullElse((Object)inFinishMap.get((transfer = (CsTransferOrderDetailResponseDto)iterator.next()).getLongCode()), (Object)inFinishPreOrderItemIdMap.get(transfer.getId()));
                        transfer.setDoneReceiveQuantity(inTotal == null ? BigDecimal.ZERO : new BigDecimal(inTotal));
                        List<InOutResultOrderDetailEo> inBatch = Objects.nonNull(batchPreOrderItemIdMap.get(transfer.getId())) ? (List<InOutResultOrderDetailEo>)batchPreOrderItemIdMap.get(transfer.getId()) : batchMap.get(transfer.getLongCode());
                        if (!CollectionUtil.isNotEmpty(inBatch)) continue;
                        List batchList = transfer.getBatchList();
                        for (InOutResultOrderDetailEo batch : inBatch) {
                            TransferOrderBatchDetailRespDto t = new TransferOrderBatchDetailRespDto();
                            String key = String.format("%s_%s", batch.getSkuCode(), batch.getBatch());
                            t.setBatch(batch.getBatch());
                            t.setDoneReceiveQuantity(batch.getQuantity() == null ? BigDecimal.ZERO : batch.getQuantity());
                            t.setDoneDeliveryQuantity(BigDecimal.ZERO);
                            t.setInResultNo(batch.getDocumentNo());
                            if (CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(batch.getDispatcherStatus())) {
                                t.setDoneReceiveQuantity(t.getDoneReceiveQuantity().add(Optional.ofNullable(batch.getDispatcherQuantity()).orElse(BigDecimal.ZERO)));
                            }
                            if (dtoMap.containsKey(key)) {
                                CsTransferOrderDetailResponseDto dto = (CsTransferOrderDetailResponseDto)dtoMap.get(key);
                                t.setExpireTime(dto.getExpireTime());
                                t.setProduceTime(dto.getProduceTime());
                            }
                            t.setOutResultNo("-");
                            t.setJumpDocumentName("\u6536\u8d27\u7ed3\u679c\u5355");
                            batchList.add(t);
                        }
                    }
                }
            }
        }
        dtoPageInfo.setList(transferOrderDetailEoList);
        return dtoPageInfo;
    }

    @Override
    public List<CsTransferOrderDetailResponseDto> queryDetailListByTransferOrderNo(String transferOrderNo) {
        List transferOrderDetailEoList = this.csTransferOrderDetailDas.queryByTransferOrderNo(transferOrderNo);
        ArrayList<CsTransferOrderDetailResponseDto> dtoList = new ArrayList<CsTransferOrderDetailResponseDto>();
        DtoHelper.eoList2DtoList((Collection)transferOrderDetailEoList, dtoList, CsTransferOrderDetailResponseDto.class);
        return dtoList;
    }

    @Override
    public Map<String, List<InOutResultOrderDetailEo>> queryInOutResult(String transferOrderNo) {
        Set in;
        HashMap<String, List<InOutResultOrderDetailEo>> map = new HashMap<String, List<InOutResultOrderDetailEo>>(2);
        List resultList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).ne((Object)"business_type", (Object)BdTypeOfDocumentEnum.DISPATCHER_ORDER.getCode())).list();
        Map longCodeMap = resultList.stream().collect(Collectors.groupingBy(InOutResultOrderEo::getOrderType, Collectors.mapping(InOutResultOrderEo::getDocumentNo, Collectors.toSet())));
        Set out = longCodeMap.get("out");
        if (CollectionUtil.isNotEmpty(out)) {
            List outList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", out)).list();
            map.put("out", outList);
        }
        if (CollectionUtil.isNotEmpty(in = longCodeMap.get("in"))) {
            List inList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", in)).list();
            map.put("in", inList);
        }
        return map;
    }

    @Override
    public Map<String, List<ReceiveDeliveryResultOrderDetailEo>> queryDeliveryResult(String transferOrderNo) {
        Set in;
        HashMap<String, List<ReceiveDeliveryResultOrderDetailEo>> map = new HashMap<String, List<ReceiveDeliveryResultOrderDetailEo>>(2);
        List resultList = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).list();
        Map longCodeMap = resultList.stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderEo::getOrderType, Collectors.mapping(ReceiveDeliveryResultOrderEo::getDocumentNo, Collectors.toSet())));
        Set out = longCodeMap.get("delivery");
        if (CollectionUtil.isNotEmpty(out)) {
            List outList = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().in((Object)"document_no", out)).list();
            map.put("delivery", outList);
        }
        if (CollectionUtil.isNotEmpty(in = longCodeMap.get("receive"))) {
            List inList = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().in((Object)"document_no", in)).list();
            map.put("receive", inList);
        }
        return map;
    }

    @Override
    public void modifyCsTransferOrderDetailExtension(List<CsTransferOrderDetailReqDto> reqDtoList) {
        log.info("\u8ffd\u52a0\u8c03\u62e8\u5355\u660e\u7ec6\u660e\u7ec6\u6269\u5c55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        reqDtoList.forEach(dto -> {
            if (StringUtils.isBlank((CharSequence)dto.getExtension()) || ObjectUtil.isEmpty((Object)dto.getId())) {
                return;
            }
            CsTransferOrderDetailEo csTransferOrderDetailEo = (CsTransferOrderDetailEo)this.csTransferOrderDetailDas.selectByPrimaryKey(dto.getId());
            if (ObjectUtil.isNotEmpty((Object)csTransferOrderDetailEo)) {
                if (StringUtils.isBlank((CharSequence)csTransferOrderDetailEo.getExtension())) {
                    csTransferOrderDetailEo.setExtension(dto.getExtension());
                } else {
                    Map extension = (Map)JSONObject.parseObject((String)csTransferOrderDetailEo.getExtension(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                    Map map = (Map)JSONObject.parseObject((String)dto.getExtension(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                    extension.putAll(map);
                    csTransferOrderDetailEo.setExtension(JSON.toJSONString((Object)map));
                }
                log.info("\u66f4\u65b0\u6269\u5c55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)csTransferOrderDetailEo));
                this.csTransferOrderDetailDas.updateSelective((BaseEo)csTransferOrderDetailEo);
            }
        });
    }
}

