/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsInventoryTakeStockOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsOtherStorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsInventoryTakeStockOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsOtherStorageOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsExternalNumberTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderRelOrderInfoRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="csBaseOrderQueryService")
public class CsBaseOrderQueryServiceImpl
implements ICsBaseOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsBaseOrderQueryServiceImpl.class);
    @Resource
    private CsInPlannedOrderMapper csInPlannedOrderMapper;
    @Resource
    private CsInventoryTakeStockOrderMapper csInventoryTakeStockOrderMapper;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private CsOtherStorageOrderMapper csOtherStorageOrderMapper;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private CsOutPlannedOrderMapper csOutPlannedOrderMapper;
    @Resource
    private CsTransferOrderMapper csTransferOrderMapper;

    @Override
    public CsBasisOrderBusinessDataRespDto queryBusinessOrderByOrderNo(CsBasisOrderBusinessDataReqDto dataReqDto) {
        CsBasisOrderRelOrderInfoRespDto inResultOrderInfoDto;
        QueryWrapper queryWrapper;
        CsBasisOrderBusinessDataRespDto dataRespDto = new CsBasisOrderBusinessDataRespDto();
        if (Objects.isNull(dataReqDto)) {
            return dataRespDto;
        }
        String orderNo = dataReqDto.getOrderNo();
        String relevanceTableName = dataReqDto.getRelevanceTableName();
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return dataRespDto;
        }
        ContactDto contactDto = new ContactDto();
        ArrayList<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList = new ArrayList<CsBasisOrderRelOrderInfoRespDto>();
        String remark = null;
        Date estimatedTime = null;
        Date createTime = DateUtil.getDate((long)867686400L);
        if (StringUtils.isNotBlank((CharSequence)dataReqDto.getExternalOrderNo())) {
            logger.info("\u5916\u90e8\u5355\u636e\u53f7\u4e0d\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u5230\u5173\u8054\u5355\u636e\u4e2d");
            CsBasisOrderRelOrderInfoRespDto inResultOrderInfoDto2 = new CsBasisOrderRelOrderInfoRespDto();
            inResultOrderInfoDto2.setId(Long.valueOf(2L));
            inResultOrderInfoDto2.setOrderNo(dataReqDto.getExternalOrderNo());
            CsExternalNumberTypeEnum externalNumberTypeEnum = CsExternalNumberTypeEnum.getByBusinessType((String)dataReqDto.getBusinessType());
            inResultOrderInfoDto2.setOrderType(Objects.nonNull(externalNumberTypeEnum) ? externalNumberTypeEnum.getCode() : null);
            inResultOrderInfoDto2.setCreateTime(createTime);
            relOrderInfoList.add(inResultOrderInfoDto2);
        }
        CsRelevanceTableNameEnum csRelevanceTableNameEnum = CsRelevanceTableNameEnum.getStatusByCode((String)relevanceTableName);
        if (StringUtils.isBlank((CharSequence)relevanceTableName) || Objects.isNull(csRelevanceTableNameEnum) || !csRelevanceTableNameEnum.getRealTableExists().booleanValue()) {
            logger.info("\u5173\u8054\u5355\u636e\u4e0d\u5728\u5e93\u5b58\u4e2d\u5fc3\u4fdd\u5b58");
            CsBasisOrderRelOrderInfoRespDto inResultOrderInfoDto3 = new CsBasisOrderRelOrderInfoRespDto();
            inResultOrderInfoDto3.setId(Long.valueOf(3L));
            inResultOrderInfoDto3.setOrderNo(orderNo);
            inResultOrderInfoDto3.setOrderType(dataReqDto.getBusinessType());
            inResultOrderInfoDto3.setCreateTime(createTime);
            this.setShippingMsg(dataReqDto.getShippingJson(), inResultOrderInfoDto3);
            relOrderInfoList.add(inResultOrderInfoDto3);
        }
        if (CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(relevanceTableName)) {
            logger.info("\u67e5\u8be2\u8ba1\u5212\u7c7b\uff08\u751f\u4ea7\u3001\u59d4\u5916\u3001\u91c7\u8d2d\uff09\u6b63\u5411\u5165\u5e93\u5355\u636e\u4fe1\u606f");
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
            queryWrapper.eq((Object)"dr", (Object)0);
            List csInPlannedOrderEos = this.csInPlannedOrderMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)csInPlannedOrderEos)) {
                CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)csInPlannedOrderEos.get(0);
                if (StringUtils.isNotBlank((CharSequence)csInPlannedOrderEo.getPlatformOrderNo()) && !csInPlannedOrderEo.getPlatformOrderNo().equals(dataReqDto.getExternalOrderNo())) {
                    CsBasisOrderRelOrderInfoRespDto platformOrderInfo = new CsBasisOrderRelOrderInfoRespDto();
                    platformOrderInfo.setId(Long.valueOf(1L));
                    platformOrderInfo.setOrderNo(csInPlannedOrderEo.getPlatformOrderNo());
                    CsExternalNumberTypeEnum externalNumberTypeEnum = CsExternalNumberTypeEnum.getByBusinessType((String)csInPlannedOrderEo.getBusinessType());
                    platformOrderInfo.setOrderType(Objects.nonNull(externalNumberTypeEnum) ? externalNumberTypeEnum.getCode() : null);
                    platformOrderInfo.setCreateTime(csInPlannedOrderEo.getCreateTime());
                    relOrderInfoList.add(platformOrderInfo);
                }
                inResultOrderInfoDto = new CsBasisOrderRelOrderInfoRespDto();
                inResultOrderInfoDto.setId(csInPlannedOrderEo.getId());
                inResultOrderInfoDto.setOrderNo(csInPlannedOrderEo.getOrderNo());
                inResultOrderInfoDto.setOrderType(csInPlannedOrderEo.getOrderType());
                inResultOrderInfoDto.setOrderStatus(csInPlannedOrderEo.getOrderStatus());
                inResultOrderInfoDto.setCreateTime(csInPlannedOrderEo.getCreateTime());
                relOrderInfoList.add(inResultOrderInfoDto);
                remark = csInPlannedOrderEo.getRemark();
                estimatedTime = csInPlannedOrderEo.getEstimatedTime();
            }
        }
        if (CsRelevanceTableNameEnum.CS_INVENTORY_TAKE_STOCK_ORDER.getCode().equals(relevanceTableName)) {
            logger.info("\u67e5\u8be2\u76d8\u70b9\u5355\u4fe1\u606f");
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
            queryWrapper.eq((Object)"dr", (Object)0);
            List csInventoryTakeStockOrderEos = this.csInventoryTakeStockOrderMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)csInventoryTakeStockOrderEos)) {
                CsInventoryTakeStockOrderEo csInventoryTakeStockOrderEo = (CsInventoryTakeStockOrderEo)csInventoryTakeStockOrderEos.get(0);
                inResultOrderInfoDto = new CsBasisOrderRelOrderInfoRespDto();
                inResultOrderInfoDto.setId(csInventoryTakeStockOrderEo.getId());
                inResultOrderInfoDto.setOrderNo(csInventoryTakeStockOrderEo.getOrderNo());
                inResultOrderInfoDto.setOrderType(CsPcpBusinessTypeEnum.CHECK_STOCK.getCode());
                inResultOrderInfoDto.setOrderStatus(csInventoryTakeStockOrderEo.getOrderStatus());
                inResultOrderInfoDto.setCreateTime(csInventoryTakeStockOrderEo.getCreateTime());
                relOrderInfoList.add(inResultOrderInfoDto);
                remark = csInventoryTakeStockOrderEo.getRemark();
            }
        }
        if (CsRelevanceTableNameEnum.CS_OTHER_STORAGE_ORDER.getCode().equals(relevanceTableName)) {
            logger.info("\u67e5\u8be2\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u4fe1\u606f");
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"storage_order_no", (Object)orderNo);
            queryWrapper.eq((Object)"dr", (Object)0);
            List otherStorageOrderEos = this.csOtherStorageOrderMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)otherStorageOrderEos)) {
                CsOtherStorageOrderEo otherStorageOrderEo = (CsOtherStorageOrderEo)otherStorageOrderEos.get(0);
                inResultOrderInfoDto = new CsBasisOrderRelOrderInfoRespDto();
                inResultOrderInfoDto.setId(otherStorageOrderEo.getId());
                inResultOrderInfoDto.setOrderNo(orderNo);
                inResultOrderInfoDto.setOrderType(CsOtherStorageOrderEnum.InOrOut.IN.getCode().equals(otherStorageOrderEo.getType()) ? CsPcpBusinessTypeEnum.OTHER_IN.getCode() : CsPcpBusinessTypeEnum.OTHER_OUT.getCode());
                inResultOrderInfoDto.setOrderStatus(otherStorageOrderEo.getOrderStatus());
                inResultOrderInfoDto.setCreateTime(otherStorageOrderEo.getCreateTime());
                relOrderInfoList.add(inResultOrderInfoDto);
                remark = otherStorageOrderEo.getRemark();
            }
        }
        if (CsRelevanceTableNameEnum.CS_OUT_PLANNED_ORDER.getCode().equals(relevanceTableName)) {
            logger.info("\u67e5\u8be2\u8ba1\u5212\u7c7b\uff08\u59d4\u5916\u3001\u91c7\u8d2d\uff09\u9006\u5411\u51fa\u5e93\u5355\u636e\u4fe1\u606f");
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
            queryWrapper.eq((Object)"dr", (Object)0);
            List outPlannedOrderEos = this.csOutPlannedOrderMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)outPlannedOrderEos)) {
                CsOutPlannedOrderEo outPlannedOrderEo = (CsOutPlannedOrderEo)outPlannedOrderEos.get(0);
                inResultOrderInfoDto = new CsBasisOrderRelOrderInfoRespDto();
                inResultOrderInfoDto.setId(outPlannedOrderEo.getId());
                inResultOrderInfoDto.setOrderNo(orderNo);
                inResultOrderInfoDto.setOrderType(outPlannedOrderEo.getBusinessType());
                inResultOrderInfoDto.setOrderStatus(outPlannedOrderEo.getOrderStatus());
                inResultOrderInfoDto.setCreateTime(outPlannedOrderEo.getCreateTime());
                relOrderInfoList.add(inResultOrderInfoDto);
                remark = outPlannedOrderEo.getRemark();
            }
        }
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(relevanceTableName) || CsRelevanceTableNameEnum.CS_ADJUSTMENT_ORDER.getCode().equals(relevanceTableName)) {
            logger.info("\u67e5\u8be2\u8c03\u62e8\u5355\u5355\u636e\u4fe1\u606f");
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"transfer_order_no", (Object)orderNo);
            queryWrapper.eq((Object)"dr", (Object)0);
            List transferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)transferOrderEos)) {
                CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)transferOrderEos.get(0);
                inResultOrderInfoDto = new CsBasisOrderRelOrderInfoRespDto();
                inResultOrderInfoDto.setId(transferOrderEo.getId());
                inResultOrderInfoDto.setOrderNo(orderNo);
                inResultOrderInfoDto.setOrderType(transferOrderEo.getType());
                inResultOrderInfoDto.setOrderStatus(transferOrderEo.getOrderStatus());
                inResultOrderInfoDto.setCreateTime(transferOrderEo.getCreateTime());
                relOrderInfoList.add(inResultOrderInfoDto);
                remark = transferOrderEo.getRemark();
                String address = StringUtils.joinWith((String)"", (Object[])new Object[]{transferOrderEo.getProvince(), transferOrderEo.getCity(), transferOrderEo.getArea(), transferOrderEo.getAddress()});
                contactDto.setAddress(address);
                contactDto.setReciveName(transferOrderEo.getContact());
                contactDto.setRecivePhone(transferOrderEo.getContactPhone());
            }
        }
        contactDto.setRemark(remark);
        dataRespDto.setContactDto(contactDto);
        dataRespDto.setRemark(dataReqDto.getRemark());
        dataRespDto.setEstimatedTime(estimatedTime);
        dataRespDto.setRelOrderInfoList(relOrderInfoList);
        return dataRespDto;
    }

    @Override
    public CsBasisOrderBusinessDataRespDto deliveryReceiveNoticeBuildRelOrderInfo(CsBasisOrderBusinessDataReqDto dto, String deliveryReceiveOrderType, String outInOrderType) {
        return this.getCsBasisOrderBusinessDataRespDto(dto, deliveryReceiveOrderType, outInOrderType);
    }

    private List<InOutResultOrderEo> getCsOutInNoticeResultOrderEos(CsBasisOrderBusinessDataReqDto dto, String outInOrderType, List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        QueryWrapper outNoticeOrderQueryWrapper = new QueryWrapper();
        outNoticeOrderQueryWrapper.eq((Object)"relevance_no", (Object)dto.getRelevanceNo());
        outNoticeOrderQueryWrapper.eq((Object)"dr", (Object)0);
        List InOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)outNoticeOrderQueryWrapper);
        List<Object> csOutResultOrderList = new ArrayList<InOutResultOrderEo>();
        if (CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEos)) {
            HashSet<String> outNoticeOrderNos = new HashSet<String>(InOutNoticeOrderEos.size());
            for (InOutNoticeOrderEo InOutNoticeOrderEo2 : InOutNoticeOrderEos) {
                if (dto.getDocumentNo().equals(InOutNoticeOrderEo2.getDocumentNo())) continue;
                CsBasisOrderRelOrderInfoRespDto basisOrderRelOrderOutfoRespDto = new CsBasisOrderRelOrderInfoRespDto();
                basisOrderRelOrderOutfoRespDto.setId(InOutNoticeOrderEo2.getId());
                basisOrderRelOrderOutfoRespDto.setOrderNo(InOutNoticeOrderEo2.getDocumentNo());
                basisOrderRelOrderOutfoRespDto.setOrderType("out".equals(InOutNoticeOrderEo2.getOrderType()) ? CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode() : CsDocumentTypeEnum.IN_NOTICE_ORDER.getCode());
                basisOrderRelOrderOutfoRespDto.setOrderStatus(InOutNoticeOrderEo2.getOrderStatus());
                basisOrderRelOrderOutfoRespDto.setCreateTime(InOutNoticeOrderEo2.getCreateTime());
                basisOrderRelOrderOutfoRespDto.setWmsOrderNo(InOutNoticeOrderEo2.getWmsOrderNo());
                this.setShippingMsg(InOutNoticeOrderEo2.getShippingJson(), basisOrderRelOrderOutfoRespDto);
                relOrderInfoList.add(basisOrderRelOrderOutfoRespDto);
                outNoticeOrderNos.add(InOutNoticeOrderEo2.getDocumentNo());
            }
            QueryWrapper outResultOrderQueryWrapper = new QueryWrapper();
            outResultOrderQueryWrapper.eq((Object)"relevance_no", (Object)dto.getRelevanceNo());
            outResultOrderQueryWrapper.eq((Object)"dr", (Object)0);
            csOutResultOrderList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)outResultOrderQueryWrapper);
            HashSet<String> inResultDocumentNos = new HashSet<String>();
            if (CollectionUtils.isNotEmpty(csOutResultOrderList)) {
                for (InOutResultOrderEo inOutResultOrderEo : csOutResultOrderList) {
                    if (dto.getDocumentNo().equals(inOutResultOrderEo.getDocumentNo())) continue;
                    CsBasisOrderRelOrderInfoRespDto outResultOrderInfoDto = new CsBasisOrderRelOrderInfoRespDto();
                    outResultOrderInfoDto.setId(inOutResultOrderEo.getId());
                    outResultOrderInfoDto.setOrderNo(inOutResultOrderEo.getDocumentNo());
                    outResultOrderInfoDto.setOrderType("out".equals(inOutResultOrderEo.getOrderType()) ? CsDocumentTypeEnum.OUT_RESULT_ORDER.getCode() : CsDocumentTypeEnum.IN_RESULT_ORDER.getCode());
                    outResultOrderInfoDto.setOrderStatus(inOutResultOrderEo.getOrderStatus());
                    outResultOrderInfoDto.setShippingCode(inOutResultOrderEo.getShippingCode());
                    outResultOrderInfoDto.setShippingCompany(inOutResultOrderEo.getShippingCompany());
                    outResultOrderInfoDto.setEstimatedTime(inOutResultOrderEo.getEstimatedTime());
                    outResultOrderInfoDto.setShippingType(inOutResultOrderEo.getShippingType());
                    outResultOrderInfoDto.setWmsOrderNo(inOutResultOrderEo.getWmsOrderNo());
                    this.setShippingMsg(inOutResultOrderEo.getShippingJson(), outResultOrderInfoDto);
                    outResultOrderInfoDto.setCreateTime(inOutResultOrderEo.getCreateTime());
                    relOrderInfoList.add(outResultOrderInfoDto);
                    inResultDocumentNos.add(inOutResultOrderEo.getDocumentNo());
                }
            }
        }
        return csOutResultOrderList;
    }

    private void setShippingMsg(String shippingJson, CsBasisOrderRelOrderInfoRespDto basisOrderRelOrderOutfoRespDto) {
        if (StringUtils.isNotEmpty((CharSequence)shippingJson)) {
            try {
                List shippingInfoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                if (CollectionUtils.isNotEmpty((Collection)shippingInfoList)) {
                    CsWmsShippingInfoReqDto shippingInfo = (CsWmsShippingInfoReqDto)shippingInfoList.get(0);
                    basisOrderRelOrderOutfoRespDto.setShippingCompany(shippingInfo.getShippingCompanyName());
                    basisOrderRelOrderOutfoRespDto.setShippingCode(this.getShippingCodes(shippingInfoList));
                    basisOrderRelOrderOutfoRespDto.setShippingType(shippingInfo.getLogisticsType());
                }
            }
            catch (Exception e) {
                logger.error("\u8bbe\u7f6e\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private String getShippingCodes(List<CsWmsShippingInfoReqDto> shippingInfoList) {
        StringBuilder shippingCodes = new StringBuilder();
        for (CsWmsShippingInfoReqDto csWmsShippingInfoReqDto : shippingInfoList) {
            shippingCodes.append(csWmsShippingInfoReqDto.getShippingNo()).append(",");
        }
        return shippingCodes.substring(0, shippingCodes.length() - 1);
    }

    private void deliveryReceiveResultList(CsBasisOrderBusinessDataReqDto dto, String deliveryReceiveOrderType, List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        QueryWrapper receiveResultOrderQueryWrapper = new QueryWrapper();
        receiveResultOrderQueryWrapper.eq((Object)"relevance_no", (Object)dto.getRelevanceNo());
        receiveResultOrderQueryWrapper.eq((Object)"dr", (Object)0);
        List csDeliveryResultOrderList = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)receiveResultOrderQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)csDeliveryResultOrderList)) {
            for (ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo : csDeliveryResultOrderList) {
                if (dto.getDocumentNo().equals(csDeliveryResultOrderEo.getDocumentNo())) continue;
                CsBasisOrderRelOrderInfoRespDto inResultOrderOutfoDto = new CsBasisOrderRelOrderInfoRespDto();
                inResultOrderOutfoDto.setId(csDeliveryResultOrderEo.getId());
                inResultOrderOutfoDto.setOrderNo(csDeliveryResultOrderEo.getDocumentNo());
                inResultOrderOutfoDto.setOrderType("delivery".equals(csDeliveryResultOrderEo.getOrderType()) ? CsDocumentTypeEnum.DELIVERY_RESULT_ORDER.getCode() : CsDocumentTypeEnum.RECEIVE_RESULT_ORDER.getCode());
                inResultOrderOutfoDto.setOrderStatus(csDeliveryResultOrderEo.getOrderStatus());
                inResultOrderOutfoDto.setShippingType(csDeliveryResultOrderEo.getShippingType());
                inResultOrderOutfoDto.setShippingCompany(csDeliveryResultOrderEo.getShippingCompany());
                inResultOrderOutfoDto.setShippingCode(csDeliveryResultOrderEo.getShippingCode());
                inResultOrderOutfoDto.setWmsOrderNo(csDeliveryResultOrderEo.getWmsOrderNo());
                inResultOrderOutfoDto.setCreateTime(csDeliveryResultOrderEo.getCreateTime());
                this.setShippingMsg(csDeliveryResultOrderEo.getShippingJson(), inResultOrderOutfoDto);
                relOrderInfoList.add(inResultOrderOutfoDto);
            }
        }
    }

    @Override
    public CsBasisOrderBusinessDataRespDto deliveryReceiveResultBuildRelOrderInfo(CsBasisOrderBusinessDataReqDto dto, String deliveryReceiveOrderType, String outInOrderType) {
        return this.getCsBasisOrderBusinessDataRespDto(dto, deliveryReceiveOrderType, outInOrderType);
    }

    @NotNull
    private CsBasisOrderBusinessDataRespDto getCsBasisOrderBusinessDataRespDto(CsBasisOrderBusinessDataReqDto dto, String deliveryReceiveOrderType, String outInOrderType) {
        List<Object> relOrderInfoList = new ArrayList<CsBasisOrderRelOrderInfoRespDto>();
        this.deliveryReceiveNoticeList(dto, deliveryReceiveOrderType, relOrderInfoList);
        this.getCsOutInNoticeResultOrderEos(dto, outInOrderType, relOrderInfoList);
        this.deliveryReceiveResultList(dto, deliveryReceiveOrderType, relOrderInfoList);
        relOrderInfoList.stream().filter(re -> (re.getOrderType().equals(CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode()) || re.getOrderType().equals(CsDocumentTypeEnum.IN_NOTICE_ORDER.getCode())) && StringUtils.isNotBlank((CharSequence)re.getShippingCompany())).findFirst().map(order -> {
            CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
            csWmsShippingInfoReqDto.setWmsOrderNo(order.getWmsOrderNo());
            csWmsShippingInfoReqDto.setShippingCompanyName(order.getShippingCompany());
            csWmsShippingInfoReqDto.setShippingNo(order.getShippingCode());
            csWmsShippingInfoReqDto.setLogisticsType(order.getShippingType());
            return JSONObject.toJSONString((Object)Lists.newArrayList((Object[])new CsWmsShippingInfoReqDto[]{csWmsShippingInfoReqDto}));
        }).ifPresent(dto::setShippingJson);
        CsBasisOrderBusinessDataRespDto basisOrderBusinessDataRespDto = this.getCsBasisOrderBusinessDataRespDto(dto);
        Optional.ofNullable(basisOrderBusinessDataRespDto.getRelOrderInfoList()).ifPresent(relOrderInfoList::addAll);
        if (CollectionUtils.isNotEmpty(relOrderInfoList)) {
            relOrderInfoList = relOrderInfoList.stream().sorted(Comparator.comparing(BaseRespDto::getCreateTime)).collect(Collectors.toList());
        }
        basisOrderBusinessDataRespDto.setRelOrderInfoList(relOrderInfoList);
        return basisOrderBusinessDataRespDto;
    }

    @Override
    public CsBasisOrderBusinessDataRespDto outInNoticeBuildRelOrderInfo(CsBasisOrderBusinessDataReqDto dto, String deliveryReceiveOrderType, String outInOrderType) {
        return this.getCsBasisOrderBusinessDataRespDto(dto, deliveryReceiveOrderType, outInOrderType);
    }

    private CsBasisOrderBusinessDataRespDto getCsBasisOrderBusinessDataRespDto(CsBasisOrderBusinessDataReqDto dto) {
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto(dto.getRelevanceNo(), dto.getRelevanceTableName(), dto.getBusinessType(), dto.getExternalOrderNo());
        dataReqDto.setShippingJson(dto.getShippingJson());
        return this.queryBusinessOrderByOrderNo(dataReqDto);
    }

    private void deliveryReceiveNoticeList(CsBasisOrderBusinessDataReqDto dto, String deliveryReceiveOrderType, List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        QueryWrapper deliveryNoticeOrderQueryWrapper = new QueryWrapper();
        deliveryNoticeOrderQueryWrapper.eq((Object)"relevance_no", (Object)dto.getRelevanceNo());
        deliveryNoticeOrderQueryWrapper.eq((Object)"dr", (Object)0);
        List csDeliveryNoticeOrderList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)deliveryNoticeOrderQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderList)) {
            for (ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo : csDeliveryNoticeOrderList) {
                if (dto.getDocumentNo().equals(receiveDeliveryNoticeOrderEo.getDocumentNo())) continue;
                CsBasisOrderRelOrderInfoRespDto outResultOrderInfoDto = new CsBasisOrderRelOrderInfoRespDto();
                outResultOrderInfoDto.setId(receiveDeliveryNoticeOrderEo.getId());
                outResultOrderInfoDto.setOrderNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
                outResultOrderInfoDto.setOrderType("delivery".equals(receiveDeliveryNoticeOrderEo.getOrderType()) ? CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode() : CsDocumentTypeEnum.RECEIVE_NOTICE_ORDER.getCode());
                outResultOrderInfoDto.setOrderStatus(receiveDeliveryNoticeOrderEo.getOrderStatus());
                outResultOrderInfoDto.setCreateTime(receiveDeliveryNoticeOrderEo.getCreateTime());
                outResultOrderInfoDto.setShippingCode(receiveDeliveryNoticeOrderEo.getShippingCode());
                outResultOrderInfoDto.setShippingCompany(receiveDeliveryNoticeOrderEo.getShippingCompany());
                outResultOrderInfoDto.setWmsOrderNo(receiveDeliveryNoticeOrderEo.getWmsOrderNo());
                this.setShippingMsg(receiveDeliveryNoticeOrderEo.getShippingJson(), outResultOrderInfoDto);
                relOrderInfoList.add(outResultOrderInfoDto);
            }
        }
    }

    @Override
    public CsBasisOrderBusinessDataRespDto outInResultBuildRelOrderInfo(CsBasisOrderBusinessDataReqDto dto, String deliveryReceiveOrderType, String outInOrderType) {
        return this.getCsBasisOrderBusinessDataRespDto(dto, deliveryReceiveOrderType, outInOrderType);
    }

    @Override
    public BigDecimal queryItemMapByDeliveryReceiveNoticeDocumentNo(String documentNo) {
        if (StringUtils.isBlank((CharSequence)documentNo)) {
            return null;
        }
        List itemList = this.receiveDeliveryNoticeOrderDetailDomain.queryMapByDocumentNo(documentNo);
        logger.info("\u6839\u636e\u5355\u53f7\u67e5\u8be2\u4ea7\u54c1\u6c47\u603b\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)itemList));
        return CollectionUtils.isEmpty((Collection)itemList) ? null : new BigDecimal(itemList.size());
    }

    @Override
    public BigDecimal queryItemMapByDeliveryReceiveResultDocumentNo(String documentNo) {
        if (StringUtils.isBlank((CharSequence)documentNo)) {
            return null;
        }
        List itemList = this.receiveDeliveryResultOrderDetailDomain.queryMapByDocumentNo(documentNo);
        logger.info("\u6839\u636e\u5355\u53f7\u67e5\u8be2\u4ea7\u54c1\u6c47\u603b\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)itemList));
        return CollectionUtils.isEmpty((Collection)itemList) ? null : new BigDecimal(itemList.size());
    }

    @Override
    public BigDecimal queryItemMapByOutInNoticeDocumentNo(String documentNo) {
        if (StringUtils.isBlank((CharSequence)documentNo)) {
            return null;
        }
        List itemList = this.inOutNoticeOrderDetailDomain.queryMapByDocumentNo(documentNo);
        logger.info("\u6839\u636e\u5355\u53f7\u67e5\u8be2\u4ea7\u54c1\u6c47\u603b\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)itemList));
        return CollectionUtils.isEmpty((Collection)itemList) ? null : new BigDecimal(itemList.size());
    }

    @Override
    public BigDecimal queryItemMapByOutInResultDocumentNo(String documentNo) {
        if (StringUtils.isBlank((CharSequence)documentNo)) {
            return null;
        }
        List itemList = this.inOutResultOrderDetailDomain.queryMapByDocumentNo(documentNo);
        logger.info("\u6839\u636e\u5355\u53f7\u67e5\u8be2\u4ea7\u54c1\u6c47\u603b\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)itemList));
        return CollectionUtils.isEmpty((Collection)itemList) ? null : new BigDecimal(itemList.size());
    }
}

