/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.impl;

import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.AbstractGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentCodePrefixEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="CsTakeStockOrderServiceImpl")
public class CsTakeStockOrderGenerateCodeServiceImpl
extends AbstractGenerateCodeService {
    Logger logger = LoggerFactory.getLogger(CsTakeStockOrderGenerateCodeServiceImpl.class);

    @Override
    public String getGenerateCodeStrategy() {
        return CsGenerateCodeStrategyEnum.TAKE_STOCK_ORDER.getCode();
    }

    @Override
    protected String lockKey() {
        String dateStr = DateUtils.formatDate(new Date(), "yyMMdd");
        String lockKey = this.getCodePrefix() + "_" + dateStr;
        this.logger.info("CsTakeStockOrderGenerateCodeServiceImpl==>lockKey:{}", (Object)lockKey);
        return lockKey;
    }

    @Override
    protected String getCodePrefix() {
        return CsDocumentCodePrefixEnum.TS.getCode();
    }

    @Override
    protected Long queryMaxCode() {
        return 0L;
    }

    @Override
    public String getCode() {
        return super.generateCode(CsDocumentCodePrefixEnum.TS.getCode(), this.lockKey());
    }
}

