/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsLockOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.scheduler.task.NearOverdueUnlockTask;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.ICsLockOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.ICsLockOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLockOrderRespDto;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class LockOrderApiImpl
implements ICsLockOrderApi {
    private static final Logger log = LoggerFactory.getLogger(LockOrderApiImpl.class);
    @Autowired
    protected ICsLockOrderService csLockOrderService;
    @Resource
    protected NearOverdueUnlockTask nearOverdueUnlockTask;
    @Autowired
    protected ICsLockOrderQueryService csLockOrderQueryService;

    public RestResponse<Void> updateLockInventory(String type, CsLockOrderUpdateReqDto updateReqDto) {
        log.info("\u6839\u636e\u7c7b\u578b\uff1a\u3010{}\u3011\u66f4\u65b0\u9501\u5b9a\u5e93\u5b58\u5165\u53c2\uff1a\u3010{}\u3011", (Object)type, (Object)LogUtils.buildLogContent(updateReqDto));
        this.csLockOrderService.updateLockInventory(type, updateReqDto, true);
        return RestResponse.VOID;
    }

    public RestResponse<Map<String, Integer>> batchUpdateLockInventory(String type, List<CsLockOrderUpdateReqDto> list) {
        log.info("\u6839\u636e\u7c7b\u578b\uff1a\u3010{}\u3011\u6279\u91cf\u66f4\u65b0\u9501\u5b9a\u5e93\u5b58\u5165\u53c2\uff1a\u3010{}\u3011", (Object)type, (Object)LogUtils.buildLogContent(list));
        this.csLockOrderService.batchUpdateLockInventory(type, list);
        return new RestResponse(new HashMap());
    }

    public RestResponse<Void> manualUnLockInventory() {
        this.nearOverdueUnlockTask.task();
        return RestResponse.VOID;
    }

    public RestResponse<PageInfo<CsLockOrderRespDto>> queryByPage(CsLockOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        AssertUtil.emptyValidated(queryDto, "pageNum", "pageSize");
        PageInfo<CsLockOrderRespDto> page = this.csLockOrderQueryService.queryByPage(queryDto);
        return new RestResponse(page);
    }
}

