/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveredOutResultInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsLogisticsDeliveredInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInfoQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CsOutResultOrderQueryApiImpl
implements ICsOutResultOrderQueryApi {
    private static final Logger log = LoggerFactory.getLogger(CsOutResultOrderQueryApiImpl.class);
    @Autowired
    protected ICsOutResultOrderQueryService csOutResultOrderQueryService;
    @Resource
    protected IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    protected IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    protected ICsRelWarehouseQueryService csRelWarehouseQueryService;

    public RestResponse<CsOutResultOrderRespDto> queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        InOutResultOrderEo eo = this.csOutResultOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsOutResultOrderRespDto dto = new CsOutResultOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
        queryDto.setWarehouseId(dto.getWarehouseId());
        queryDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        queryDto.setValidFlag(ValidFlagEnum.ENABLE.getCode());
        List<CsRelWarehouseRespDto> csRelWarehouseRespDtos = this.csRelWarehouseQueryService.queryWarehouseByConditions(queryDto);
        if (CollectionUtils.isNotEmpty(csRelWarehouseRespDtos)) {
            dto.setOutPhysicsWarehouseCode(dto.getWarehouseCode());
            dto.setOutPhysicsWarehouseName(dto.getWarehouseName());
            dto.setWarehouseCode(csRelWarehouseRespDtos.get(0).getRefWarehouseName());
            dto.setWarehouseName(csRelWarehouseRespDtos.get(0).getRefWarehouseCode());
        }
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        csDeliveryResultOrderEo.setRelevanceNo(dto.getDocumentNo());
        csDeliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)this.receiveDeliveryResultOrderDomain.selectOne((BaseEo)csDeliveryResultOrderEo);
        if (Objects.nonNull(csDeliveryResultOrderEo)) {
            dto.setDeliveryResultOrderNo(csDeliveryResultOrderEo.getDocumentNo());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)dto.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                log.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        return new RestResponse((Object)dto);
    }

    public RestResponse<CsOutResultOrderRespDto> queryByDocumentNo(String documentNo) {
        return new RestResponse((Object)this.csOutResultOrderQueryService.queryByDocumentNo(documentNo));
    }

    public RestResponse<PageInfo<CsOutResultOrderDetailRespDto>> queryDetailByPage(CsOutResultOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        return new RestResponse(this.csOutResultOrderQueryService.queryDetailByPage(queryDto));
    }

    public RestResponse<PageInfo<CsOutResultOrderRespDto>> queryByPage(CsOutResultOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        return new RestResponse(null);
    }

    public RestResponse<List<CsOutResultOrderRespDto>> queryByParam(CsOutResultOrderQueryDto queryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        return new RestResponse(this.csOutResultOrderQueryService.queryByParam(queryDto));
    }

    public RestResponse<CsDeliveredOutResultInfoRespDto> queryDeliveredInfo(String preOrderNo) {
        CsDeliveredOutResultInfoRespDto resultInfoRespDto = this.csOutResultOrderQueryService.queryDeliveredInfo(preOrderNo);
        return new RestResponse((Object)resultInfoRespDto);
    }

    public RestResponse<CsLogisticsDeliveredInfoRespDto> queryInfoByExternalOrderNo(CsInfoQueryDto infoQueryDto) {
        return new RestResponse((Object)this.csOutResultOrderQueryService.queryInfoByExternalOrderNo(infoQueryDto));
    }

    public RestResponse<String> queryOverChargeReason(String documentNo) {
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(inOutResultOrderEo, "\u7ed3\u679c\u5355\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        return new RestResponse((Object)inOutResultOrderEo.getOverChargeReason());
    }

    public RestResponse<List<CsOutResultOrderDetailRespDto>> queryDetailByRelevanceNo(String relevanceNo) {
        return new RestResponse(this.csOutResultOrderQueryService.queryDetailByRelevanceNo(relevanceNo));
    }

    public RestResponse<List<CsOutResultOrderDetailRespDto>> queryDetailByDocumentNo(String documentNo) {
        return new RestResponse(this.csOutResultOrderQueryService.queryDetailByDocumentNo(documentNo));
    }
}

