/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.CsBasicsOrderStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.ICsBasicsOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IAdjustmentInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.AdjustmentInventoryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.AdjustmentInventoryDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.AdjustmentInventoryDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.AdjustmentInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.AdjustmentInventoryAuditMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.AdjustmentInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryAuditRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.adjustmentInventoryStatusCountRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdjustmentInventoryServiceImpl
implements IAdjustmentInventoryService {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentInventoryServiceImpl.class);
    @Resource
    private AdjustmentInventoryDas adjustmentInventoryDas;
    @Resource
    private AdjustmentInventoryDetailDas adjustmentInventoryDetailDas;
    @Resource
    private CsTransferOrderDas csTransferOrderDas;
    @Resource
    private IContext context;
    @Resource
    private AdjustmentInventoryMapper adjustmentInventoryMapper;
    @Resource
    private AdjustmentInventoryAuditMapper adjustmentInventoryAuditMapper;

    @Override
    public Long addAdjustmentInventory(AdjustmentInventoryReqDto addReqDto) {
        AdjustmentInventoryEo adjustmentInventoryEo = new AdjustmentInventoryEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)adjustmentInventoryEo, (String[])new String[]{"id"});
        adjustmentInventoryEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        adjustmentInventoryEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        adjustmentInventoryEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        adjustmentInventoryEo.setCreateTime(new Date());
        adjustmentInventoryEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        adjustmentInventoryEo.setUpdateTime(new Date());
        this.adjustmentInventoryDas.insert((BaseEo)adjustmentInventoryEo);
        return adjustmentInventoryEo.getId();
    }

    @Override
    public void modifyAdjustmentInventory(AdjustmentInventoryReqDto modifyReqDto) {
        AdjustmentInventoryEo adjustmentInventoryEo = new AdjustmentInventoryEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)adjustmentInventoryEo);
        this.adjustmentInventoryDas.updateSelective((BaseEo)adjustmentInventoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAdjustmentInventory(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.adjustmentInventoryDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AdjustmentInventoryRespDto queryById(Long id) {
        AdjustmentInventoryEo adjustmentInventoryEo = (AdjustmentInventoryEo)this.adjustmentInventoryDas.selectByPrimaryKey(id);
        AdjustmentInventoryRespDto adjustmentInventoryRespDto = new AdjustmentInventoryRespDto();
        DtoHelper.eo2Dto((BaseEo)adjustmentInventoryEo, (BaseVo)adjustmentInventoryRespDto);
        AdjustmentInventoryDetailEo adjustmentInventoryDetailEo = new AdjustmentInventoryDetailEo();
        adjustmentInventoryDetailEo.setAdjustmentNo(adjustmentInventoryRespDto.getAdjustmentNo());
        List adjustmentInventoryDetailEoList = this.adjustmentInventoryDetailDas.select((BaseEo)adjustmentInventoryDetailEo);
        ArrayList adjustmentInventoryDetailRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)adjustmentInventoryDetailEoList, adjustmentInventoryDetailRespDtoList, AdjustmentInventoryDetailRespDto.class);
        adjustmentInventoryRespDto.setDetailRespDtoList(adjustmentInventoryDetailRespDtoList);
        return adjustmentInventoryRespDto;
    }

    @Override
    public PageInfo<AdjustmentInventoryRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        QueryWrapper<AdjustmentInventoryEo> wrapper = this.getAdjustmentInventoryEoQueryWrapper(filter);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eoList = this.adjustmentInventoryDas.list(wrapper);
        List relevanceNos = eoList.stream().map(AdjustmentInventoryEo::getRelevanceNo).collect(Collectors.toList());
        ExtQueryChainWrapper filter1 = this.csTransferOrderDas.filter();
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty(relevanceNos)) {
            list = ((ExtQueryChainWrapper)filter1.in((Object)"transfer_order_no", relevanceNos)).list();
        }
        Map<String, CsTransferOrderEo> map = list.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, e -> e, (a1, a2) -> a2));
        PageInfo eoPageInfo = new PageInfo(eoList);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AdjustmentInventoryRespDto.class);
        dtoList.forEach(e -> {
            CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)map.get(e.getRelevanceNo());
            if (null != csTransferOrderEo) {
                e.setInLogicWarehouseName(csTransferOrderEo.getInLogicWarehouseName());
                e.setOutLogicWarehouseName(csTransferOrderEo.getOutLogicWarehouseName());
                e.setTotalQuantity(csTransferOrderEo.getTotalQuantity());
            }
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public adjustmentInventoryStatusCountRespDto adjustmentInventoryStatusCount(String filter) {
        adjustmentInventoryStatusCountRespDto dto = new adjustmentInventoryStatusCountRespDto();
        QueryWrapper<AdjustmentInventoryEo> wrapper = this.getAdjustmentInventoryEoQueryWrapper(filter);
        QueryWrapper<AdjustmentInventoryEo> wrapper1 = this.getAdjustmentInventoryEoQueryWrapper(filter);
        QueryWrapper<AdjustmentInventoryEo> wrapper2 = this.getAdjustmentInventoryEoQueryWrapper(filter);
        QueryWrapper<AdjustmentInventoryEo> wrapper3 = this.getAdjustmentInventoryEoQueryWrapper(filter);
        dto.setTotal(Integer.valueOf(this.adjustmentInventoryDas.count(wrapper)));
        dto.setCompleted(Integer.valueOf(this.adjustmentInventoryDas.count((Wrapper)wrapper.eq((Object)"adjustment_status", (Object)"completed"))));
        dto.setWaitAudit(Integer.valueOf(this.adjustmentInventoryDas.count((Wrapper)wrapper1.eq((Object)"adjustment_status", (Object)"wait_audit"))));
        dto.setCancel(Integer.valueOf(this.adjustmentInventoryDas.count((Wrapper)wrapper2.eq((Object)"adjustment_status", (Object)"cancel"))));
        dto.setAuditFailed(Integer.valueOf(this.adjustmentInventoryDas.count((Wrapper)wrapper3.eq((Object)"adjustment_status", (Object)"audit_failed"))));
        return dto;
    }

    private QueryWrapper<AdjustmentInventoryEo> getAdjustmentInventoryEoQueryWrapper(String filter) {
        List<String> strings;
        AdjustmentInventoryReqDto adjustmentInventoryReqDto = (AdjustmentInventoryReqDto)JSON.parseObject((String)filter, AdjustmentInventoryReqDto.class);
        QueryWrapper wrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)adjustmentInventoryReqDto) && StringUtils.isNotEmpty((CharSequence)adjustmentInventoryReqDto.getAdjustmentNo()) && (strings = Arrays.asList(adjustmentInventoryReqDto.getAdjustmentNo().replace("\uff0c", ",").split(","))).size() > 1) {
            adjustmentInventoryReqDto.setAdjustmentNoList(strings);
            adjustmentInventoryReqDto.setAdjustmentNo(null);
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getAdjustmentNo())) {
            wrapper.like((Object)"adjustment_no", (Object)adjustmentInventoryReqDto.getAdjustmentNo());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getExternalOrderNo())) {
            wrapper.like((Object)"external_order_no", (Object)adjustmentInventoryReqDto.getExternalOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)adjustmentInventoryReqDto.getAdjustmentNoList())) {
            wrapper.in((Object)"adjustment_no", (Collection)adjustmentInventoryReqDto.getAdjustmentNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)adjustmentInventoryReqDto.getWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)adjustmentInventoryReqDto.getWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getAdjustmentStatus())) {
            wrapper.eq((Object)"adjustment_status", (Object)adjustmentInventoryReqDto.getAdjustmentStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getAdjustmentType())) {
            wrapper.eq((Object)"adjustment_type", (Object)adjustmentInventoryReqDto.getAdjustmentType());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getBusinessType())) {
            wrapper.eq((Object)"business_type", (Object)adjustmentInventoryReqDto.getBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getPreOrderNo())) {
            wrapper.eq((Object)"pre_order_no", (Object)adjustmentInventoryReqDto.getPreOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getRelevanceNo())) {
            wrapper.eq((Object)"relevance_no", (Object)adjustmentInventoryReqDto.getRelevanceNo());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getWarehouseClassify())) {
            wrapper.eq((Object)"warehouse_classify", (Object)adjustmentInventoryReqDto.getWarehouseClassify());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentInventoryReqDto.getSourceType())) {
            wrapper.eq((Object)"source_type", (Object)adjustmentInventoryReqDto.getSourceType());
        }
        if (CollectionUtils.isNotEmpty((Collection)adjustmentInventoryReqDto.getSourceTypeList())) {
            wrapper.in((Object)"source_type", (Collection)adjustmentInventoryReqDto.getSourceTypeList());
        }
        if (null != adjustmentInventoryReqDto.getStartTime()) {
            wrapper.gt((Object)"create_time", (Object)adjustmentInventoryReqDto.getStartTime());
        }
        if (null != adjustmentInventoryReqDto.getEndTime()) {
            wrapper.lt((Object)"create_time", (Object)adjustmentInventoryReqDto.getEndTime());
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"create_time");
        return wrapper;
    }

    @Override
    public AdjustmentInventoryRespDto queryByAdjustmentNo(String adjustmentNo) {
        log.info("\u6839\u636e\u5e93\u5b58\u8c03\u6574\u5355\u53f7\u67e5\u8be2\u8be6\u60c5\uff1a{}", (Object)adjustmentNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)adjustmentNo), "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AdjustmentInventoryRespDto respDto = new AdjustmentInventoryRespDto();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"adjustment_no", (Object)adjustmentNo);
        queryWrapper.eq((Object)"dr", (Object)0);
        List eos = this.adjustmentInventoryMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return respDto;
        }
        CubeBeanUtils.copyProperties((Object)respDto, eos.get(0), (String[])new String[0]);
        String relevanceNo = ((AdjustmentInventoryEo)eos.get(0)).getPreOrderNo();
        ICsBasicsOrderQueryService basicsOrderQueryService = CsBasicsOrderStrategyUtils.getBasicsOrderQueryService("inOutNoticeOrder");
        List<Object> basicsOrderRespDtoList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)relevanceNo)) {
            basicsOrderRespDtoList = basicsOrderQueryService.queryAllByRelevanceNo(relevanceNo);
        }
        if (CollectionUtils.isEmpty((Collection)basicsOrderRespDtoList)) {
            basicsOrderRespDtoList = basicsOrderQueryService.queryAllByRelevanceNo(adjustmentNo);
        }
        respDto.setRelOrderInfoList((List)basicsOrderRespDtoList);
        log.info("\u8c03\u6574\u5355\u660e\u7ec6\u67e5\u8be2");
        AdjustmentInventoryDetailEo detailEoParam = new AdjustmentInventoryDetailEo();
        detailEoParam.setAdjustmentNo(((AdjustmentInventoryEo)eos.get(0)).getAdjustmentNo());
        detailEoParam.setAdjustmentId(((AdjustmentInventoryEo)eos.get(0)).getId());
        List select = this.adjustmentInventoryDetailDas.select((BaseEo)detailEoParam);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            ArrayList detailRespDtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)select, detailRespDtoList, AdjustmentInventoryDetailRespDto.class);
            respDto.setDetailRespDtoList(detailRespDtoList);
        }
        QueryWrapper auditQueryWrapper = new QueryWrapper();
        auditQueryWrapper.eq((Object)"adjustment_no", (Object)adjustmentNo);
        auditQueryWrapper.eq((Object)"dr", (Object)0);
        auditQueryWrapper.orderByDesc((Object)"create_time");
        List adjustmentInventoryAuditEos = this.adjustmentInventoryAuditMapper.selectList((Wrapper)auditQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)adjustmentInventoryAuditEos)) {
            ArrayList auditRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(auditRespDtos, (Collection)adjustmentInventoryAuditEos, AdjustmentInventoryAuditRespDto.class);
            respDto.setAuditList(auditRespDtos);
        }
        return respDto;
    }
}

