/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.api.annotion.Power;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.AbstractCsInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.InventoryItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.InventorySubItemRespDto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component(value="CslogicinventoryStrategyQueryService")
public class CsLogicInventoryQueryServiceImpl
extends AbstractCsInventoryQueryService {
    private Logger logger = LoggerFactory.getLogger(CsLogicInventoryQueryServiceImpl.class);
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    private CsCommonService csCommonService;
    @Autowired
    ILogicInventoryTotalDomain logicInventoryTotalDomain;

    @Override
    public String getStrategy() {
        return CsInventoryStrategyEnum.LOGIC.getCode();
    }

    @Override
    public List<CsInventoryBasicsQueryRespDto> queryCommonInventory(CsInventoryBasicsQueryReqDto query) {
        this.logger.info("queryCommonInventory==>logic,\u57fa\u7840\u5e93\u5b58\u67e5\u8be2,query:{}", (Object)LogUtils.buildLogContent(query));
        List<Object> resultList = Lists.newArrayList();
        if (!this.checkQueryCommonParams(query).booleanValue()) {
            return Lists.newArrayList();
        }
        Boolean totalQueryFlag = query.getTotalQueryFlag();
        if (Boolean.TRUE.equals(totalQueryFlag)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            this.buildQueryCommonWrapper(query, queryWrapper);
            List csLogicInventoryTotalEoList = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)queryWrapper);
            resultList = csLogicInventoryTotalEoList.stream().map(e -> {
                CsInventoryBasicsQueryRespDto respDto = new CsInventoryBasicsQueryRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
                respDto.setLongCode(e.getSkuCode());
                respDto.setCargoCode(e.getSkuCode());
                respDto.setCargoName(e.getSkuName());
                return respDto;
            }).collect(Collectors.toList());
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            this.buildQueryCommonWrapper(query, queryWrapper);
            List csLogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)queryWrapper);
            resultList = csLogicInventoryEoList.stream().map(e -> {
                CsInventoryBasicsQueryRespDto respDto = new CsInventoryBasicsQueryRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
                respDto.setLongCode(e.getSkuCode());
                respDto.setCargoCode(e.getSkuCode());
                respDto.setCargoName(e.getSkuName());
                return respDto;
            }).collect(Collectors.toList());
        }
        return resultList;
    }

    @Override
    @Power
    public PageInfo<CsInventoryBasicsPageQueryRespDto> queryInventoryPage(CsInventoryBasicsPageQueryReqDto queryParamDto) {
        this.logger.info("queryInventoryPage===>\u903b\u8f91\u4ed3\u5e93\u5b58,\u5e93\u5b58\u5206\u9875\u67e5\u8be2,queryParamDto:{}", (Object)LogUtils.buildLogContent(queryParamDto));
        this.checkParams((BasePageDto)queryParamDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.buildInventoryPageQueryDto(queryParamDto, queryWrapper).booleanValue()) {
            return new PageInfo();
        }
        if (CollectionUtils.isNotEmpty((Collection)queryParamDto.getCurrentUserWarehouseIds())) {
            queryWrapper.in((Object)"warehouse_id", (Collection)queryParamDto.getCurrentUserWarehouseIds());
        }
        queryWrapper.and(wq -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wq.gt((Object)"balance", (Object)0)).or()).gt((Object)"available", (Object)0)).or()).gt((Object)"preempt", (Object)0);
        });
        PageHelper.startPage((int)queryParamDto.getPageNum(), (int)queryParamDto.getPageSize());
        this.logger.info("queryInventoryPage===>\u903b\u8f91\u4ed3\u5e93\u5b58,\u6784\u5efa\u540e\u7684\u67e5\u8be2\u53c2\u6570,queryWrapper:{}", (Object)LogUtils.buildLogContent(queryWrapper));
        List resultList = this.logicInventoryDomain.getMapper().selectList((Wrapper)queryWrapper);
        this.logger.info("queryInventoryPage===>\u903b\u8f91\u4ed3\u5e93\u5b58,\u67e5\u8be2\u7ed3\u679c\u96c6\u5408,resultList:{}", (Object)LogUtils.buildLogContent(resultList));
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new PageInfo();
        }
        List<String> cargoCodes = resultList.stream().map(c -> c.getCargoCode()).distinct().collect(Collectors.toList());
        List<String> batchs = resultList.stream().map(c -> c.getBatch()).distinct().collect(Collectors.toList());
        Map<String, InventoryItemExtendRespDto> inventoryItemExtendMap = this.getInventoryItemExtendMap(cargoCodes, batchs);
        List<String> giftCargoCodes = resultList.stream().filter(c -> YesNoEnum.YES.getValue().equals(c.getIsGift())).map(c -> c.getCargoCode()).distinct().collect(Collectors.toList());
        List<String> giftBatchs = resultList.stream().filter(c -> YesNoEnum.YES.getValue().equals(c.getIsGift())).map(c -> c.getBatch()).distinct().collect(Collectors.toList());
        Map<String, List<InventorySubItemRespDto>> inventorySubItemMap = Optional.of(this.getInventorySubItem(giftCargoCodes, giftBatchs)).orElse(Maps.newHashMap());
        List respDtoList = resultList.stream().map(e -> {
            CsInventoryBasicsPageQueryRespDto csInventoryBasicsPageQueryRespDto = new CsInventoryBasicsPageQueryRespDto();
            CubeBeanUtils.copyProperties((Object)csInventoryBasicsPageQueryRespDto, (Object)e, (String[])new String[0]);
            csInventoryBasicsPageQueryRespDto.setLongCode(e.getSkuCode());
            csInventoryBasicsPageQueryRespDto.setCargoCode(e.getSkuCode());
            csInventoryBasicsPageQueryRespDto.setCargoName(e.getSkuName());
            if (!ObjectUtils.isEmpty((Object)inventoryItemExtendMap)) {
                List inventorySubItemRespDtoList;
                InventoryItemExtendRespDto inventoryItemExtendRespDto = inventoryItemExtendMap.getOrDefault(e.getCargoCode() + e.getBatch(), null);
                if (!ObjectUtils.isEmpty((Object)inventoryItemExtendRespDto)) {
                    csInventoryBasicsPageQueryRespDto.setExpireTime(inventoryItemExtendRespDto.getExpireTime());
                    csInventoryBasicsPageQueryRespDto.setProduceTime(inventoryItemExtendRespDto.getProduceTime());
                }
                if (CollectionUtils.isNotEmpty((Collection)(inventorySubItemRespDtoList = (List)inventorySubItemMap.getOrDefault(e.getCargoCode() + e.getBatch(), null)))) {
                    csInventoryBasicsPageQueryRespDto.setSubItemList(inventorySubItemRespDtoList);
                }
            }
            return csInventoryBasicsPageQueryRespDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(resultList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(respDtoList);
        return result;
    }
}

