/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.CloudInventoryDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ITcbjInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjBaseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjCargoOccupyMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderCargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjNotiDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TcbjBaseServiceImpl
implements ITcbjBaseService {
    private static final Logger logger = LoggerFactory.getLogger(TcbjBaseServiceImpl.class);
    @Autowired
    private TcbjCargoOccupyMapper tcbjCargoOccupyMapper;
    @Autowired
    private TcbjDRAOrderMapper tcbjDRAOrderMapper;
    @Autowired
    private TcbjDRAOrderCargoMapper tcbjDRAOrderCargoMapper;
    @Autowired
    private ICsTransferOrderService transferOrderService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private ITcbjInventoryService tcbjInventoryService;
    @Resource
    private IContext context;
    @Autowired
    private ICacheService cacheService;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(DRAOrderEo draOrderEo, List<DRAOrderCargoEo> draOrderCargoEos, int action, DRAOrderEo notiEo) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(DRAOrderEo draOrderEo) {
    }

    @Override
    public void checkRepeat(DRAOrderEo draOrderEo) {
        boolean lockFlag = this.cacheService.setIfAbsent("DRA_ORDER_LOCK_KEY_" + draOrderEo.getPreNo() + "_" + draOrderEo.getType() + "_" + draOrderEo.getCategory(), (Object)true, 60);
        if (!lockFlag) {
            throw new BizException("301", "\u5355\u636e\u7c7b\u578b\u548c\u5355\u636e\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u91cd\u8bd5");
        }
        QueryWrapper eoQueryWrapper = new QueryWrapper();
        eoQueryWrapper.eq((Object)"pre_no", (Object)draOrderEo.getPreNo());
        eoQueryWrapper.eq((Object)"type", (Object)draOrderEo.getType());
        eoQueryWrapper.eq((Object)"category", (Object)draOrderEo.getCategory());
        List draOrderEos = this.tcbjDRAOrderMapper.selectList((Wrapper)eoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)draOrderEos)) {
            throw new BizException("304", "\u76f8\u540c\u7c7b\u578b\u7684\u5355\u636e\u53f7\u5df2\u88ab\u5360\u7528\uff0c\u7981\u6b62\u91cd\u590d\u63d0\u4ea4");
        }
    }

    @Override
    public List<TcbjResDetailCargoRespDto> getResCargo(String orderNo) {
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"order_no", (Object)orderNo);
        List cargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)qwrapper);
        List<TcbjResDetailCargoRespDto> collect = cargoEos.stream().map(c -> {
            TcbjResDetailCargoRespDto tmp = new TcbjResDetailCargoRespDto();
            tmp.setCargoCode(c.getCargoCode());
            tmp.setCargoName(c.getCargoName());
            tmp.setCargoNo(c.getCargoNo());
            tmp.setNum(c.getNum());
            tmp.setBatch(c.getBatch());
            tmp.setTradeOrderItemId(c.getTradeOrderItemId());
            return tmp;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<TcbjNotiDetailCargoRespDto> getNotiCargo(String orderNo) {
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"order_no", (Object)orderNo);
        List cargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)qwrapper);
        List<TcbjNotiDetailCargoRespDto> collect = cargoEos.stream().map(c -> {
            TcbjNotiDetailCargoRespDto tmp = new TcbjNotiDetailCargoRespDto();
            tmp.setNum(c.getNum());
            tmp.setCargoCode(c.getCargoCode());
            tmp.setCargoName(c.getCargoName());
            tmp.setCargoNo(c.getCargoNo());
            tmp.setCancelNum(c.getCancelNum());
            tmp.setPlanNum(c.getPlanNum());
            tmp.setSentNum(c.getSentNum());
            tmp.setWaitNum(c.getWaitNum());
            tmp.setBatch(c.getBatch());
            return tmp;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<TcbjNotiDetailCargoRespDto> getNotifyCargoListByOrderNoList(List<String> orderNoList) {
        logger.info("getNotifyCargoListByOrderNoList==>orderNoList:{}", (Object)LogUtils.buildLogContent(orderNoList));
        if (CollectionUtils.isEmpty(orderNoList)) {
            return new ArrayList<TcbjNotiDetailCargoRespDto>();
        }
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.in((Object)"order_no", orderNoList);
        List cargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)qwrapper);
        List<TcbjNotiDetailCargoRespDto> respList = cargoEos.stream().map(c -> {
            TcbjNotiDetailCargoRespDto tmp = new TcbjNotiDetailCargoRespDto();
            tmp.setNum(c.getNum());
            tmp.setCargoCode(c.getCargoCode());
            tmp.setCargoName(c.getCargoName());
            tmp.setCargoNo(c.getCargoNo());
            tmp.setCancelNum(c.getCancelNum());
            tmp.setPlanNum(c.getPlanNum());
            tmp.setSentNum(c.getSentNum());
            tmp.setWaitNum(c.getWaitNum());
            tmp.setBatch(c.getBatch());
            return tmp;
        }).collect(Collectors.toList());
        return respList;
    }

    @Override
    public List<CloudInventoryDto> getInventory() {
        String urlString = "http://test-tcbjjxc.by-health.com/erp/api/inv/query/availableStock?access_token=270fe85e315f4fea83381bfffecdcf591914465b1df242239cea253557410685";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", "34cc4109705e4c058b7b3b0352e57d31");
        HashMap<String, String> materialList = new HashMap<String, String>();
        materialList.put("materialNo", "A.A.01.02.AA010208");
        map.put("materialList", Collections.singletonList(materialList));
        String post = HttpUtil.post((String)urlString, map);
        JSONObject jsonObject = JSON.parseObject((String)post);
        String string = jsonObject.getString("returnObject");
        List dtos = JSON.parseArray((String)string, CloudInventoryDto.class);
        return dtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void physicWarehouseAdjustInOut(DRAOrderEo draOrderEo, List<DRAOrderCargoEo> draOrderCargoEos, int action) {
    }
}

