/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.AbstractCsInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryBasicsOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsPhysicsInventoryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsPhysicsInventoryTotalDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsPhysicsInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsPhysicsInventoryTotalEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsPhysicsWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsPhysicsInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsPhysicsInventoryTotalMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsPhysicsWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPhysicsWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="CsphysicsinventoryStrategyService")
public class CsPhysicsInventoryServiceImpl
extends AbstractCsInventoryService {
    private Logger logger = LoggerFactory.getLogger(CsPhysicsInventoryServiceImpl.class);
    @Autowired
    private CsPhysicsInventoryMapper csPhysicsInventoryMapper;
    @Autowired
    private CsPhysicsInventoryTotalMapper csPhysicsInventoryTotalMapper;
    @Autowired
    private CsPhysicsWarehouseMapper csPhysicsWarehouseMapper;
    @Autowired
    private CsPhysicsInventoryDas csPhysicsInventoryDas;
    @Autowired
    private CsPhysicsInventoryTotalDas csPhysicsInventoryTotalDas;
    @Autowired
    private IContext context;
    @Autowired
    @Qualifier(value="CsphysicsinventoryStrategyService")
    private ICsInventoryBasicsOperateService physicsBasicsOperateService;

    @Override
    public String getStrategy() {
        return CsInventoryStrategyEnum.PHYSICS.getCode();
    }

    @Override
    protected String getInventoryLogTableName(CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        String batch = basicDetailDto.getBatch();
        Table tableAnnotation = null;
        tableAnnotation = StringUtils.isNotBlank((CharSequence)batch) ? CsPhysicsInventoryEo.class.getAnnotation(Table.class) : CsPhysicsInventoryTotalEo.class.getAnnotation(Table.class);
        return tableAnnotation.name();
    }

    @Override
    protected void sortList(CsInventoryInOutBasicsDto inParamDto) {
        String key;
        List inOutBasicsCargoDtoList = inParamDto.getInOutBasicsCargoDtoList();
        ArrayList batchDtoList = Lists.newArrayList();
        ArrayList unBatchDtoList = Lists.newArrayList();
        for (CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto : inOutBasicsCargoDtoList) {
            String batch = inOutBasicsCargoDto.getBatch();
            if (StringUtils.isBlank((CharSequence)batch)) {
                unBatchDtoList.add(inOutBasicsCargoDto);
                continue;
            }
            batchDtoList.add(inOutBasicsCargoDto);
        }
        Map<Object, Object> batchInventoryEoMap = Maps.newHashMap();
        Map<Object, Object> unBatchInventoryEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)batchDtoList)) {
            List batchList = batchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getBatch).collect(Collectors.toList());
            List warehouseCodeList = batchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getWarehouseCode).collect(Collectors.toList());
            List cargoCodeList = batchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getCargoCode).collect(Collectors.toList());
            QueryWrapper csPhysicsInventoryEoQueryWrapper = new QueryWrapper();
            csPhysicsInventoryEoQueryWrapper.in((Object)"batch", batchList);
            csPhysicsInventoryEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
            csPhysicsInventoryEoQueryWrapper.in((Object)"cargo_code", cargoCodeList);
            List batchCsPhysicsInventoryEoList = this.csPhysicsInventoryMapper.selectList((Wrapper)csPhysicsInventoryEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)batchCsPhysicsInventoryEoList)) {
                batchInventoryEoMap = batchCsPhysicsInventoryEoList.stream().collect(Collectors.toMap(eo -> eo.getWarehouseCode() + "_" + eo.getCargoCode() + "_" + eo.getBatch(), Function.identity()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)unBatchDtoList)) {
            List warehouseCodeList = unBatchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getWarehouseCode).collect(Collectors.toList());
            List cargoCodeList = unBatchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getCargoCode).collect(Collectors.toList());
            QueryWrapper csPhysicsInventoryTotalEoQueryWrapper = new QueryWrapper();
            csPhysicsInventoryTotalEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
            csPhysicsInventoryTotalEoQueryWrapper.in((Object)"cargo_code", cargoCodeList);
            List unBatchCsPhysicsInventoryEoList = this.csPhysicsInventoryTotalMapper.selectList((Wrapper)csPhysicsInventoryTotalEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)unBatchCsPhysicsInventoryEoList)) {
                unBatchInventoryEoMap = unBatchCsPhysicsInventoryEoList.stream().collect(Collectors.toMap(eo -> eo.getWarehouseCode() + "_" + eo.getCargoCode() + "_", Function.identity()));
            }
        }
        ArrayList sortOperateList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)batchDtoList)) {
            ArrayList sortBatchOperateList = Lists.newArrayList();
            ArrayList unSortBatchOperateList = Lists.newArrayList();
            for (CsInventoryInOutBasicsCargoDto batchDto : batchDtoList) {
                key = batchDto.getWarehouseCode() + "_" + batchDto.getCargoCode() + "_" + batchDto.getBatch();
                CsPhysicsInventoryEo inventoryEo = (CsPhysicsInventoryEo)batchInventoryEoMap.get(key);
                if (null == inventoryEo) {
                    unSortBatchOperateList.add(batchDto);
                    continue;
                }
                batchDto.setId(inventoryEo.getId());
                sortBatchOperateList.add(batchDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)sortBatchOperateList)) {
                Collections.sort(sortBatchOperateList, Comparator.comparing(CsInventoryInOutBasicsCargoDto::getId));
                sortOperateList.addAll(sortBatchOperateList);
            }
            if (CollectionUtils.isNotEmpty((Collection)unSortBatchOperateList)) {
                sortOperateList.addAll(unSortBatchOperateList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)unBatchDtoList)) {
            ArrayList sortUnBatchOperateList = Lists.newArrayList();
            ArrayList unSortUnBatchOperateList = Lists.newArrayList();
            for (CsInventoryInOutBasicsCargoDto unBatchDto : unBatchDtoList) {
                key = unBatchDto.getWarehouseCode() + "_" + unBatchDto.getCargoCode();
                CsPhysicsInventoryTotalEo csLogicInventoryTotalEo = (CsPhysicsInventoryTotalEo)unBatchInventoryEoMap.get(key);
                if (null == csLogicInventoryTotalEo) {
                    unSortUnBatchOperateList.add(unBatchDto);
                    continue;
                }
                unBatchDto.setId(csLogicInventoryTotalEo.getId());
                sortUnBatchOperateList.add(unBatchDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)sortUnBatchOperateList)) {
                Collections.sort(sortUnBatchOperateList, Comparator.comparing(CsInventoryInOutBasicsCargoDto::getId));
                sortOperateList.addAll(sortUnBatchOperateList);
            }
            if (CollectionUtils.isNotEmpty((Collection)unSortUnBatchOperateList)) {
                sortOperateList.addAll(unSortUnBatchOperateList);
            }
        }
        inParamDto.setInOutBasicsCargoDtoList((List)sortOperateList);
        this.logger.info("sortList==>\u7269\u7406\u5e93\u5b58\u6392\u5e8f\u5904\u7406\u540e,inParamDto:{}", (Object)LogUtils.buildLogContent(inParamDto));
    }

    @Override
    public Boolean existWarehouse(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto) {
        List inOutBasicDetailDtoList = csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList();
        List warehouseCodeList = inOutBasicDetailDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getWarehouseCode).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.eq((Object)"warehouse_status", (Object)CsPhysicsWarehouseStatusEnum.ENABLE.getCode());
        List csPhysicsWarehouseEoList = this.csPhysicsWarehouseMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csPhysicsWarehouseEoList), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        Map physicsWarehouseEoMap = csPhysicsWarehouseEoList.stream().collect(Collectors.toMap(CsPhysicsWarehouseEo::getWarehouseCode, Function.identity()));
        for (CsInventoryInOutBasicsCargoDto detailDto : inOutBasicDetailDtoList) {
            String warehouseCode = detailDto.getWarehouseCode();
            CsPhysicsWarehouseEo csPhysicsWarehouseEo = (CsPhysicsWarehouseEo)physicsWarehouseEoMap.get(warehouseCode);
            if (null == csPhysicsWarehouseEo) continue;
            detailDto.setWarehouseCode(csPhysicsWarehouseEo.getWarehouseCode());
            detailDto.setWarehouseId(csPhysicsWarehouseEo.getId());
            detailDto.setWarehouseType(csPhysicsWarehouseEo.getWarehouseType());
            detailDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
            detailDto.setWarehouseName(csPhysicsWarehouseEo.getWarehouseName());
        }
        return true;
    }

    @Override
    public Long existInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        if (StringUtils.isNotBlank((CharSequence)batch)) {
            return this.batchExistInventory(inDetailDto);
        }
        return this.totalExistInventory(inDetailDto);
    }

    private Long totalExistInventory(CsInventoryInOutBasicsCargoDto inDetailDto) {
        String warehouseCode = inDetailDto.getWarehouseCode();
        String cargoCode = inDetailDto.getCargoCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        queryWrapper.eq((Object)"cargo_code", (Object)cargoCode);
        queryWrapper.eq((Object)"dr", (Object)0);
        CsPhysicsInventoryTotalEo csPhysicsInventoryTotalEo = (CsPhysicsInventoryTotalEo)this.csPhysicsInventoryTotalMapper.selectOne((Wrapper)queryWrapper);
        if (null == csPhysicsInventoryTotalEo) {
            return null;
        }
        inDetailDto.setIsGift(csPhysicsInventoryTotalEo.getIsGift());
        return csPhysicsInventoryTotalEo.getId();
    }

    private Long batchExistInventory(CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        String warehouseCode = inDetailDto.getWarehouseCode();
        String cargoCode = inDetailDto.getCargoCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        queryWrapper.eq((Object)"cargo_code", (Object)cargoCode);
        queryWrapper.eq((Object)"batch", (Object)batch);
        queryWrapper.eq((Object)"dr", (Object)0);
        CsPhysicsInventoryEo csPhysicsInventoryEo = (CsPhysicsInventoryEo)this.csPhysicsInventoryMapper.selectOne((Wrapper)queryWrapper);
        if (null == csPhysicsInventoryEo) {
            return null;
        }
        inDetailDto.setIsGift(csPhysicsInventoryEo.getIsGift());
        return csPhysicsInventoryEo.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean doInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        Mutex mutex = null;
        try {
            mutex = this.lock(inParamDto, inDetailDto);
            Boolean bl = this.physicsBasicsOperateService.initInventory(inParamDto, inDetailDto);
            return bl;
        }
        finally {
            this.unLock(mutex);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean initInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        this.logger.info("physics,initInventory==>\u5373\u5c06\u6267\u884c\u521d\u59cb\u5316\u5e93\u5b58\u64cd\u4f5c,inParamDto:{},inDetailDto:{}", (Object)LogUtils.buildLogContent(inParamDto), (Object)LogUtils.buildLogContent(inDetailDto));
        if (null != this.existInventory(inParamDto, inDetailDto)) {
            return true;
        }
        return this.executeInitInventory(inParamDto, inDetailDto);
    }

    private Boolean executeInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        Boolean result = true;
        result = StringUtils.isNotBlank((CharSequence)batch) ? this.batchInitInventory(inParamDto, inDetailDto) : this.totalInitInventory(inParamDto, inDetailDto);
        if (!result.booleanValue()) {
            throw new BizException("\u521d\u59cb\u5316\u5e93\u5b58\u5f02\u5e38");
        }
        return result;
    }

    private Boolean totalInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        AssertUtil.isTrue(inDetailDto.getBalance().compareTo(BigDecimal.valueOf(0L)) >= 0, CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getCode(), CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getMsg());
        CsPhysicsInventoryTotalEo physicsInventoryTotalEo = new CsPhysicsInventoryTotalEo();
        CubeBeanUtils.copyProperties((Object)physicsInventoryTotalEo, (Object)inDetailDto, (String[])new String[0]);
        physicsInventoryTotalEo.setWarehouseId(inDetailDto.getWarehouseId());
        physicsInventoryTotalEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        physicsInventoryTotalEo.setCargoId(inDetailDto.getCargoId());
        physicsInventoryTotalEo.setCargoCode(inDetailDto.getCargoCode());
        physicsInventoryTotalEo.setIsGift(inDetailDto.getIsGift());
        physicsInventoryTotalEo.setAvailable(this.calculateInsertAvailableInventory(inParamDto, inDetailDto));
        physicsInventoryTotalEo.setUpdateTime(new Date());
        physicsInventoryTotalEo.setCreateTime(new Date());
        physicsInventoryTotalEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        physicsInventoryTotalEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        physicsInventoryTotalEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        physicsInventoryTotalEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        int result = this.csPhysicsInventoryTotalDas.insert((BaseEo)physicsInventoryTotalEo);
        return result > 0;
    }

    private Boolean batchInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        AssertUtil.isTrue(inDetailDto.getBalance().compareTo(BigDecimal.valueOf(0L)) >= 0, CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getCode(), CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getMsg());
        CsPhysicsInventoryEo batchEo = new CsPhysicsInventoryEo();
        CubeBeanUtils.copyProperties((Object)batchEo, (Object)inDetailDto, (String[])new String[0]);
        batchEo.setWarehouseId(inDetailDto.getWarehouseId());
        batchEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        batchEo.setCargoId(inDetailDto.getCargoId());
        batchEo.setCargoCode(inDetailDto.getCargoCode());
        batchEo.setBatch(inDetailDto.getBatch());
        batchEo.setIsGift(inDetailDto.getIsGift());
        batchEo.setAvailable(this.calculateInsertAvailableInventory(inParamDto, inDetailDto));
        batchEo.setUpdateTime(new Date());
        batchEo.setCreateTime(new Date());
        batchEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        batchEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        batchEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        batchEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        int result = this.csPhysicsInventoryDas.insert((BaseEo)batchEo);
        if (result <= 0) {
            return false;
        }
        Integer updateTotalFlag = inParamDto.getUpdateTotalFlag();
        if (null == updateTotalFlag || YesNoEnum.NO.getValue().equals(updateTotalFlag)) {
            return true;
        }
        CsInventoryInOutBasicsCargoDto tempDto = new CsInventoryInOutBasicsCargoDto();
        CubeBeanUtils.copyProperties((Object)tempDto, (Object)inDetailDto, (String[])new String[0]);
        Long totalId = this.totalExistInventory(tempDto);
        CsPhysicsInventoryTotalEo physicsInventoryTotalEo = new CsPhysicsInventoryTotalEo();
        CubeBeanUtils.copyProperties((Object)physicsInventoryTotalEo, (Object)tempDto, (String[])new String[0]);
        physicsInventoryTotalEo.setWarehouseId(inDetailDto.getWarehouseId());
        physicsInventoryTotalEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        physicsInventoryTotalEo.setCargoId(inDetailDto.getCargoId());
        physicsInventoryTotalEo.setCargoCode(inDetailDto.getCargoCode());
        String coverInventoryFlag = inParamDto.getCoverInventoryFlag();
        if (null == totalId) {
            this.csPhysicsInventoryTotalMapper.insert((Object)physicsInventoryTotalEo);
        } else {
            CsPhysicsInventoryEo csPhysicsInventoryEo;
            CsPhysicsInventoryTotalEo physicsInventoryTotalUpdateEo = new CsPhysicsInventoryTotalEo();
            physicsInventoryTotalUpdateEo.setUpdateTime(new Date());
            physicsInventoryTotalUpdateEo.setCreateTime(new Date());
            physicsInventoryTotalUpdateEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
            physicsInventoryTotalUpdateEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
            physicsInventoryTotalUpdateEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
            physicsInventoryTotalUpdateEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
            physicsInventoryTotalUpdateEo.setId(totalId);
            if (CsInventoryCoverInventoryFlagEnum.UPDATE.getCode().equals(coverInventoryFlag)) {
                physicsInventoryTotalUpdateEo.setBalance(batchEo.getBalance());
                physicsInventoryTotalUpdateEo.setAvailable(batchEo.getAvailable());
                this.csPhysicsInventoryTotalMapper.updateInventoryTotal(physicsInventoryTotalUpdateEo);
            } else if (CsInventoryCoverInventoryFlagEnum.COVER.getCode().equals(coverInventoryFlag) && null != (csPhysicsInventoryEo = this.csPhysicsInventoryMapper.sumCargoInventory(inDetailDto.getCargoCode(), inDetailDto.getWarehouseCode()))) {
                physicsInventoryTotalUpdateEo.setBalance(csPhysicsInventoryEo.getBalance());
                physicsInventoryTotalUpdateEo.setAvailable(csPhysicsInventoryEo.getAvailable());
                physicsInventoryTotalUpdateEo.setPreempt(csPhysicsInventoryEo.getPreempt());
                this.csPhysicsInventoryTotalMapper.updateById((BaseEo)physicsInventoryTotalUpdateEo);
            }
        }
        return result > 0;
    }

    @Override
    public boolean doUpdateInventory(Long inventoryId, CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        if (StringUtils.isNotBlank((CharSequence)batch)) {
            return this.batchUpdateInventory(inventoryId, inDetailDto, inParamDto);
        }
        return this.totalUpdateInventory(inventoryId, inParamDto, inDetailDto);
    }

    private boolean totalUpdateInventory(Long inventoryId, CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        CsPhysicsInventoryEo csPhysicsInventoryEo;
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u7269\u7406\u4ed3\u603b\u8868\u66f4\u65b0,inventoryId\uff1a{}", (Object)inventoryId);
        CsPhysicsInventoryTotalEo csPhysicsInventoryTotalEo = new CsPhysicsInventoryTotalEo();
        CubeBeanUtils.copyProperties((Object)csPhysicsInventoryTotalEo, (Object)inDetailDto, (String[])new String[0]);
        csPhysicsInventoryTotalEo.setWarehouseId(inDetailDto.getWarehouseId());
        csPhysicsInventoryTotalEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        csPhysicsInventoryTotalEo.setCargoId(inDetailDto.getCargoId());
        csPhysicsInventoryTotalEo.setCargoCode(inDetailDto.getCargoCode());
        csPhysicsInventoryTotalEo.setIsGift(inDetailDto.getIsGift());
        csPhysicsInventoryTotalEo.setId(inventoryId);
        csPhysicsInventoryTotalEo.setUpdateTime(new Date());
        csPhysicsInventoryTotalEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        csPhysicsInventoryTotalEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        csPhysicsInventoryTotalEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csPhysicsInventoryTotalEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csPhysicsInventoryTotalEo.setNegativeValidate(inParamDto.getNegativeValidate());
        String coverInventoryFlag = inParamDto.getCoverInventoryFlag();
        int result = 0;
        if (CsInventoryCoverInventoryFlagEnum.UPDATE.getCode().equals(coverInventoryFlag)) {
            this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u7269\u7406\u4ed3\u603b\u8868\u66f4\u65b0,balance\uff1a{}", (Object)csPhysicsInventoryTotalEo.getBalance());
            result = this.csPhysicsInventoryTotalDas.updateInventoryTotal(csPhysicsInventoryTotalEo);
        } else if (CsInventoryCoverInventoryFlagEnum.COVER.getCode().equals(coverInventoryFlag) && null != (csPhysicsInventoryEo = this.csPhysicsInventoryMapper.sumCargoInventory(inDetailDto.getCargoCode(), inDetailDto.getWarehouseCode()))) {
            csPhysicsInventoryTotalEo.setBalance(csPhysicsInventoryEo.getBalance());
            csPhysicsInventoryTotalEo.setAvailable(csPhysicsInventoryEo.getAvailable());
            csPhysicsInventoryTotalEo.setPreempt(csPhysicsInventoryEo.getPreempt());
            this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u7269\u7406\u4ed3\u603b\u8868\u66f4\u65b0 \u8986\u76d6,balance\uff1a{}", (Object)csPhysicsInventoryTotalEo.getBalance());
            result = this.csPhysicsInventoryTotalMapper.updateById((BaseEo)csPhysicsInventoryTotalEo);
        }
        return result > 0;
    }

    private boolean batchUpdateInventory(Long inventoryId, CsInventoryInOutBasicsCargoDto inDetailDto, CsInventoryInOutBasicsDto inParamDto) {
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u7269\u7406\u4ed3\u66f4\u65b0,inventoryId\uff1a{}", (Object)inventoryId);
        CsPhysicsInventoryEo csPhysicsInventoryEo = new CsPhysicsInventoryEo();
        CubeBeanUtils.copyProperties((Object)csPhysicsInventoryEo, (Object)inDetailDto, (String[])new String[0]);
        csPhysicsInventoryEo.setWarehouseId(inDetailDto.getWarehouseId());
        csPhysicsInventoryEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        csPhysicsInventoryEo.setCargoId(inDetailDto.getCargoId());
        csPhysicsInventoryEo.setCargoCode(inDetailDto.getCargoCode());
        csPhysicsInventoryEo.setIsGift(inDetailDto.getIsGift());
        csPhysicsInventoryEo.setBatch(inDetailDto.getBatch());
        csPhysicsInventoryEo.setId(inventoryId);
        csPhysicsInventoryEo.setNegativeValidate(inParamDto.getNegativeValidate());
        csPhysicsInventoryEo.setUpdateTime(new Date());
        csPhysicsInventoryEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        csPhysicsInventoryEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        csPhysicsInventoryEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csPhysicsInventoryEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        String coverInventoryFlag = inParamDto.getCoverInventoryFlag();
        int batchResult = 0;
        if (CsInventoryCoverInventoryFlagEnum.UPDATE.getCode().equals(coverInventoryFlag)) {
            batchResult = this.csPhysicsInventoryDas.updateInventory(csPhysicsInventoryEo);
        } else if (CsInventoryCoverInventoryFlagEnum.COVER.getCode().equals(coverInventoryFlag)) {
            batchResult = this.csPhysicsInventoryDas.updateSelective((BaseEo)csPhysicsInventoryEo);
        }
        if (batchResult <= 0) {
            return false;
        }
        if (batchResult <= 0) {
            return false;
        }
        Integer updateTotalFlag = inParamDto.getUpdateTotalFlag();
        if (null == updateTotalFlag || YesNoEnum.NO.getValue().equals(updateTotalFlag)) {
            return true;
        }
        Long totalId = this.totalExistInventory(inDetailDto);
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u7269\u7406\u4ed3\u66f4\u65b0,totalId\uff1a{}", (Object)totalId);
        this.totalUpdateInventory(totalId, inParamDto, inDetailDto);
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u7269\u7406\u4ed3\u3001\u603b\u8868\u66f4\u65b0\u7ed3\u675f");
        return true;
    }
}

