/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.ValidationUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsPhysicsWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsWarehouseAddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsPhysicsWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsWarehouseAddressMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseExposedAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPhysicsWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csPhysicsWarehouseExposedServiceImpl")
public class CsPhysicsWarehouseExposedServiceImpl
implements ICsPhysicsWarehouseExposedService {
    private static Logger logger = LoggerFactory.getLogger(CsPhysicsWarehouseExposedServiceImpl.class);
    @Autowired
    private CsPhysicsWarehouseMapper csPhysicsWarehouseMapper;
    @Autowired
    private CsWarehouseAddressMapper csWarehouseAddressMapper;

    @Override
    public Long addPhysicsWarehouse(CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto) {
        logger.info("addPhysicsWarehouse==>\u65b0\u589e\u7269\u7406\u4ed3\u4ed3\u5e93,csPhysicsWarehouseExposedAddReqDto:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseExposedAddReqDto));
        this.checkParams(csPhysicsWarehouseExposedAddReqDto);
        CsPhysicsWarehouseEo csPhysicsWarehouseEo = new CsPhysicsWarehouseEo();
        Long physicsWarehouseId = IdUtils.getId();
        csPhysicsWarehouseEo.setId(physicsWarehouseId);
        CubeBeanUtils.copyProperties((Object)csPhysicsWarehouseEo, (Object)csPhysicsWarehouseExposedAddReqDto, (String[])new String[0]);
        logger.info("addPhysicsWarehouse==>\u65b0\u589e\u7269\u7406\u4ed3\u4ed3\u5e93,csPhysicsWarehouseEo:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseEo));
        this.csPhysicsWarehouseMapper.insert((Object)csPhysicsWarehouseEo);
        CsWarehouseAddressEo warehouseAddressEo = new CsWarehouseAddressEo();
        CubeBeanUtils.copyProperties((Object)warehouseAddressEo, (Object)csPhysicsWarehouseExposedAddReqDto, (String[])new String[0]);
        warehouseAddressEo.setWarehouseId(physicsWarehouseId);
        warehouseAddressEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        warehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        logger.info("addPhysicsWarehouse==>\u65b0\u589e\u7269\u7406\u4ed3\u4ed3\u5e93,warehouseAddressEo:{}", (Object)LogUtils.buildLogContent(warehouseAddressEo));
        this.csWarehouseAddressMapper.insert((Object)warehouseAddressEo);
        return physicsWarehouseId;
    }

    @Override
    public Boolean updatePhysicsWarehouse(CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto) {
        logger.info("updatePhysicsWarehouse==>\u7f16\u8f91\u7269\u7406\u4ed3\u4ed3\u5e93,csPhysicsWarehouseExposedAddReqDto:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseExposedAddReqDto));
        this.checkParams(csPhysicsWarehouseExposedAddReqDto);
        Long physicsWarehouseId = csPhysicsWarehouseExposedAddReqDto.getId();
        AssertUtil.isTrue(null != physicsWarehouseId, "\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        CsPhysicsWarehouseEo originalEo = (CsPhysicsWarehouseEo)this.csPhysicsWarehouseMapper.selectById((Serializable)physicsWarehouseId);
        AssertUtil.isTrue(null != originalEo, "\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f");
        CubeBeanUtils.copyProperties((Object)originalEo, (Object)csPhysicsWarehouseExposedAddReqDto, (String[])new String[0]);
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"id", (Object)physicsWarehouseId);
        logger.info("updatePhysicsWarehouse==>\u7f16\u8f91\u7269\u7406\u4ed3\u4ed3\u5e93,originalEo:{}", (Object)LogUtils.buildLogContent(originalEo));
        int updateWarehouseFlag = this.csPhysicsWarehouseMapper.update((Object)originalEo, (Wrapper)updateWrapper);
        if (updateWarehouseFlag <= 0) {
            return false;
        }
        CsWarehouseAddressEo updateAddressEo = new CsWarehouseAddressEo();
        updateAddressEo.setValidFlag(CsValidFlagEnum.DISABLE.getCode());
        QueryWrapper updateAddressEoWrapper = new QueryWrapper();
        updateAddressEoWrapper.eq((Object)"warehouse_id", (Object)physicsWarehouseId);
        updateAddressEoWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        this.csWarehouseAddressMapper.update((Object)updateAddressEo, (Wrapper)updateAddressEoWrapper);
        CsWarehouseAddressEo warehouseAddressEo = new CsWarehouseAddressEo();
        CubeBeanUtils.copyProperties((Object)warehouseAddressEo, (Object)csPhysicsWarehouseExposedAddReqDto, (String[])new String[0]);
        warehouseAddressEo.setWarehouseId(physicsWarehouseId);
        warehouseAddressEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        warehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        logger.info("updatePhysicsWarehouse==>\u7f16\u8f91\u7269\u7406\u4ed3\u4ed3\u5e93,warehouseAddressEo:{}", (Object)LogUtils.buildLogContent(warehouseAddressEo));
        this.csWarehouseAddressMapper.insert((Object)warehouseAddressEo);
        return true;
    }

    private void checkParams(CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto) {
        AssertUtil.isTrue(null != csPhysicsWarehouseExposedAddReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getWarehouseName()), "\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseStatus = csPhysicsWarehouseExposedAddReqDto.getWarehouseStatus();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseStatus) && null != CsPhysicsWarehouseStatusEnum.getByCode((String)warehouseStatus), "\u4ed3\u5e93\u72b6\u6001\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getRdcFlag()) && (YesNoEnum.YES.getValue().equals(csPhysicsWarehouseExposedAddReqDto.getRdcFlag()) || YesNoEnum.NO.getValue().equals(csPhysicsWarehouseExposedAddReqDto.getRdcFlag())), "\u662f\u5426RDC\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getContacts()), "\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getPhone()) && ValidationUtils.checkMobile(csPhysicsWarehouseExposedAddReqDto.getPhone()), "\u8054\u7cfb\u4eba\u7535\u8bdd\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getProvince()) && StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getProvinceCode()), "\u7701\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getCity()) && StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getCityCode()), "\u5e02\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getDistrict()) && StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getDistrictCode()), "\u533a\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getDetailAddress()), "\u8be6\u7ec6\u5730\u5740\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getLatitude()), "\u7eac\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getLongitude()), "\u7ecf\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

