/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csOrderQueryServiceImpl")
public class CsOrderQueryServiceImpl
implements ICsOrderQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CsOrderQueryServiceImpl.class);
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;

    @Override
    public OrderDetailRespDto queryByOrderNo(String orderNo) {
        logger.info("\u6839\u636e\u8ba2\u5355\u7f16\u7801\uff0c\u83b7\u53d6\u8ba2\u5355\u660e\u7ec6,orderNo:{}", (Object)orderNo);
        ArrayList<OrderQueryEnum> attrs = new ArrayList<OrderQueryEnum>();
        attrs.add(OrderQueryEnum.ADDRESS);
        attrs.add(OrderQueryEnum.ITEM);
        attrs.add(OrderQueryEnum.ACTIVITY);
        RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(orderNo, StringUtils.join(attrs, (String)","));
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)restResponse.getData()), "\u6839\u636e\u8ba2\u5355\u7f16\u7801\uff0c\u83b7\u53d6\u8ba2\u5355\u660e\u7ec6\u5931\u8d25orderNo:" + orderNo);
        return (OrderDetailRespDto)restResponse.getData();
    }
}

