/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest.cs.inventory.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsLockOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLockOrderRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/csLockOrder"})
public class CsLockOrderRest
implements ICsLockOrderApi {
    private static Logger logger = LoggerFactory.getLogger(CsLockOrderRest.class);
    @Resource(name="${yunxi.dg.base.project}_LockOrderApi")
    ICsLockOrderApi csLockOrderApi;

    public RestResponse<PageInfo<CsLockOrderRespDto>> queryByPage(@Validated @RequestBody CsLockOrderQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto, (String[])new String[]{"pageNum", "pageSize"}));
        AssertUtil.emptyValidated((Object)queryDto, (String[])new String[]{"pageNum", "pageSize"});
        return this.csLockOrderApi.queryByPage(queryDto);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> updateLockInventory(String type, CsLockOrderUpdateReqDto updateReqDto) {
        return this.csLockOrderApi.updateLockInventory(type, updateReqDto);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Map<String, Integer>> batchUpdateLockInventory(String type, List<CsLockOrderUpdateReqDto> list) {
        return this.csLockOrderApi.batchUpdateLockInventory(type, list);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> manualUnLockInventory() {
        return this.csLockOrderApi.manualUnLockInventory();
    }
}

