/**
 * @(#) DirPropRelationModifyReqDto.java 1.0 2019-06-25
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 目录属性修改请求入参
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "DirPropRelationModifyReqDto", description = "目录属性修改请求入参")
public class DirPropRelationModifyReqDto extends BaseReqDto {
    /**
     * id
     */
    @ApiModelProperty(name = "id", value = "id，必填")
    private Long id;
    /**
     * 目录id
     */
    @ApiModelProperty(name = "dirId", value = "目录id，选填")
    private Long dirId;
    /**
     * 1 属性组 2属性
     */
    @ApiModelProperty(name = "propType", value = "类型 1 属性组 2属性，必填")
    private Integer propType;
    /**
     * 属性名ID
     */
    @ApiModelProperty(name = "propNameId", value = "属性名ID，propType=2时必填")
    private Long propNameId;
    /**
     * 属性组ID
     */
    @ApiModelProperty(name = "propGroupId", value = "属性组ID，propType=1时必填")
    private Long propGroupId;
    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户id，选填")
    private Long sellerId;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户id，必填")
    private Long tenantId;
    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID，必填")
    private Long instanceId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Integer getPropType() {
        return propType;
    }

    public void setPropType(Integer propType) {
        this.propType = propType;
    }

    public Long getPropNameId() {
        return propNameId;
    }

    public void setPropNameId(Long propNameId) {
        this.propNameId = propNameId;
    }

    public Long getPropGroupId() {
        return propGroupId;
    }

    public void setPropGroupId(Long propGroupId) {
        this.propGroupId = propGroupId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Long getInstanceId() {
        return instanceId;
    }

    @Override
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}
