/*
 * @(#)ItemSyncReqDto.java 1.0 2021年09月05日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * <p>Title:ItemSyncReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/5 10:59
 * @since 0.1.0
 */
@ApiModel(
        value = "ItemSyncReqDto",
        description = "SAP物料主数据单条信息回调请求Dto"
)
public class ItemSyncReqDto extends BaseReqDto {

    @ApiModelProperty(value = "物料名称", required = true)
    private String name;

    @ApiModelProperty(value = "物料编码", required = true)
    private String code;

    @ApiModelProperty(value = "计量单位", required = true)
    private String calcuUnit;

    @ApiModelProperty(value = "产品负责人", required = true)
    private String principalPerson;

    @ApiModelProperty(value = "北鼎产品型号", required = true)
    private String prodClassCode;

    @ApiModelProperty(value = "北鼎核算品类")
    private String accountingCategoryCode;

    @ApiModelProperty(value = "北鼎产品名称", required = true)
    private String prodClassName;

    @ApiModelProperty(value = "产品大类", required = true)
    private String prodLargeClass;

    @ApiModelProperty(value = "产品二级分类", required = true)
    private String prodSecClassify;

    @ApiModelProperty(value = "产品三级分类", required = true)
    private String prodThrClassify;

    @ApiModelProperty(value = "后台类目ID", required = true)
    private Long dirId;
    @ApiModelProperty(value = "后台类目名称", required = true)
    private String dirName;

    @ApiModelProperty(value = "EN（69码）", required = true)
    private String enCode;

    @ApiModelProperty(value = "毛重", required = true)
    private BigDecimal grossWeight;

    @ApiModelProperty(value = "净重", required = true)
    private BigDecimal netWeight;

    @ApiModelProperty(value = "重量单位", required = true)
    private String weightUnit;

    @ApiModelProperty(value = "规格单位", required = true)
    private String specsUnit;

    @ApiModelProperty(value = "内包装规格（PC长宽高）", required = true)
    private String pcSpecs;

    @ApiModelProperty(value = "长")
    private String length;
    @ApiModelProperty(value = "宽")
    private String width;
    @ApiModelProperty(value = "高")
    private String height;

    @ApiModelProperty(value = "外包装规格（CAR长宽高）", required = true)
    private String carSpecs;

    @ApiModelProperty(value = "换算因子", required = true)
    private String matrixing;

    @ApiModelProperty(value = "条形码", required = true)
    private String barCode;

    @ApiModelProperty(value = "产品实际上市日期")
    private String launchDate = null;

    @ApiModelProperty(value = "产品实际下市日期")
    private String delistingDate = null;

    @ApiModelProperty(value = "物料类型")
    private String materialType = null;

    /**
     * 产品组
     */
    @ApiModelProperty(value = "产品组")
    private String prodGroup = null;

    /**
     * 物料组
     */
    @ApiModelProperty(value = "物料组")
    private String materialGroup = null;

    /**
     * 产品层次
     */
    @ApiModelProperty(value = "产品层次")
    private String prodLevel = null;

    @ApiModelProperty(value = "品牌")
    private String brand;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCalcuUnit() {
        return calcuUnit;
    }

    public void setCalcuUnit(String calcuUnit) {
        this.calcuUnit = calcuUnit;
    }

    public String getPrincipalPerson() {
        return principalPerson;
    }

    public void setPrincipalPerson(String principalPerson) {
        this.principalPerson = principalPerson;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getEnCode() {
        return enCode;
    }

    public void setEnCode(String enCode) {
        this.enCode = enCode;
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }




    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }


    public String getWeightUnit() {
        return weightUnit;
    }

    public void setWeightUnit(String weightUnit) {
        this.weightUnit = weightUnit;
    }

    public String getMatrixing() {
        return matrixing;
    }

    public void setMatrixing(String matrixing) {
        this.matrixing = matrixing;
    }


    public String getPcSpecs() {
        return pcSpecs;
    }

    public void setPcSpecs(String pcSpecs) {
        this.pcSpecs = pcSpecs;
    }

    public String getCarSpecs() {
        return carSpecs;
    }

    public void setCarSpecs(String carSpecs) {
        this.carSpecs = carSpecs;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getSpecsUnit() {
        return specsUnit;
    }

    public void setSpecsUnit(String specsUnit) {
        this.specsUnit = specsUnit;
    }

    public String getProdClassCode() {
        return prodClassCode;
    }

    public void setProdClassCode(String prodClassCode) {
        this.prodClassCode = prodClassCode;
    }

    public String getProdClassName() {
        return prodClassName;
    }

    public void setProdClassName(String prodClassName) {
        this.prodClassName = prodClassName;
    }

    public String getLaunchDate() {
        return launchDate;
    }

    public void setLaunchDate(String launchDate) {
        this.launchDate = launchDate;
    }

    public String getDelistingDate() {
        return delistingDate;
    }

    public void setDelistingDate(String delistingDate) {
        this.delistingDate = delistingDate;
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getProdGroup() {
        return prodGroup;
    }

    public void setProdGroup(String prodGroup) {
        this.prodGroup = prodGroup;
    }

    public String getMaterialGroup() {
        return materialGroup;
    }

    public void setMaterialGroup(String materialGroup) {
        this.materialGroup = materialGroup;
    }

    public String getProdLevel() {
        return prodLevel;
    }

    public void setProdLevel(String prodLevel) {
        this.prodLevel = prodLevel;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getLength() {
        return length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getWidth() {
        return width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getProdThrClassify() {
        return prodThrClassify;
    }

    public void setProdThrClassify(String prodThrClassify) {
        this.prodThrClassify = prodThrClassify;
    }

    public String getAccountingCategoryCode() {
        return accountingCategoryCode;
    }

    public void setAccountingCategoryCode(String accountingCategoryCode) {
        this.accountingCategoryCode = accountingCategoryCode;
    }
}
