package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.SellerSkuPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.SellerSkuPriceRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
* 供应商和产品的供货价格服务接口
*
* @author 迪迦
* @since 2021-09-10
*/
@Api(tags = {"供应商和产品的供货价格服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-item-api-query-ISellerSkuPriceQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/sellerSkuPrice",
    url = "${yundt.cube.center.item.api:}"
)
public interface ISellerSkuPriceQueryApi {

    /**
    * 根据id查询供应商和产品的供货价格
    *
    * @param id 供应商和产品的供货价格id
    * @return   供应商和产品的供货价格数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询供应商和产品的供货价格", notes = "根据id查询供应商和产品的供货价格")
    RestResponse<SellerSkuPriceRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 供应商和产品的供货价格分页数据
    *
    * @param filter   供应商和产品的供货价格查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 供应商和产品的供货价格分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "供应商和产品的供货价格分页数据", notes = "根据filter查询条件查询供应商和产品的供货价格数据，filter=SellerSkuPriceReqDto")
    RestResponse<PageInfo<SellerSkuPriceRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     *  查询供货价
     *
     * @param sellerId  卖家
     * @param skuId
     * @return 供货价
     */
    @GetMapping("/getPrice")
    @ApiOperation(value = "根据经销商和商品查询供应商和产品的供货价格", notes = "根据经销商和商品查询供应商和产品的供货价格")
    RestResponse<BigDecimal> queryPrice(@RequestParam("sellerId") Long sellerId, @RequestParam("skuId") Long skuId);

    /**
     * 供应商和产品的供货价格list
     * @author 惜笔 | 林五弟
     * @date 2021/10/16 15:01
     * @param sellerSkuPriceReqDto      查询条件
     * @return com.dtyunxi.rest.RestResponse<List < SellerSkuPriceRespDto>>
     */
    @PostMapping("/list")
    @ApiOperation(value = "供应商和产品的供货价格list", notes = "供应商和产品的供货价格list")
    RestResponse<List<SellerSkuPriceRespDto>> queryList(@RequestBody SellerSkuPriceReqDto sellerSkuPriceReqDto);


}
