//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.dtyunxi.yundt.cube.center.item.api.b2b;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ManagementBlockSaveReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

@Api(
    tags = {"商品中心：经营屏蔽"}
)
@FeignClient(
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    contextId = "com-dtyunxi-yundt-cube-center-item-api-b2b-IManagementBlockApi",
    path = "/v1/management-block",
    url = "${yundt.cube.center.item.api:}"
)
public interface IManagementBlockApi {
    @PostMapping({"/save"})
    @ApiOperation(
        value = "保存指定sku经营屏蔽",
        notes = "屏蔽指定sku经营范围,经营区域,客户类型等(单个保存使用skuId,多个商品保存使用itemIds)"
    )
    RestResponse<Void> addOrModifyManagementBlock(@RequestBody @Valid ManagementBlockSaveReqDto itemStatReqDto);

    @GetMapping({"/cancel"})
    @ApiOperation(
        value = "批量取消指定sku经营屏蔽",
        notes = "取消屏蔽指定sku经营屏蔽,支持通过skuIdq取消经营屏蔽"
    )
    RestResponse<Void> cancelManagementBlock(@RequestParam("skuIds") List<Long> skuIds);
}
