/**
 * @(#) ItemTimingReqDto.java 1.0 2019-03-01
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品定时计划查询Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ShelfTaskQueryReqDto", description = "商品定时计划查询Dto")
public class ShelfTaskQueryReqDto extends BaseReqDto {
    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * 目录ID
     */
    @ApiModelProperty(name = "dirId", value = "目录ID")
    private Long dirId;
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * 规格ID
     */
    @ApiModelProperty(name = "skuId", value = "规格ID")
    private Long skuId;
    /**
     * 快照ID
     */
    @ApiModelProperty(name = "snapshotId", value = "快照ID")
    private Long snapshotId;
    /**
     * 起始时间
     */
    @ApiModelProperty(name = "startTime", value = "起始时间")
    private String startTime;
    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String endTime;
    /**
     * 定时任务类型(on上架 off下架)
     */
    @ApiModelProperty(name = "type", value = "定时任务类型(on上架 off下架)")
    private String type;
    /**
     * 状态(0未处理 1处理中 2处理成功 3处理失败 4取消)
     */
    @ApiModelProperty(name = "status", value = "状态(0未处理 1处理中 2处理成功 3处理失败 4取消)")
    private Integer status;

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSnapshotId() {
        return snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
