/*
 * @(#)IItemPriceQueryApi.java 1.0 2018-08-20
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PriceTypeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;

/**
 * 商品价格查询接口
 *
 * @author 零星
 * @since 2.0.0
 */
@Api(tags = {"商品中心：查询商品价格服务接口"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IItemPriceTypeQueryApi",
        path = "/v1/item/price",
        url = "${yundt.cube.center.item.api:}")
public interface IItemPriceTypeQueryApi {

    /**
     * 根据价格类型id查询价格类型详情信息
     *
     * @param id 主键
     * @return 统一返回响应对象，业务数据data为商品价格类型
     */
    @GetMapping(value = "/type/{id}")
    @ApiOperation(value = "根据价格类型id查询价格类型详情信息", notes = "根据价格类型id查询价格类型详情信息")
    RestResponse<PriceTypeRespDto> queryItemPriceTypeById(@NotNull @PathVariable("id") Long id);

    /**
     * 分页查询价格类型列表 filter -> PriceTypeReqDto
     *
     * @param filter   价格类型Dto
     * @param pageNum  页码
     * @param pageSize 每页记录数
     * @return 统一返回响应对象，业务数据data为商品价格类型
     */
    @GetMapping(value = "/type/list")
    @ApiOperation(value = "分页查询价格类型列表", notes = "分页查询价格类型列表，filter=PriceTypeReqDto")
    RestResponse<PageInfo<PriceTypeRespDto>> queryItemPriceTypeByPage(@RequestParam("filter") String filter,
                                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
