/*
 * @(#)ItemOffReqDto.java 1.0 2021年09月23日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * <p>Title:ItemOffReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/23 0:42
 * @since 0.1.0
 */
@ApiModel(value = "ItemOffReqDto", description = "下架响应Dto对象")
public class ItemOffReqDto extends BaseReqDto {

    @ApiModelProperty(
            name = "id",
            value = ""
    )
    private Long id;

    @ApiModelProperty(
            name = "itemId",
            value = "商品id，必填"
    )
    private Long itemId;
    @ApiModelProperty(
            name = "skuId",
            value = "规格Id，选填，填写时只下架该规格"
    )
    private Long skuId;
    @ApiModelProperty(
            name = "dirId",
            value = "目录id，选填，填写时只下架该目录的商品(商品可能会上架在多个目录)"
    )
    private Long dirId;
    @ApiModelProperty(
            name = "shopId",
            value = "店铺id，必填"
    )
    private Long shopId;
    @ApiModelProperty(
            name = "snapshotId",
            value = "快照id，选填"
    )
    private Long snapshotId;
    @ApiModelProperty(
            name = "isTiming",
            value = "是否定时下架 true/false，选填"
    )
    private boolean isTiming;
    @ApiModelProperty(
            name = "offTime",
            value = "定时下架时间，选填，配合isTiming使用，当isTiming为true时"
    )
    private Date offTime;
    @ApiModelProperty(
            name = "itemType",
            value = "商品类型:1普通商品 2积分商品"
    )
    private Integer itemType;
    @ApiModelProperty(
            name = "busType",
            value = "上架业务类型：0普通商品 1社区团购 2 积分商品"
    )
    private Integer busType;

    @ApiModelProperty(name = "shelfAddress",value = "下架商城")
    private String shelfAddress;

    public ItemOffReqDto() {
    }

    public Integer getBusType() {
        return this.busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getItemType() {
        return this.itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getDirId() {
        return this.dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getShopId() {
        return this.shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public boolean isTiming() {
        return this.isTiming;
    }

    public void setTiming(boolean timing) {
        this.isTiming = timing;
    }

    public Date getOffTime() {
        return this.offTime;
    }

    public void setOffTime(Date offTime) {
        this.offTime = offTime;
    }

    public String getShelfAddress() {
        return shelfAddress;
    }

    public void setShelfAddress(String shelfAddress) {
        this.shelfAddress = shelfAddress;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
