package com.dtyunxi.yundt.cube.center.item.api.b2b;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 客户商品授权规则服务接口
 *
 * @author cijian
 * @since 2022-11-14
 */
@Api(tags = {"客户商品授权规则服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-item-api-api-IAuthItemRuleApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/auth/item/rule",
        url = "${yundt.cube.center.item.api:}"
)
public interface IAuthItemRuleApi {

    /**
     * 新增客户商品授权规则
     *
     * @param addReqDto 客户商品授权规则请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增客户商品授权规则", notes = "新增客户商品授权规则")
    RestResponse<Long> addAuthItemRule(@RequestBody AuthItemRuleReqDto addReqDto);

    /**
     * 修改客户商品授权规则
     *
     * @param modifyReqDto 客户商品授权规则请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改客户商品授权规则", notes = "修改客户商品授权规则")
    RestResponse<Void> modifyAuthItemRule(@RequestBody AuthItemRuleReqDto modifyReqDto);
}
