package com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
@ApiModel(value = "MatchAuthItemRuleReqDto", description = "查询指定商品已授权客户")
public class MatchAuthItemRuleReqDto extends BaseVo {
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
     * 客户编号
     */
    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;
    /**
     * 商品ID
     */
    @NotNull(message = "商品Id不能为空")
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * 商品类型
     */
    @ApiModelProperty(name = "subType", value = "商品类型")
    private Integer subType;
    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brandId", value = "品牌Id")
    private Long brandId;
    /**
     * 组织id
     */
    @NotNull(message = "组织id不能为空")
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
     * 当前页数
     */
    @ApiModelProperty(name = "pageNum", value = "当前页数")
    private Integer pageNum = 1;
    /**
     * 每页大小
     */
    @ApiModelProperty(name = "pageSize", value = "每页大小")
    private Integer pageSize = 10;
}
