/*
 * @(#) ShelfIntegralReqDto.java 1.0 2020-10-14
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 积分上架额外信息 ReqDto
 *
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "ShelfIntegralReqDto", description = "积分上架额外信息")
public class ShelfIntegralReqDto extends RequestDto {
    /**
     * ${point.comment}
     */
    @ApiModelProperty(name = "id", value = "null")
    private Long id;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * 退换数量限制
     */
    @ApiModelProperty(name = "cashLimit", value = "退换数量限制")
    private Integer cashLimit;
    /**
     * 退换金额
     */
    @ApiModelProperty(name = "cashAmount", value = "退换金额")
    private BigDecimal cashAmount;
    /**
     * 上架id
     */
    @ApiModelProperty(name = "shelfId", value = "上架id")
    private Long shelfId;
    /**
     * 积分
     */
    @ApiModelProperty(name = "cashIntegral", value = "积分")
    private Long cashIntegral;
    /**
     * 兑换类型：1积分 2积分+金额
     */
    @ApiModelProperty(name = "cashType", value = "兑换类型：1积分2积分+金额")
    private Integer cashType;
    /**
     * 规则说明
     */
    @ApiModelProperty(name = "ruleRemark", value = "规则说明")
    private String ruleRemark;

    /**
     * ${point.comment}
     */
    @ApiModelProperty(name = "extension", value = "null")
    private String extension;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getShopId() {
        return this.shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getCashLimit() {
        return this.cashLimit;
    }

    public void setCashLimit(Integer cashLimit) {
        this.cashLimit = cashLimit;
    }

    public BigDecimal getCashAmount() {
        return this.cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public Long getShelfId() {
        return this.shelfId;
    }

    public void setShelfId(Long shelfId) {
        this.shelfId = shelfId;
    }

    public Long getCashIntegral() {
        return this.cashIntegral;
    }

    public void setCashIntegral(Long cashIntegral) {
        this.cashIntegral = cashIntegral;
    }

    public Integer getCashType() {
        return this.cashType;
    }

    public void setCashType(Integer cashType) {
        this.cashType = cashType;
    }

    public String getRuleRemark() {
        return this.ruleRemark;
    }

    public void setRuleRemark(String ruleRemark) {
        this.ruleRemark = ruleRemark;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }


}