/*
 * *
 *  * @(#)ItemBaseInfoRespDto.java 2.0.0 9/9/20, 2:12 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品基础信息响应Dto
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ItemBaseInfoRespDto", description = "商品基础信息响应Dto")
public class ItemDetailBaseInfoRespDto extends BaseVo {

    private static final long serialVersionUID = -3388725454546693136L;
    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;

    @ApiModelProperty(name = "displayName", value = "显示名")
    private String displayName;

    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    @ApiModelProperty(name = "brand_id", value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;

    @ApiModelProperty(name = "brief", value = "简介")
    private String brief;

    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;

    @ApiModelProperty(name = "type", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；")
    private Integer type;

    @ApiModelProperty(name = "spuId", value = "产品id")
    private Long spuid;

    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;

    @ApiModelProperty(name = "shelfAmount", value = "可卖数量=所有规格的可卖数量之和")
    private Long shelfAmount;

    @ApiModelProperty(name = "dirId", value = "商品目录Id")
    private Long dirId;

    @ApiModelProperty(name = "shopDirId", value = "店铺类目Id")
    private Long shopDirId;

    @ApiModelProperty(name = "shopDirName", value = "店铺类目名称")
    private String shopDirName;

    @ApiModelProperty(name = "itemSkuList", value = "SKU列表")
    private List<ItemSkuInfoRespDto> itemSkuList;

    @ApiModelProperty(name = "itemMediasList", value = "多媒体列表")
    private List<ItemMediasRespDto> itemMediasList;

    @ApiModelProperty(name = "dirsItemsList", value = "商品目录")
    private List<DirsItemsRespDto> dirsItemsList = Lists.newArrayList();

    @ApiModelProperty(name = "itemPropRelationRespDtos", value = "商品属性关联dto")
    private List<ItemPropRelationRespDto> itemPropRelationRespDtos;

    @ApiModelProperty(name = "activitySkus", value = "商品活动SKU列表")
    private List<ItemSkuInfoRespDto> activitySkus;

    @ApiModelProperty(name = "salePrice", value = "零售价")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "maxPrice", value = "最大售价")
    private Double maxPrice;

    @ApiModelProperty(name = "minPrice", value = "最小售价")
    private Double minPrice;

    @ApiModelProperty(name = "saleCount", value = "商品销量")
    private Long saleCount;

    @ApiModelProperty(name = "supplierId", value = "供应商id")
    private Long supplierId;

    @ApiModelProperty(name = "itemDefineAttrDto", value = "商品定义的属性信息")
    private String attrs;

    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购  默认0")
    private Integer busType;

    @ApiModelProperty(name = "shelfType", value = "上架类型:1普通上架  2周期购上架")
    private Integer shelfType;

    @ApiModelProperty(name = "周期购信息")
    private List<ItemCycleBuyRespDto> cycleBuyByShopItem;

    public List<ItemCycleBuyRespDto> getCycleBuyByShopItem() {
        return cycleBuyByShopItem;
    }

    public void setCycleBuyByShopItem(List<ItemCycleBuyRespDto> cycleBuyByShopItem) {
        this.cycleBuyByShopItem = cycleBuyByShopItem;
    }

    public Integer getShelfType() {
        return shelfType;
    }

    public void setShelfType(Integer shelfType) {
        this.shelfType = shelfType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Boolean getVitrual() {
        return vitrual;
    }

    public void setVitrual(Boolean vitrual) {
        this.vitrual = vitrual;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getSpuid() {
        return spuid;
    }

    public void setSpuid(Long spuid) {
        this.spuid = spuid;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getShopDirId() {
        return shopDirId;
    }

    public void setShopDirId(Long shopDirId) {
        this.shopDirId = shopDirId;
    }

    public String getShopDirName() {
        return shopDirName;
    }

    public void setShopDirName(String shopDirName) {
        this.shopDirName = shopDirName;
    }

    public List<ItemSkuInfoRespDto> getItemSkuList() {
        return itemSkuList;
    }

    public void setItemSkuList(List<ItemSkuInfoRespDto> itemSkuList) {
        this.itemSkuList = itemSkuList;
    }

    public List<ItemMediasRespDto> getItemMediasList() {
        return itemMediasList;
    }

    public void setItemMediasList(List<ItemMediasRespDto> itemMediasList) {
        this.itemMediasList = itemMediasList;
    }

    public List<DirsItemsRespDto> getDirsItemsList() {
        return dirsItemsList;
    }

    public void setDirsItemsList(List<DirsItemsRespDto> dirsItemsList) {
        this.dirsItemsList = dirsItemsList;
    }

    public List<ItemPropRelationRespDto> getItemPropRelationRespDtos() {
        return itemPropRelationRespDtos;
    }

    public void setItemPropRelationRespDtos(List<ItemPropRelationRespDto> itemPropRelationRespDtos) {
        this.itemPropRelationRespDtos = itemPropRelationRespDtos;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Double getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Double maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Double getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Double minPrice) {
        this.minPrice = minPrice;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public Long getSaleCount() {
        return saleCount;
    }

    public void setSaleCount(Long saleCount) {
        this.saleCount = saleCount;
    }

    public List<ItemSkuInfoRespDto> getActivitySkus() {
        return activitySkus;
    }

    public void setActivitySkus(List<ItemSkuInfoRespDto> activitySkus) {
        this.activitySkus = activitySkus;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }
}
