/*
 * @(#)ItemExternalReqDto.java 1.0 2021年11月11日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * <p>Title:ItemExternalReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/11/11 22:52
 * @since 0.1.0
 */
@ApiModel(value = "ItemExternalReqDto", description = "商品查询条件dto")
public class ItemExternalReqDto implements Serializable {

    @ApiModelProperty(
            name = "itemCode",
            value = "商品编码"
    )
    private String itemCode;
    @ApiModelProperty(
            name = "itemName",
            value = "商品名称"
    )
    private String itemName;
    @ApiModelProperty(
            name = "pageNum",
            value = "当前页"
    )
    private Integer pageNum;
    @ApiModelProperty(
            name = "pageSize",
            value = "每页数"
    )
    private Integer pageSize;

    @ApiModelProperty(
            name = "startTime",
            value = "开始时间(格式：YYYY-MM-DD)"
    )
    private String startTime;
    @ApiModelProperty(
            name = "endTime",
            value = "结束时间(格式：YYYY-MM-DD)"
    )
    private String endTime;

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}
