/*
 * @(#)ItemRelationExcelRespDto.java 1.0 2021年09月16日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>Title:ItemRelationExcelRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/16 15:37
 * @since 0.1.0
 */
@ApiModel(value = "ItemRelationExcelRespDto", description = "商品映射关系导出Dto对象")
public class ItemRelationExcelRespDto extends RequestDto {

    @ApiModelProperty(name = "code",value = "物料编码")
    @Excel(name = "物料编码")
    private String code;

    @ApiModelProperty(name = "name",value = "物料名称")
    @Excel(name = "物料名称")
    private String name;

    @ApiModelProperty(name = "prodLargeClass",value = "产品大类")
    @Excel(name = "产品大类")
    private String prodLargeClass;

    @ApiModelProperty(name = "prodSecClassify",value = "产品二级分类")
    @Excel(name = "产品二级分类")
    private String prodSecClassify;

    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    @Excel(name = "产品三级分类")
    private String prodThrClassify;

    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    @Excel(name = "产品型号")
    private String prodClassCode;

    @ApiModelProperty(name = "platformName",value = "关联平台")
    @Excel(name = "关联平台")
    private String platformName;

    @ApiModelProperty(name = "shopName",value = "店铺名称")
    @Excel(name = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "shopCode",value = "店铺ID")
    @Excel(name = "店铺ID")
    private String shopCode;

    @ApiModelProperty(name = "channelItemCode", value = "平台商品编码")
    private String channelItemCode;

    @ApiModelProperty(name = "channelItemName",value = "平台商品名称")
    @Excel(name = "平台商品名称")
    private String channelItemName;

    @ApiModelProperty(name = "skuId",value = "SKU编码")
    @Excel(name = "SKU编码")
    private String skuId;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getProdThrClassify() {
        return prodThrClassify;
    }

    public void setProdThrClassify(String prodThrClassify) {
        this.prodThrClassify = prodThrClassify;
    }

    public String getProdClassCode() {
        return prodClassCode;
    }

    public void setProdClassCode(String prodClassCode) {
        this.prodClassCode = prodClassCode;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getChannelItemCode() {
        return channelItemCode;
    }

    public void setChannelItemCode(String channelItemCode) {
        this.channelItemCode = channelItemCode;
    }

    public String getChannelItemName() {
        return channelItemName;
    }

    public void setChannelItemName(String channelItemName) {
        this.channelItemName = channelItemName;
    }

    public String getSkuId() {
        return skuId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }
}
