package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * @author yufan
 * @time 2020/10/15 10:33
 */
public enum UnitTypeEnum {

    WEIGHT("weight", "重量"),
    WEIGHT_KG("1259475063917443265", "千克"),
    WEIGHT_G("1259474907439495360", "克"),
    WEIGHT_MG("1259475100849338563", "毫克"),
    WEIGHT_T("1259475083722946754", "吨"),
    LENGTH("length", "长度"),
    AREA("area", "面积"),
    VOLUME("volume", "体积"),
    VOLUME_M3("1259474907439495361", "立方米"),
    VOLUME_CM3("1259475063917443262", "立方厘米"),
    VOLUME_DM3("1259475083722946755", "立方分米"),
    TIME("time", "时间"),
    NUMBER("number","数量");


    private String typeCode;
    private String desc;

    UnitTypeEnum(String typeCode, String desc) {
        this.typeCode = typeCode;
        this.desc = desc;
    }

    public static String getDesc(String typeCode) {
        for (UnitTypeEnum unitTypeEnum : UnitTypeEnum.values()) {
            if (unitTypeEnum.getTypeCode().equals(typeCode)) {
                return unitTypeEnum.getDesc();
            }
        }
        return null;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
