/*
 * @(#)ISupplierQueryApi.java 1.0 2020-03-10
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.communitybuy.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.SupplierRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 供应商表 查询api
 *
 * @author 简树
 * @since 2.0.0
 */
@Api(tags = {"商品中心:供应商服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-ISupplierQueryApi",
        path = "/v1/supplier",
        url = "${yundt.cube.center.item.api:}")
public interface ISupplierQueryApi {
    /**
     * 根据ID查询供应商表
     *
     * @param id 供应商表ID
     * @return SupplierRespDto 供应商表
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "根据ID供应商", notes = "根据ID供应商")
    RestResponse<SupplierRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分页供应商表
     *
     * @param filter   查询条件，json字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return SupplierRespDto 分页供应商表Dto分页列表
     */
    @GetMapping(value = "/list")
    @ApiOperation(value = "分页查询供应商", notes = "分页查询供应商")
    RestResponse<PageInfo<SupplierRespDto>> queryByPage(@RequestParam(name = "filter") String filter,
                                                        @RequestParam(name = "pageNum") Integer pageNum,
                                                        @RequestParam(name = "pageSize") Integer pageSize);

    /**
     * 查詢 供应商表
     *
     * @param filter 查询条件，json字符串
     * @return List<SupplierRespDto> 供应商表 列表
     */
    @GetMapping(value = "/no-page")
    @ApiOperation(value = "查询供应商表", notes = "查询供应商列表")
    RestResponse<List<SupplierRespDto>> queryByList(@RequestParam(name = "filter") String filter);
}