package com.dtyunxi.yundt.cube.center.item.api.dto.response.dg;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description ItemUnitConversionDgDto-商品规格单位换算表传输对象
 * @Author 代码生成器
 * @Date 2023-05-11 15:43:45
 * @TemplateVersion 1.0.0
 * @MD5Code 9209751ced2f10852e929f94b1d6b167
 **/

@Data
//@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "ItemUnitConversionDgDto", description = "商品规格单位换算表传输对象")
public class ItemUnitConversionDgDto extends BaseVo {
    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;
    @ApiModelProperty(name = "createTime", value = "创建时间,yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;
    @ApiModelProperty(name = "updateTime", value = "修改时间,yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "groupCode", value = "换算单位组编码")
    private String groupCode;

    @ApiModelProperty(name = "baseUnit", value = "基本单位")
    private String baseUnit;

    @ApiModelProperty(name = "baseUnitNum", value = "基本单位数量")
    private Integer baseUnitNum;

    @ApiModelProperty(name = "conversionUnit", value = "换算单位")
    private String conversionUnit;

    @ApiModelProperty(name = "conversionNum", value = "换算数量")
    private Integer conversionNum;

    @ApiModelProperty(name = "defaultOrders", value = "业务单默认单位，sale:销售订单，trans:调拨订单，prod:生厂订单")
    private String defaultOrders;

    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;

    @ApiModelProperty(name = "volumeUnit", value = "体积单位")
    private String volumeUnit;

    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;

    @ApiModelProperty(name = "weightUnit", value = "净重单位")
    private String weightUnit;

    @ApiModelProperty(name = "length", value = "长度")
    private BigDecimal length;

    @ApiModelProperty(name = "height", value = "高度")
    private BigDecimal height;

    @ApiModelProperty(name = "width", value = "宽度")
    private BigDecimal width;

    @ApiModelProperty(name = "sizeUnit", value = "尺寸单位")
    private String sizeUnit;

    @ApiModelProperty(name = "extension", value = "扩展字段")
    private String extension;
}