package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemShopPlatformRelationRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
* 商品与店铺平台关系表服务接口
*
* @author yiyun
* @since 2021-09-18
*/
@Api(tags = {"商品中心：商品与店铺平台关系表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IItemShopPlatformRelationQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item/shop/platform/relation",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemShopPlatformRelationQueryApi {

    /**
    * 根据id查询商品与店铺平台关系表
    *
    * @param id 商品与店铺平台关系表id
    * @return   商品与店铺平台关系表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询商品与店铺平台关系表", notes = "根据id查询商品与店铺平台关系表")
    RestResponse<ItemShopPlatformRelationRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 商品与店铺平台关系表分页数据
    *
    * @param filter   商品与店铺平台关系表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 商品与店铺平台关系表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "商品与店铺平台关系表分页数据", notes = "根据filter查询条件查询商品与店铺平台关系表数据，filter=ItemShopPlatformRelationReqDto")
    RestResponse<PageInfo<ItemShopPlatformRelationRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
