package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品分页
 *
 * @author sumo
 * @date 2020/11/6 0006
 */
@ApiModel(value = "ItemOnShelfRespDto", description = "商品分页")
public class ItemOnShelfRespDto extends BaseReqDto {


    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    @ApiModelProperty(name = "itemCode", value = " 商品编码  ")
    private String itemCode;
    @ApiModelProperty(name = "dirName", value = "后台目录名称")
    private String dirName;
    @ApiModelProperty(name = "dirId", value = "后台目录id")
    private Long dirId;
    @ApiModelProperty(name = "frontDirNames", value = "前台目录名称集合")
    private List<String> frontDirNames;
    @ApiModelProperty(name = "frontDirIds", value = "前台目录id集合")
    private List<Long> frontDirIds;
    @ApiModelProperty(name = "path", value = "商品图片")
    private String path;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "商品skuId")
    private Long skuId;

    @ApiModelProperty(name = "skuCode", value = "规格编号")
    private String skuCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "skuName", value = "规格名称")
    private String skuName;

    @ApiModelProperty(name = "skuName", value = "属性")
    private String attr;

    @ApiModelProperty(name = "itemNum", value = "购买数量")
    private Long itemNum;

    @ApiModelProperty(name = "sellPrice", value = "售价")
    private BigDecimal sellPrice;

    @ApiModelProperty(name = "retailPrice", value = "划线价")
    private BigDecimal retailPrice;

    @ApiModelProperty(name = "unit", value = "单位id")
    private String unit;

    @ApiModelProperty(name = "unitName", value = "单位")
    private String unitName;

    @ApiModelProperty(name = "shopId", value = "门店id")
    private Long shopId;

    @ApiModelProperty(name = "balance", value = "库存")
    private Long balance;


    @ApiModelProperty(name = "wholesaleLimitMin", value = "起订量")
    private Long wholesaleLimitMin;

    @ApiModelProperty(name = "wholesaleLimitMax", value = "限定量")
    private Long wholesaleLimitMax;

    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "itemSubType", value = "商品子类型,subType被其他类继承使用，并且是定义为String，所以这里只能这样定义")
    private Integer itemSubType;

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getItemSubType() {
        return itemSubType;
    }

    public void setItemSubType(Integer itemSubType) {
        this.itemSubType = itemSubType;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public List<Long> getFrontDirIds() {
        return frontDirIds;
    }

    public void setFrontDirIds(List<Long> frontDirIds) {
        this.frontDirIds = frontDirIds;
    }

    public List<String> getFrontDirNames() {
        return frontDirNames;
    }

    public void setFrontDirNames(List<String> frontDirNames) {
        this.frontDirNames = frontDirNames;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Long getItemNum() {
        return itemNum;
    }

    public void setItemNum(Long itemNum) {
        this.itemNum = itemNum;
    }

    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Long getWholesaleLimitMin() {
        return wholesaleLimitMin;
    }

    public void setWholesaleLimitMin(Long wholesaleLimitMin) {
        this.wholesaleLimitMin = wholesaleLimitMin;
    }

    public Long getWholesaleLimitMax() {
        return wholesaleLimitMax;
    }

    public void setWholesaleLimitMax(Long wholesaleLimitMax) {
        this.wholesaleLimitMax = wholesaleLimitMax;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
}
