/*
 * @(#)ItemSapMaterialClassDto.java 1.0 2021年10月12日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:ItemSapMaterialClassDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/10/12 2:43
 * @since 0.1.0
 */
@ApiModel(value = "ItemSapFrontlClassDto", description = "北鼎一级品类Dto对象")
public class ItemSapFrontlClassDto implements Serializable {

    @ApiModelProperty(name = "prodOneClass", value = "北鼎一级品类")
    private String prodOneClass;
    @ApiModelProperty(name = "prodOneClassName", value = "北鼎一级品类描述")
    private String prodOneClassName;
    @ApiModelProperty(name = "twoList", value = "北鼎二级品类List")
    private List<TwoList> twoList = Lists.newArrayList();

    public String getProdOneClass() {
        return prodOneClass;
    }

    public void setProdOneClass(String prodOneClass) {
        this.prodOneClass = prodOneClass;
    }

    public String getProdOneClassName() {
        return prodOneClassName;
    }

    public void setProdOneClassName(String prodOneClassName) {
        this.prodOneClassName = prodOneClassName;
    }

    public List<TwoList> getTwoList() {
        return twoList;
    }

    public void setTwoList(List<TwoList> twoList) {
        this.twoList = twoList;
    }

    @ApiModel(value = "TwoList", description = "北鼎二级品类Dto对象")
    public static class TwoList{
        @ApiModelProperty(name = "prodTwoClass", value = "北鼎二级品类")
        private String prodTwoClass;
        @ApiModelProperty(name = "prodTwoClassName", value = "北鼎二级品类描述")
        private String prodTwoClassName;
        @ApiModelProperty(name = "thirdList", value = "北鼎三级品类List")
        private List<ThirdList> thirdList = Lists.newArrayList();

        public String getProdTwoClass() {
            return prodTwoClass;
        }

        public void setProdTwoClass(String prodTwoClass) {
            this.prodTwoClass = prodTwoClass;
        }

        public String getProdTwoClassName() {
            return prodTwoClassName;
        }

        public void setProdTwoClassName(String prodTwoClassName) {
            this.prodTwoClassName = prodTwoClassName;
        }

        public List<ThirdList> getThirdList() {
            return thirdList;
        }

        public void setThirdList(List<ThirdList> thirdList) {
            this.thirdList = thirdList;
        }

        @ApiModel(value = "ThirdList", description = "北鼎三级品类Dto对象")
        public static class ThirdList{
            @ApiModelProperty(name = "prodThirdClass", value = "北鼎三级品类")
            private String prodThirdClass;
            @ApiModelProperty(name = "prodThirdClassName", value = "北鼎三级品类描述")
            private String prodThirdClassName;

            public String getProdThirdClass() {
                return prodThirdClass;
            }

            public void setProdThirdClass(String prodThirdClass) {
                this.prodThirdClass = prodThirdClass;
            }

            public String getProdThirdClassName() {
                return prodThirdClassName;
            }

            public void setProdThirdClassName(String prodThirdClassName) {
                this.prodThirdClassName = prodThirdClassName;
            }
        }
    }
}
