/**
 * @(#)PropNameCreateReqDto 1.0
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 新增属性名请求入参
 *
 * @author 双清
 */
@ApiModel(value = "PropNameCreateReqDto", description = "新增属性名请求入参")
public class PropNameCreateReqDto extends BaseReqDto {

    @ApiModelProperty(name = "code", value = "编码，选填")
    private String code;

    @ApiModelProperty(name = "name", value = "名称，必填")
    private String name;

    @ApiModelProperty(name = "inputType", value = "编辑方式：1 选择  2 输入")
    private Integer inputType;

    @ApiModelProperty(name = "required", value = "是否必选: 1 是 0 否")
    private Integer required;

    @ApiModelProperty(name = "charSizeLimit", value = "字符数限制")
    private Integer charSizeLimit;

    @ApiModelProperty(name = "prompt", value = "提示语")
    private String prompt;

    @ApiModelProperty(name = "description", value = "描述，选填")
    private String description;

    @ApiModelProperty(name = "sellerId", value = "商户id，选填")
    private Long sellerId;

    @ApiModelProperty(name = "tenantId", value = "租户id，必填")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "应用实例ID，必填")
    private Long instanceId;

    @ApiModelProperty(name = "propValueList", value = "属性值内容，inputType=1时必填")
    private List<String> propValueList;

    public Integer getRequired() {
        return required;
    }

    public void setRequired(Integer required) {
        this.required = required;
    }

    public Integer getCharSizeLimit() {
        return charSizeLimit;
    }

    public void setCharSizeLimit(Integer charSizeLimit) {
        this.charSizeLimit = charSizeLimit;
    }

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getInputType() {
        return inputType;
    }

    public void setInputType(Integer inputType) {
        this.inputType = inputType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Long getInstanceId() {
        return instanceId;
    }

    @Override
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<String> getPropValueList() {
        return propValueList;
    }

    public void setPropValueList(List<String> propValueList) {
        this.propValueList = propValueList;
    }
}