/*
 * @(#)FileItemExtendRespDto.java 1.0 2021年08月20日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * <p>Title:FileItemExtendRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/8/20 10:34
 * @since 0.1.0
 */
@ApiModel(value = "FileItemExtendRespDto",description = "FileItemExtendRespDto对象")
public class FileItemExtendReqDto extends BaseRespDto {


    @ApiModelProperty(name = "id",value = "id")
    private Long id;

    @ApiModelProperty(name = "department",value = "负责部门")
    @Excel(name = "负责部门")
    private String department;

    @ApiModelProperty(name = "materialsType",value = "物料类型")
    @Excel(name = "物料类型")
    private String materialsType;

    @ApiModelProperty(name = "code",value = "物料编码")
    @Excel(name = "物料编码")
    private String code;

    @ApiModelProperty(name = "name",value = "物料描述")
    @Excel(name = "物料描述")
    private String name;

    @ApiModelProperty(name = "calcuUnit",value = "基本计量单位")
    @Excel(name = "基本计量单位")
    private String calcuUnit;

    @ApiModelProperty(name = "code",value = "产品大类")
    @Excel(name = "产品大类")
    private String prodLargeClass;

    @ApiModelProperty(name = "productGroup",value = "产品组")
    @Excel(name = "产品组")
    private String productGroup;

    @ApiModelProperty(name = "prodSecClassify",value = "产品二级分类")
    @Excel(name = "产品二级分类")
    private String prodSecClassify;

    @ApiModelProperty(name = "enCode",value = "EN（69码）")
    @Excel(name = "EN（69码）")
    private String enCode;

    @ApiModelProperty(name = "grossWeight",value = "毛重")
    @Excel(name = "毛重")
    private String grossWeight;

    @ApiModelProperty(name = "netWeight",value = "净重")
    @Excel(name = "净重")
    private String netWeight;

    @ApiModelProperty(name = "unit",value = "重量单位")
    @Excel(name = "重量单位")
    private String unit;

    @ApiModelProperty(name = "pcSpecs",value = "内包装规格")
    @Excel(name = "内包装规格")
    private String pcSpecs;

    @ApiModelProperty(name = "code",value = "外包装规格")
    @Excel(name = "外包装规格（CAR长宽高）")
    private String carSpecs;

    @ApiModelProperty(name = "specsUnit",value = "规格单位")
    @Excel(name = "规格单位")
    private String specsUnit;


    @ApiModelProperty(name = "businessAmount",value = "业务量")
    @Excel(name = "业务量")
    private String businessAmount;

    @ApiModelProperty(name = "volumeUnit",value = "体积单位")
    @Excel(name = "体积单位")
    private String volumeUnit;

    @ApiModelProperty(name = "matrixing",value = "换算因子（装箱量）")
    @Excel(name = "换算因子（装箱量）")
    private String matrixing;

    @ApiModelProperty(name = "saleOrganization",value = "销售组织")
    @Excel(name = "销售组织")
    private String saleOrganization;


    @ApiModelProperty(name = "distributionChannel",value = "分销渠道")
    @Excel(name = "分销渠道")
    private String distributionChannel;

    @ApiModelProperty(name = "nwsiCode",value = "MWSI税码")
    @Excel(name = "MWSI税码")
    private String nwsiCode;

    @ApiModelProperty(name = "deliveryFactory",value = "交货工厂")
    @Excel(name = "交货工厂")
    private String deliveryFactory;

    @ApiModelProperty(name = "projectGroup",value = "项目类别组")
    @Excel(name = "项目类别组")
    private String projectGroup;

    @ApiModelProperty(name = "material_group",value = "物料运输组")
    @Excel(name = "物料运输组")
    private String material_group;

    @ApiModelProperty(name = "accountSettingGroup",value = "科目设置组")
    @Excel(name = "科目设置组")
    private String accountSettingGroup;

    @ApiModelProperty(name = "actualLaunchDate",value = "产品实际上市日期")
    @Excel(name = "产品实际上市日期")
    private String actualLaunchDate;

    @ApiModelProperty(name = "actualDelistingDate",value = "产品实际下市日期")
    @Excel(name = "产品实际下市日期")
    private String actualDelistingDate;

    @ApiModelProperty(name = "productGradeClassify",value = "商品的等级分类")
    @Excel(name = "商品的等级分类")
    private String productGradeClassify;

    @ApiModelProperty(name = "principalPerson",value = "产品负责人")
    @Excel(name = "产品负责人")
    private String principalPerson;

    @ApiModelProperty(name = "ingredientsShelfLife",value = "食材（保质期）")
    @Excel(name = "食材（保质期）")
    private String ingredientsShelfLife;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMaterialsType() {
        return materialsType;
    }

    public void setMaterialsType(String materialsType) {
        this.materialsType = materialsType;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getEnCode() {
        return enCode;
    }

    public void setEnCode(String enCode) {
        this.enCode = enCode;
    }

    public String getCalcuUnit() {
        return calcuUnit;
    }

    public void setCalcuUnit(String calcuUnit) {
        this.calcuUnit = calcuUnit;
    }

    public String getPrincipalPerson() {
        return principalPerson;
    }

    public void setPrincipalPerson(String principalPerson) {
        this.principalPerson = principalPerson;
    }

    public String getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(String grossWeight) {
        this.grossWeight = grossWeight;
    }

    public String getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(String netWeight) {
        this.netWeight = netWeight;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSpecsUnit() {
        return specsUnit;
    }

    public void setSpecsUnit(String specsUnit) {
        this.specsUnit = specsUnit;
    }

    public String getPcSpecs() {
        return pcSpecs;
    }

    public void setPcSpecs(String pcSpecs) {
        this.pcSpecs = pcSpecs;
    }

    public String getCarSpecs() {
        return carSpecs;
    }

    public void setCarSpecs(String carSpecs) {
        this.carSpecs = carSpecs;
    }

    public String getMatrixing() {
        return matrixing;
    }

    public void setMatrixing(String matrixing) {
        this.matrixing = matrixing;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getProductGroup() {
        return productGroup;
    }

    public void setProductGroup(String productGroup) {
        this.productGroup = productGroup;
    }

    public String getBusinessAmount() {
        return businessAmount;
    }

    public void setBusinessAmount(String businessAmount) {
        this.businessAmount = businessAmount;
    }

    public String getVolumeUnit() {
        return volumeUnit;
    }

    public void setVolumeUnit(String volumeUnit) {
        this.volumeUnit = volumeUnit;
    }

    public String getSaleOrganization() {
        return saleOrganization;
    }

    public void setSaleOrganization(String saleOrganization) {
        this.saleOrganization = saleOrganization;
    }

    public String getDistributionChannel() {
        return distributionChannel;
    }

    public void setDistributionChannel(String distributionChannel) {
        this.distributionChannel = distributionChannel;
    }

    public String getNwsiCode() {
        return nwsiCode;
    }

    public void setNwsiCode(String nwsiCode) {
        this.nwsiCode = nwsiCode;
    }

    public String getDeliveryFactory() {
        return deliveryFactory;
    }

    public void setDeliveryFactory(String deliveryFactory) {
        this.deliveryFactory = deliveryFactory;
    }

    public String getProjectGroup() {
        return projectGroup;
    }

    public void setProjectGroup(String projectGroup) {
        this.projectGroup = projectGroup;
    }

    public String getMaterial_group() {
        return material_group;
    }

    public void setMaterial_group(String material_group) {
        this.material_group = material_group;
    }

    public String getAccountSettingGroup() {
        return accountSettingGroup;
    }

    public void setAccountSettingGroup(String accountSettingGroup) {
        this.accountSettingGroup = accountSettingGroup;
    }

    public String getActualLaunchDate() {
        return actualLaunchDate;
    }

    public void setActualLaunchDate(String actualLaunchDate) {
        this.actualLaunchDate = actualLaunchDate;
    }

    public String getActualDelistingDate() {
        return actualDelistingDate;
    }

    public void setActualDelistingDate(String actualDelistingDate) {
        this.actualDelistingDate = actualDelistingDate;
    }

    public String getProductGradeClassify() {
        return productGradeClassify;
    }

    public void setProductGradeClassify(String productGradeClassify) {
        this.productGradeClassify = productGradeClassify;
    }

    public String getIngredientsShelfLife() {
        return ingredientsShelfLife;
    }

    public void setIngredientsShelfLife(String ingredientsShelfLife) {
        this.ingredientsShelfLife = ingredientsShelfLife;
    }
}
