/*
 * @(#)ee.java 1.0 2021年12月15日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

/**
 * <p>Title:ee</p>
 * <p>Description: </p>
 *
 * @author 花燃
 * @date 2021/12/15 16:25
 * @since 0.1.0
 */

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>Title:OrderItemPopularRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/10/18 11:52
 * @since 0.1.0
 */
@Data
@ApiModel(value = "OrderItemPopularRespDto", description = "OrderItemPopularRespDto")
public class OrderItemPopularRespDto implements Serializable {

    @ApiModelProperty(name = "id", value = "")
    private Long id;
    @ApiModelProperty(name = "instanceId", value = "实例Id")
    private Long instanceId;
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    @ApiModelProperty(name = "dirLevel", value = "后台类目层级")
    private String dirLevel;
    @ApiModelProperty(name = "dirId", value = "后台类目")
    private Long dirId;
    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;
    @ApiModelProperty(name = "dirPrefixLevel", value = "前台类目层级")
    private String dirPrefixLevel;
    @ApiModelProperty(name = "dirPrefixId", value = "前台类目")
    private Long dirPrefixId;
    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;
    @ApiModelProperty(name = "itemType", value = "商品类型: 1 普通商品, 2 产品, 3 组合商品, 4 虚拟商品，5 赠品商品")
    private String itemType;
    @ApiModelProperty(name = "specContent", value = "规格")
    private String specContent;
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    @ApiModelProperty(name = "skuCode", value = "skuCode")
    private String skuCode;
    @ApiModelProperty(name = "skuName", value = "skuName")
    private String skuName;
    @ApiModelProperty(name = "saleCount", value = "销量")
    private Long saleCount;
    @ApiModelProperty(name = "inventoryQuantity", value = "库存数据")
    private Long inventoryQuantity;
    @ApiModelProperty(name = "price", value = "价格")
    private String price;
    @ApiModelProperty(name = "medias", value = "商品多媒体")
    private List<ItemMediasRespDto> medias = Lists.newArrayList();
    @ApiModelProperty(name = "imagePath", value = "商品主图")
    private String imagePath;

    @ApiModelProperty(name = "type", value = "1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private Integer type;

    @ApiModelProperty(name = "subItemCodeMap", value = "subItemCodeMap")
    private Map<String, Integer> subItemCodeMap;

}
