package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemChannelRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemComparisonRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtRelationComparisonReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemCenterListRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 商品关系对照表服务接口
*
* @author yiyun
* @since 2021-09-08
*/
@Api(tags = {"商品中心：商品关系对照表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemRelationComparisonApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/itemext/relation",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtRelationComparisonApi {

    /**
    * 新增商品关系对照表
    *
    * @param addReqDto 商品关系对照表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增商品关系对照表", notes = "新增商品关系对照表")
    RestResponse<Long> addItemRelationComparison(@RequestBody ItemExtRelationComparisonReqDto addReqDto);

    /**
     * 新增商品映射关系 (前端新增时，一对多条情况)
     * @param relationReqDto
     * @return
     */
    @PutMapping("/addComparisonRelation")
    @ApiOperation(value = "新增商品映射关系", notes = "新增商品映射关系")
    RestResponse<Long> addComparisonRelation(@RequestBody ItemComparisonRelationReqDto relationReqDto);

    /**
    * 修改商品关系对照表
    *
    * @param modifyReqDto 商品关系对照表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改商品关系对照表", notes = "修改商品关系对照表")
    RestResponse<Void> modifyItemRelationComparison(@RequestBody ItemExtRelationComparisonReqDto modifyReqDto);

    /**
    * 删除商品关系对照表
    *
    * @param ids        商品关系对照表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品关系对照表", notes = "删除商品关系对照表")
    RestResponse<Void> removeItemRelationComparison(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 删除平台商品关系
     * @param ids
     * @return
     */
    @DeleteMapping("/del")
    @ApiOperation(value = "删除平台商品关系", notes = "删除平台商品关系")
    RestResponse<Void> removeItemRelationComparison(@RequestBody List<String> ids);

    /**
     * 删除映射关系
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    @ApiOperation(value = "删除商品关系对照表", notes = "删除商品关系对照表")
    RestResponse<Void> deleteRelationById(@RequestParam("id") Long id);


    /**
     * 批量新增渠道商品对应关系
     * @param channelRelationReqDtos
     * @return
     */
    @PostMapping("/batchItemRelation")
    @ApiOperation(value = "批量新增渠道商品对应关系",notes = "批量新增渠道商品对应关系")
    RestResponse<Void> addChannelItemRelation(@RequestBody List<ItemChannelRelationReqDto> channelRelationReqDtos);

    /**
     * 商品对照关系导入
     * @param comparisonReqDtos
     * @return
     */
    @PostMapping("/relationImport")
    @ApiOperation(value = "商品对照关系导入",notes = "商品对照关系导入")
    RestResponse<Void> relationImport(@RequestBody List<ItemComparisonRelationReqDto> comparisonReqDtos);


    /**
     * 根据渠道商品查询中台商品信息
     * @param channelRelationReqDtos
     * @return
     */
    @PostMapping("/getCenterItemByChannelItem")
    @ApiOperation(value = "根据渠道商品查询中台商品信息", notes = "根据渠道商品查询中台商品信息")
    RestResponse<List<ItemCenterListRespDto>> getCenterItemByChannelItem(@RequestBody List<ItemChannelRelationReqDto> channelRelationReqDtos);

    /**
     * 根据ID批量取消关联SKU
     *
     * @param ids
     * @return
     */
    @PostMapping("/updateRelationStateNo")
    @ApiOperation(value = "根据ID批量取消关联SKU", notes = "根据ID批量取消关联SKU")
    RestResponse<Void> updateRelationStateNo(@RequestBody List<Long> ids);

    /**
     * 批量更新或插入平台商品关联数据
     *
     * @param reqDtoList
     * @return
     */
    @PostMapping("/updateOrInsertItemRelation")
    @ApiOperation(value = "批量更新或插入平台商品关联数据", notes = "批量更新或插入平台商品关联数据")
    public RestResponse<Void> updateOrInsertItemRelation(@RequestBody List<ItemExtRelationComparisonReqDto> reqDtoList);
}
