/**
 * @(#)IItemSkuApi 1.0 2019/4/25
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author shuangqing  2019/4/25
 */
@Api(tags = {"商品中心：商品规格服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-IItemSkuApi",
        path = "/v1/item/sku",
        url = "${yundt.cube.center.item.api:}")
public interface IItemSkuApi {
    /**
     * 新增商品规格sku
     *
     * @param itemBundleReqDtos 商品组合请求dto列表(含sku、价格、多媒体、标签)
     * @return
     */
    @PostMapping(value = "")
    @ApiOperation(value = "新增商品规格sku", notes = "新增商品规格sku")
    RestResponse<Void> addItemSku(@Validated @RequestBody List<ItemBundleReqDto> itemBundleReqDtos);

    /**
     * 修改商品规格sku
     *
     * @param itemBundleReqDtos 商品组合请求dto列表(含sku、价格、多媒体、标签)
     * @return
     */
    @PutMapping(value = "")
    @ApiOperation(value = "修改商品规格sku", notes = "修改商品规格sku")
    RestResponse<Void> modifyItemSku(@Validated @RequestBody List<ItemBundleReqDto> itemBundleReqDtos);

    /**
     * 更换商品关联的店铺类目信息
     * @param shopId
     * @param dirId
     * @param itemId
     * @return
     */
    @PutMapping(value = "/modify-dirShop")
    @ApiOperation(value = "更换商品关联的店铺类目信息", notes = "更换商品关联的店铺类目信息")
    RestResponse<Void> modifyDirItemRelation(@RequestParam("shopId") Long shopId,
                                             @RequestParam("dirId") Long dirId,
                                             @RequestParam("itemId") Long itemId);

    /**
     * 删除商品规格sku
     *
     * @param skuIds     商品规格Sku主键Id列表
     * @param instanceId 实例ID
     * @param tenantId   租户ID
     * @return 删除数据行数
     */
    @DeleteMapping(value = "/{ids}")
    @ApiOperation(value = "删除商品规格sku", notes = "删除商品规格sku")
    RestResponse<Integer> removeItemSku(@NotNull(message = "规格id不能为空") @PathVariable("ids") List<Long> skuIds,
                                        @RequestParam("instanceId") Long instanceId,
                                        @RequestParam("tenantId") Long tenantId);

    /**
     * 编辑商品Sku规格信息
     * @param itemSkuReqDtos
     * @return
     */
    @PutMapping(value = "/modify-detail")
    @ApiOperation(value = "编辑商品Sku规格信息", notes = "编辑商品Sku快速上下架或设置价格、修改零售价")
    RestResponse<Void> modifyItemSkuDetail(@Validated @RequestBody List<ItemSkuReqDto> itemSkuReqDtos,
                                           @RequestParam("shopId") Long shopId, @RequestParam("itemId") Long itemId);

}
