/**
 * @(#)PropGroupReqDto 1.0 2018-11-29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 属性组请求入参
 *
 * @author 双清
 */
@ApiModel(value = "PropGroupReqDto", description = "属性组请求入参")
public class PropGroupReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键id，新增时可为空，修改时必填")
    private Long id;

    @ApiModelProperty(name = "code", value = "分组编码，新增修改查询时选填")
    private String code;

    @ApiModelProperty(name = "name", value = "分组名称，新增时必填，修改时选填")
    private String name;

    @ApiModelProperty(name = "description", value = "描述，选填")
    private String description;

    @ApiModelProperty(name = "sellerId", value = "商户id，选填")
    private Long sellerId;

    @ApiModelProperty(name = "tenantId", value = "租户id，必填")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "应用实例ID，必填")
    private Long instanceId;

    @ApiModelProperty(name = "propNameReqDto", value = "属性名实体，新增修改时选填")
    private List<PropNameReqDto> propNameReqDtos;

    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime", value = "创建时间--范围开始")
    private String createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建时间--范围结束")
    private String createEndTime;
    /**
     * 更新开始时间
     */
    @ApiModelProperty(name = "updateBeginTime", value = "更新时间--范围开始")
    private String updateBeginTime;
    /**
     * 更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = "更新时间--范围结束")
    private String updateEndTime;

    @ApiModelProperty(name = "dirId", value = "组合查询条件--目录ID")
    private Long dirId;

    @ApiModelProperty(name = "propGroupUsageType", value = "属性组用途")
    private Integer propGroupUsageType;

    @ApiModelProperty(name = "propName", value = "属性名")
    private String propName;

    public String getPropName() {
        return propName;
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public Integer getPropGroupUsageType() {
        return propGroupUsageType;
    }

    public void setPropGroupUsageType(Integer propGroupUsageType) {
        this.propGroupUsageType = propGroupUsageType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Long getInstanceId() {
        return instanceId;
    }

    @Override
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<PropNameReqDto> getPropNameReqDtos() {
        return propNameReqDtos;
    }

    public void setPropNameReqDtos(List<PropNameReqDto> propNameReqDtos) {
        this.propNameReqDtos = propNameReqDtos;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }
}